{ Include file for wbibbrws containing code for following hyperlinks }

type
  PVerifySpawn = ^TVerifySpawn;
  TVerifySpawn = object(TBasicDialog)
    S: PString;
    constructor init(AParent: PWindowsObject; AS: PString);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok; 
  end;

constructor TVerifySpawn.init(AParent: PWindowsObject; AS: PString);
begin
  TBasicDialog.init(AParent,PChar(rc_VerifySpawn));
  S:=AS;
end;

procedure TVerifySpawn.SetupWindow;
var
  F: array[0..255] of char;
begin
  TBasicDialog.SetupWindow;
  InitPos;
  StrPCopy(F,S^);
  SetDlgItemText(HWindow,dl_HRunEBox,F);
end;                    { TVerifySpawn.SetupWindow }

procedure TVerifySpawn.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
begin
  if not CanClose then Exit;
  GetDlgItemTExt(HWindow,dl_HRunEBox,F,255);
  if StrLen(F)=0 then messagebeep(0)
  else begin
    S^:=StrPas(F); EndDlg(id_ok);
  end;
end;                { TVerifySpawn.ok }

procedure TBrowseWindow.CopyHyper(var Msg: TMessage);
var
  tmp: string;
begin
  tmp:=PHyperLinkObj(DisplayArea^.HyperLinks.at(HyperInd))^.Link^;
  SubstituteHyper(Entry,tmp);
  CopyFieldToClip(@Self,Entry,-1,false,false,@tmp);
end;                { TBrowseWindow.CopyHyper }

type
  PRetrievingURLDlg = ^TRetrievingURLDlg;
  TRetrievingURLDlg = object(TDialog)
    Fname,URL: array[0..255] of char;
    TimerIsActive: boolean;
    constructor init(AParent: PWindowsObject; AURL,AFName: PString);
    procedure   SetupWindow; virtual;
    procedure   BeginProgress(var Msg: TMessage); virtual wm_First+bib_RetrieveURL;
    procedure   wmTimer(var Msg: TMessage);       virtual wm_First+wm_Timer;
    procedure   ok(var Msg: TMessage);            virtual id_first+id_ok;
    procedure   wmDestroy(var Msg: TMessage);     virtual wm_First+wm_Destroy;
    destructor  Done; virtual;
  end;

{ TRetrieveURLDlg methods }

constructor TRetrievingURLDlg.init(AParent: PWindowsObject;AURL,AFName: Pstring);
begin
  TDialog.init(Aparent,PChar(rc_RetrieveURLDlg));
  StrPCopy(FName,AFName^);
  StrPCopy(URL,AURL^);
  TimerIsActive:=false;
end;                 { TRetrievingURLDlg.init }

procedure TRetrievingURLDlg.SetupWindow;
var
  Msg: TMessage;
  F: array[0..255] of char;
  S: string;
begin
  TDialog.SetupWindow;
  RetrievingURLDlg:=@Self;
  Msg.wParam:=1;
  GetDlgItemText(HWindow,dl_RetrieveURLStatic,F,255);
  S:=StrPas(F);
  StrRepl(S,'%s',StrPas(URL),1,255,255);
  StrPCopy(F,S);
  SetDlgItemText(HWindow,dl_RetrieveURLStatic,F);
{  Button:=GetItemHandle(id_cancel);}
  if WWWBeginProgressOn then BeginProgress(Msg);
end;                      { TRetrievingURLDlg.SetupWindow }

procedure TRetrievingURLDlg.BeginProgress(var Msg: TMessage);
begin
  if Msg.wParam=1 then   { BeginProgress }
  begin
    SetWindowText(Hwindow,'Transferring...');
    SetTimer(HWindow,1,500,Nil);
    TimerIsActive:=true;
  end;
end;                  { TRetrievingURLDlg.BeginProgress }

procedure TRetrievingURLDlg.wmTimer(var Msg: TMessage);
var
  SRec: TSearchRec;
begin
  FindFirst(FName,faAnyFile,SRec);
  if DosError<>0 then cancel(Msg)
  else if SRec.Size<>0 then ok(msg);
end;                     { TRetrievingURLDlg.wmTimer }

procedure TRetrievingURLDlg.ok(var Msg: TMessage);
var
  SRec: TSearchRec;
begin
  if TimerIsActive then KillTimer(HWindow,1); TimerIsActive:=false;
  FindFirst(FName,faAnyFile,SRec);
  if (DosError=0) and (SRec.Size<>0) then EndDlg(id_ok) else EndDlg(id_cancel);
  {
  begin
    Success^:=true; cancel(Msg);
  end else cancel(Msg);
  }
end;               { TRetrievingURLDlg.ok }

procedure TRetrievingURLDlg.wmDestroy(var Msg: TMessage);
begin
  if TimerIsActive then KillTimer(HWindow,1);
  TimerIsActive:=false;
  RetrievingURLDlg:=Nil;
  TDialog.wmDestroy(Msg);
  WWWBeginProgressOn:=false;
end;

destructor TRetrievingURLDlg.Done;
begin
  RetrievingURLDlg:=Nil;
  TDialog.Done;
end;

function TBrowseWindow.UploadRemoteFile(URL: string; var fname: String;
                    Wait: boolean): boolean;
var
  ServHsz, TopHsz, ItemHsz: Hsz;
  ConverHdl      : HConv;
  Data: HDDEData;
  WaitDlg: PRetrievingURLDlg;
  Mess: TMsg;
  fl: file;
  T: TOpenFileName;
  Prompt: boolean;
  i: integer;
  Err,Attrib: word;
  Result: Longint;
  F: array[0..255] of char;
  tmp,N,E: pstring;
  NonWaitingCursor: HCursor;

procedure TidyUp;
begin
  AllocStrings(false,@tmp,@N,@E,Nil);
end;

begin                { UploadRemoteFile }
  UploadRemoteFile:=false;
  WWWBeginProgressOn:=false;
  fname:='';
  if not WWWBrowser.Active then
  begin
    ErrorMessageRC(Str_NoBrowserDefined,''); Exit;
  end;

  AllocStrings(true,@tmp,@N,@E,Nil);
  prompt:=false;
  { Extract filename from URL string }
  i:=Pos(',',URL);
  if i>0 then { explicit filename included }
  begin
    fname:=Copy(URL,i+1,255); ChrDelL(fname,' ');
    URL:=Copy(URL,1,i-1); ChrDelR(URL,' ');
    if fname='*' then
    begin
      fname:=''; Prompt:=true; i:=0;
    end;
  end;
  if i=0 then
  begin
    i:=length(URL);
    while (i>0) and (URL[i]<>'/') and (URL[i]<>'\') do dec(i);
    fname:=Copy(URL,i+1,255);    {the filename component }
    i:=length(fname);
    while (i>0) and (fname[i]<>'.') do dec(i);
    { Translate to 8+3 format if necessary }
    if not LFNAble then
    begin
      if i=0 then
      begin
        N^:=fname; E^:='';
      end else
      begin
        N^:=Copy(fname,1,i-1); E^:=Copy(fname,i,255);
      end;
      for i:=1 to length(N^) do
        if not (N^[i] in (FilenameSet-['\',':','.'])) then N^[i]:='_';
      for i:=1 to length(E^) do
        if not (E^[i] in (FilenameSet-['\',':'])) then E^[i]:='_';
      fname:=N^+E^;
    end;
  end;

  if Prompt then    { Ask for filename }
  begin
    FillChar(T,sizeof(T),0);
    StrPCopy(F,fname);
    with T do
    begin
      lStructSize:=sizeof(T);
      hWndOwner:=HWindow;
      tmp^:=AnyFileFilter;
      lpstrFilter:=@tmp^[1];
      lpstrFile:=@F;
      nMaxFile:=255;
      lpstrTitle:='Upload location';
      Flags:=Ofn_HideReadOnly or ofn_NoReadOnlyReturn or ofn_OverwritePrompt
             or ofn_PathMustExist;
      if LFNAble then flags:=flags or ofn_LongNames;
    end;
    if not GetSaveFilename(T) then
    begin
      TidyUp; Exit;
    end;
    fname:=StrPas(F);
  end;

  { Attach the upload directory to the filename }
  if Pos('\',fname)=0 then
  begin
    tmp^:=StrPas(WWWUploadDir);
    if (tmp^<>'') and (tmp^[1]='%') then
    begin
      delete(tmp^,1,1); tmp^:=GetEnv(tmp^);
    end;
    if tmp^='' then tmp^:=ProgramDir^; if tmp^[length(tmp^)]<>'\' then tmp^:=tmp^+'\';
    fname:=tmp^+fname;
  end;
  LFNNew(fl,false); LFNAssign(fl,fname);
  if (LFNGetFAttr(fl,Attrib)=0) and not (prompt or
               YesNoRC(Str_FileAlreadyExists,fname)) then
  begin
    TidyUp; Exit;
  end;
  if LFNRewrite(fl,0)<>0 then
  begin
    ErrorMessageRC(Str_CantOpenFile,fname); Exit;
  end;
  LFNClose(fl); LFNErase(fl); LFNDispose(fl);

  if not connect(WWWBrowser.DDEService,WWWOpenURLName,ServHsz,
                 TopHsz,ConverHdl) then       { Server not active }
  begin
    Err:=DdeGetLastError(Inst);
    Disconnect(ServHsz,TopHsz,ConverHdl);
    if (Err<>DMLERR_NO_CONV_ESTABLISHED) then { DDE error }
      ErrorMessage(DdeError(Err))
    else begin      { DDE server not loaded }
      StrPCopy(F,StrPas(WWWBrowser.Path));
      HyperEx_RunClass(HWindow,Entry,F);
      if not connect(WWWBrowser.DDEService,WWWOpenURLName,ServHsz,
        TopHsz,ConverHdl) then
      begin
        ErrorMessageRC(Str_CantFindApp,'');
        TidyUp; Exit;     { Can't run server }
      end;
    end;
  end;

  tmp^:=WWWBrowser.LoadFileString^;
  StrRepl(tmp^,'{SERVICE}',StrPas(ServiceName),1,255,255);
  StrRepl(tmp^,'{URL}',URL,1,255,255);
  StrRepl(tmp^,'{FILE}',fname,1,255,255);
  StrPCopy(F,tmp^);

  result:=-1;
  ItemHSz := DdeCreateStringHandle(Inst,F,cp_WinAnsi);
  Data:=DDEClientTransaction(Nil,0,ConverHdl,
               ItemHsz,cf_Text,Xtyp_Request,DdeTimeout,Nil);
  if Data=0 then ErrorMessage(DdeError(DdeGetLastError(Inst)))
  else begin
    Result:=PLongint(DdeAccessData(Data,Nil))^;
    DdeUnaccessData(Data);
    DdeFreeDataHandle(Data);
  end;
  DdeFreeStringHandle(Inst,ItemHsz);
  Disconnect(ServHsz,TopHsz,ConverHdl);
  if Result>0 then                { Successful launch }
  begin
    if Wait then                  { Start off the "modal" message loop }
      UploadRemoteFile:=Application^.ExecDialog(New(PRetrievingURLDlg,
            init(@Self,@URL,@fname)))=id_ok
    else UploadRemoteFile:=true;
  end;
  TidyUp;
end;                     { UploadRemoteFile }

procedure TBrowseWindow.FollowHyper(var Msg: TMessage);
var
  tmp: string;
  F: array[0..255] of char;
  P,P1: PChar;

function RunApp(var S: string): boolean;
begin
  StrPCopy(F,S); RunApp:=HyperEx_RunClass(HWindow,Entry,F);
end;                      { RunApp }

procedure Cite(S: string);
var
  fname: string;
  i: integer;
  accept: boolean;
  selection: SelectionType;
begin
  SubstituteHyper(Entry,S);
  ChrDelL(S,' '); ChrDelR(S,' '); fname:='';
  if StrPosLI(S,'\file'+lbrace)=1 then   { Change file }
  begin
    i:=7;
    while (i<=length(S)) and (S[i]<>rbrace) do inc(i);
    if i<=length(S) then
    begin
      fname:=Copy(S,7,i-7); Delete(S,1,i); ChrDelL(S,' ');
      ChrDelR(fname,' '); ChrDelL(fname,' '); accept:=false;
      if fname<>'' then
      begin
        if Pos('://',fname)=0 then   { file }
          FileChoose(fname,DefExtension[BibTeXFormat]^,TexInputList,NormalFileAttr,
             false,true,false,Nil,'BibFile:',
             DatabaseDesc,accept)
        else Accept:=UploadRemoteFile(fname,fname,true);
      end;
      if not accept then Exit;
    end;
  end;
  if S='' then Exit;
  if fname<>'' then
  begin
    Selection[1]:=0;
    CanonicalFname(fname);
    i:=1;
    while (i<=MaxBibFiles) and
      (StrCmpI(BibFiles^[i].name,fname,1,1,255)<>0) do inc(i);
    if i>MaxBibFiles then   { New file }
    begin
      if Linked then ErrorMessageRC(Str_FarCiteWhileLinked,'')
      else begin
        Selection[1]:=CFile_Open; InputStr^:=fname; MacroCommand:=true;
      end;
    end else                { File already loaded }
      if not Linked then Selection[1]:=i+CFile_List-1;
    if Selection[1]<>0 then
    begin
      DealWithFiles(Entry,Pattern,Selection);
      if Failure then Exit;
    end;
    if Entry^.name=S then
    begin
      Update; DisplayArea^.Scroller^.ScrollTo(0,0);
      Exit;
    end;
  end;
  if Entry^.name=S then Exit;
  LabelSearchString^:=#1+Chr(ExactMatch)+S;
  DealWithGoto(Entry,Pattern,0,false,false,false,CGoto_Label);
  Update; DisplayArea^.Scroller^.ScrollTo(0,0);
end;                   { Cite }

procedure DDETag(S: string);
var
  Service,Topic,Command: array[0..255] of char;
  ServHsz, TopHsz, ItemHsz: Hsz;
  ConverHdl      : HConv;
  i,nbr: integer;
  FailRun: string;
  Err: word;
  IsRequest: boolean;

procedure ParseDDECommand(var S: string);
var
  i: integer;
  tmp: string;
begin
  i:=Pos(',',S); tmp:=Copy(S,1,i-1); ChrDel(tmp,' ');
  StrPCopy(Service,tmp); Delete(S,1,i); ChrDelL(S,' ');
  if StrPosLI(S,'REQ:')=1 then
  begin
    IsRequest:=true;
    Delete(S,1,4); ChrDelL(S,' ');
  end;
  i:=Pos(',',S); tmp:=Copy(S,1,i-1); ChrDel(tmp,' ');
  StrPCopy(Topic,tmp); Delete(S,1,i); ChrDelL(S,' '); ChrDelR(S,' ');
  StrPCopy(Command,S);
end;                   { ParseDDECommand }

begin                { DDETag }
  SubstituteHyper(Entry,S);
  if ChrQty(S,',')<2 then
  begin
    ErrorMessageRC(Str_DDETagError,''); Exit;
  end;
  FailRun:=''; ChrDelL(S,' '); tmp:='';
  ItemHsz:=0; IsRequest:=false;
  if StrPosLI(S,'\fail'+lbrace)=1 then
  begin
    i:=7; nbr:=1;
    while (i<=length(S)) and (nbr>0) do
    begin
      if S[i]=lbrace then inc(nbr)
      else if S[i]=rbrace then dec(nbr);
      if nbr>0 then FailRun:=FailRun+S[i];
      inc(i);
    end;
    ChrDelL(FailRun,' '); ChrDelR(FailRun,' ');
    Delete(S,1,i-1);
    if (S<>'') and (S[1]=lbrace) then
    begin
      i:=2; nbr:=1;
      while (i<=length(S)) and (nbr>0) do
      begin
        if S[i]=lbrace then inc(nbr)
        else if S[i]=rbrace then dec(nbr);
        if nbr>0 then tmp:=tmp+S[i];
        inc(i);
      end;
      ChrDelL(tmp,' '); ChrDelR(tmp,' ');
      Delete(S,1,i-1); ChrDelL(S,' ');
      if tmp='' then tmp:=S;
    end;
{    message('"'+FailRun+'", "'+S2+'", "'+S+'"');}
  end;
  ParseDDECommand(S);
  if not connect(Service,Topic,ServHsz,TopHsz,ConverHdl) then
  begin
    Err:=DdeGetLastError(Inst);
    if (Err<>DMLERR_NO_CONV_ESTABLISHED) or (FailRun='') then
    begin         { DDE error or no backup - announce error }
      ErrorMessage(DdeError(Err));
      Disconnect(ServHsz,TopHsz,ConverHdl);
      Exit;
    end;
    { Backup supplied }
    Disconnect(ServHsz,TopHsz,ConverHdl);
    if not RunApp(FailRun) or (tmp='') then Exit;
    { Anpther DDE command supplied }
    ParseDDECommand(tmp);
    if not connect(Service,Topic,ServHsz,TopHsz,ConverHdl) then
    begin        { Second command failed as well }
      ErrorMessage(DdeError(DdeGetLastError(Inst)));
      Disconnect(ServHsz,TopHsz,ConverHdl);
      Exit;
    end;
  end;
  if IsRequest then
  begin
    ItemHSz := DdeCreateStringHandle(Inst, Command,   cp_WinAnsi);
    if DDEClientTransaction(Nil,0,ConverHdl,
               ItemHsz,cf_Text,Xtyp_Request,DdeTimeout,Nil)=0
                 then ErrorMessage(DdeError(DdeGetLastError(Inst)));
    DdeFreeStringHandle(Inst,ItemHsz);
  end else
  begin
    if DDEClientTransaction(@Command,StrLen(Command)+1,ConverHdl,
               0,cf_Text,Xtyp_Execute,DdeTimeout,Nil)=0 then
      ErrorMessage(DdeError(DdeGetLastError(Inst)));
  end;
  Disconnect(ServHsz,TopHsz,ConverHdl);
end;                  { DDETag }

procedure HRefClass(var S: string);
var
  ServHsz, TopHsz, ItemHsz: Hsz;
  ConverHdl      : HConv;
  Err: word;
begin                { HRefClass }
  if not WWWBrowser.Active then Exit;
  SubstituteHyper(Entry,S);
  if not connect(WWWBrowser.DDEService,WWWOpenURLName,ServHsz,TopHsz,ConverHdl) then
  begin
    Err:=DdeGetLastError(Inst);
    Disconnect(ServHsz,TopHsz,ConverHdl);
    if (Err<>DMLERR_NO_CONV_ESTABLISHED) then { DDE error }
      ErrorMessage(DdeError(Err))
    else begin      { DDE server not loaded }
      StrPCopy(F,StrPas(WWWBrowser.Path)+' '+S);
      HyperEx_RunClass(HWindow,Nil,F);
    end;
  end else    { DDE server active }
  begin
    tmp:=WWWBrowser.LoadURLString^;
    StrRepl(tmp,'{SERVICE}',StrPas(ServiceName),1,255,255);
    StrRepl(tmp,'{URL}',S,1,255,255);
    StrPCopy(F,tmp);
    ItemHSz := DdeCreateStringHandle(Inst,F,cp_WinAnsi);
    if DDEClientTransaction(Nil,0,ConverHdl,
               ItemHsz,cf_Text,Xtyp_Request,DdeTimeout,Nil)=0
                 then ErrorMessage(DdeError(DdeGetLastError(Inst)));
    DdeFreeStringHandle(Inst,ItemHsz);
    Disconnect(ServHsz,TopHsz,ConverHdl);
  end;
end;                  { HRefClass }

procedure FTPClass(S: string);
var
  fname: string;
begin
  SubstituteHyper(Entry,S);
  UploadRemoteFile(S,fname,false);
end;

procedure MailClass(S: PChar);
var
  F,P,P1: Pchar;
  len: longint;
  tmp: string;
begin
  if LoadMAPI and UseMAPI then HyperEx_MailClass(HWindow,Entry,S)
  else begin
    len:=StrLen(S); GetMem(F,len+2);
    StrCopy(F,S);
    P:=@F; while (P^=' ') do inc(P);
    P1:=Nil;
    if P^='"' then
    begin
      inc(P); P1:=StrScan(P,'"');
    end else P1:=StrScan(P,',');
    if P1<>Nil then
    begin
      P1^:=#0;
      P1:=P;
      repeat
        P1:=StrScan(P1,';'); if P1<>Nil then P1^:=',';
      until P1=Nil;
    end;
{    if P^<>#0 then Message('mailto:'+StrPas(P));}
    if P^<>#0 then
    begin
      if StrLen(P)>255-7 then P[255-7]:=#0;
      tmp:='mailto:'+StrPas(P); HRefClass(tmp);
    end;
    FreeMem(F,len+2);
  end;
end;                 { MailClass }

procedure UserClass(Ltype: integer; S: string);
begin
  StrPCopy(F,S);
  Hyper_UserClassExpand(Entry,LType,F); S:=StrPas(F);
  case HyperTypesArr^[LType].Htype of
    Hyper_Cite: Cite(S); 
    Hyper_Run:  HyperEx_RunClass(HWindow,Nil,F);
    Hyper_DDE:  DDETag(S);
    Hyper_Help: HyperEx_HelpClass(Nil,HWindow,S);
    Hyper_Href: HRefClass(S);
    Hyper_FTP:  FTPClass(S);
    Hyper_MAIL: MailClass(F);
  end;
end;      { UserClass }

begin                     { FollowHyper }
  with PHyperLinkObj(DisplayArea^.HyperLinks.at(HyperInd))^ do
  begin
    if not Active then Exit;
    if Ltype=Hyper_cite then Cite(Link^)             { Cite tag }
    else if LType=Hyper_DDE  then DDETag(Link^)      { DDE tag  }
    else if LType=Hyper_Href then HRefClass(Link^)   { WWW      }
    else if LType=Hyper_FTP  then FTPClass(Link^)    { WWW save to file }
    else if LType=Hyper_Help then HyperEx_HelpClass(Entry,HWindow,Link^)   { WinHelp  }
    else if LType=Hyper_Mail then MailClass(PLink)   { Mail tag }
    else if Ltype=Hyper_run  then                    { RUN tag  }
    begin
      tmp:=Link^;
      if HyperTypesArr^[Hyper_Run].Flags and HClass_on=0 then
        ErrorMessageRC(Str_HRunForbidden,'')
      else if (HyperTypesArr^[Hyper_Run].Flags and HRun_Verify=0) or
       (Application^.ExecDialog(New(PVerifySpawn,
           init(@Self,@tmp)))=id_ok) then RunApp(tmp);
    end else                                         { User-defined tags }
    begin
      if HyperTypesArr^[Ltype].app=Nil then
        ErrorMessageRC(Str_NoHyperApp,HyperTypesArr^[Ltype].pre^)
      else UserClass(Ltype,Link^);
    end;
  end;
end;                     { TBrowseWindow.FollowHyper }
