/* fatal.h 2.9.0 92/07/06 */

#ifndef __FATAL__H__
#define __FATAL__H__

#include "stdc.h"

/*
 *  Can't use the STDC "..." notation because I am using varargs
 *  Whose silly idea was it to have an ellipsis in the syntax of
 *  a programming language anyway?
 *
 *  pfatal(...)	-- does perror(...) and exit(1)
 *  fatal(...)	-- does error(...) and exit(1)
 *  syntax(...)	-- does error(...) and exit(2)
 *
 *  perror(...)	-- does error(...), prints message for errno
 *      progname: ...: Not found\n   or   , errno = 567
 *  error(...) 	-- does ... message like
 *	progname: ... \n
 */
#ifdef __STDC__
void NONRETURNING
	pfatalf(const char *, ...),
	fatalf(const char *, ...),
	syntaxf(const char *, ...);
void	perrorf(const char *, ...),
	errorf(const char *, ...);
#else
void NONRETURNING pfatalf(), fatalf(), syntaxf();
void 	perrorf(), errorf();
#endif
/*
void	vperrorf ARGS((const char *, va_list));
void	verrorf	ARGS((const char *, va_list));
*/

#endif
