/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class ExpandAfter
extends Primitive
implements Expandable {
    public ExpandAfter() {
        this("expandafter");
    }

    public ExpandAfter(String string) {
        super(string, true);
    }

    @Override
    public Object clone() {
        return new ExpandAfter(this.getName());
    }

    protected void pushTo(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        byte by = TeXObjectList.POP_IGNORE_LEADING_SPACE;
        TeXObject teXObject = teXObjectList.popToken(by);
        if (teXObject instanceof Group) {
            teXObjectList.push(TeXParserUtils.expandOnce(teXObject, teXParser, teXObjectList), true);
            teXObject = teXObjectList.popToken(by);
        }
        TeXObject teXObject2 = teXObjectList.popToken(by);
        teXObject2 = TeXParserUtils.resolve(teXObject2, teXParser);
        if (teXParser.isDebugMode(32)) {
            teXParser.logMessage("EXPANDAFTER: FIRST: " + teXObject + ". SECOND: " + teXObject2);
        }
        if (teXParser.isDebugMode(16)) {
            teXParser.logMessage("EXPANDAFTER: FIRST: " + teXObject.toString(teXParser) + ". SECOND: " + teXObject2.toString(teXParser));
        }
        TeXObject teXObject3 = TeXParserUtils.expandOnce(teXObject2, teXParser, teXObjectList);
        teXObjectList2.push(teXObject3, true);
        teXObjectList2.push(teXObject);
        if (teXParser.isDebugMode(32)) {
            teXParser.logMessage("EXPANDED: " + teXObjectList2);
        }
        if (teXParser.isDebugMode(16)) {
            teXParser.logMessage("EXPANDED: " + teXObjectList2.toString(teXParser));
        }
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        this.pushTo(teXParser, teXObjectList, teXObjectList2);
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        this.pushTo(teXParser, teXParser, teXObjectList);
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).expandfully(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.pushTo(teXParser, teXObjectList, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.pushTo(teXParser, teXParser, teXParser);
    }
}

