# 排版示例库

[English Version](README-en.md)

这里展示了 luatex-cn 的真实排版作品。每个示例都是一个完整的古籍还原项目，从设置参数到最终 PDF 都可以查看和学习。

---

## 📚 四部经典

### 🎭 《史记·五帝本纪》— 古籍的标准范本

![史记五帝本纪](./首页展示/shiji-bw.png)

**这个例子展示了什么**
- 🏤 印章覆盖 — 绝对定位的红色印章透明贴在文字上
- 📜 乌丝栏 — 传统的竖直细线格纹
- 🔖 版心 — 书名、卷号、页码的完整版心系统
- 📝 夹注 — 复杂的双栏注释自动排列
- ✨ 楷体刻本风格 — 模仿手刻的古籍气韵

**[查看源码](./史记五帝本纪/史记.tex)** | **[查看 PDF](./史记五帝本纪/史记.pdf)**

---

### 📖 《四库全书简明目录》— 清代风雅的目录学

![四库全书目录](./首页展示/mulu-color.png)

**这个例子展示了什么**
- 📐 标准行款 — 严格的"八行二十一字"规范
- 🎨 黄色装饰 — 古籍中的尊贵配色
- ⬜ 白口四周 — 双实线边框的优雅版式
- 🐟 单鱼尾 — 清代版心的典型标记

**[查看源码](./四库全书简明目录/目录.tex)** | **[查看 PDF](./四库全书简明目录/目录.pdf)**

---

### ✍️ 《红楼梦·甲戌本》— 评点本的艺术

![红楼梦甲戌本](./首页展示/honglou-p1.png)

**这个例子展示了什么**
- 💬 脂砚斋评批 — 眉批与侧批的精妙位置
- 📝 双列小字 — 同行中并排的注文排版
- 🖋️ 手写感 — 脱离网格约束的自由版式
- 📄 无装饰版心 — 纯文字的简洁版式

**[查看源码](./红楼梦甲戌本/石头记.tex)** | **[查看 PDF](./红楼梦甲戌本/石头记.pdf)**

---

### 🌍 《史记·秦楚之际月表》— 现代竖排书籍

![现代竖排](./首页展示/juan16-p1.png)

**这个例子展示了什么**
- 📚 现代繁体竖排 — 当代古籍阅读的需求
- 🚫 无古籍装饰 — 清爽现代的极简版式
- 🔤 现代标点 — 繁体标点的规范应用

**[查看源码](./史记卷六·现代/卷十六.tex)** | **[查看 PDF](./史记卷六·现代/卷十六.pdf)**

---

## 🎯 如何使用这些例子

### 1. 直接阅读 PDF
每个项目都有完成的 PDF 文件，可以直接浏览排版效果。

### 2. 查看源码学习
打开 `.tex` 文件，看看 luatex-cn 的命令如何使用：
```bash
cat 史记五帝本纪/史记.tex
```

### 3. 自己编译试试
在示例目录编译：
```bash
lualatex 史记.tex
```

### 4. 修改参数试验
每个 `.cfg` 模板文件都可以编辑，改变页面大小、颜色、版心等。

---

## 💡 学习路线

**第一次接触？**
→ 从 《四库全书简明目录》 开始，这是最简洁的古籍排版。

**想做自己的古籍？**
→ 模仿 《史记五帝本纪》 的源码结构，它是功能最完整的例子。

**需要批注和评点？**
→ 参考 《红楼梦甲戌本》，了解侧批和眉批的实现。

**做现代竖排书籍？**
→ 看 《秦楚之际月表》，这是最简洁的现代风格。

---

## 📁 每个例子的文件结构

```
示例目录/
├── 源码.tex          ← 主要的 LaTeX 文件
├── 源码.pdf          ← 最终输出的 PDF
├── 模板.cfg          ← 页面参数配置（可选）
├── 印章.png          ← 装饰图片（如果需要）
└── README.md         ← 该例子的详细说明
```

---

## 🔗 更多资源

- **[完整文档](https://github.com/open-guji/luatex-cn/wiki)** — Wiki 用户手册
- **[命令速查](https://github.com/open-guji/luatex-cn/wiki/Command-Reference)** — 所有命令的参数
- **[全书复刻](../全书复刻/)** — 更大规模的复刻项目

---

**开始你的古籍排版之旅！** 🚀
