#!/bin/sh
# file: bahyph.sh Version: 1.0
#          First version:     97/02/20
version=1.0
#    This script generates TeX hyphenation patterns for Basque
#    and was written by (c) Juan M. Aguirregabiria, 1997
#    based on the shyphen.sh file by Julio Sanchez, which
#    generates the hyphenation patterns for Spanish
#    The copyright notice below applies to this script as well,
#    read it before using this software.
#
# Usage: script [TeX] [ftc] [isolatin1]
#
#	TeX	\~n and \~N are done as in plain TeX and LaTeX
#		but without the escape character: ~n, ~N
#	ftc	these characters are specified using the
#		ftc conventions: 'n, 'N
#	isolatin1 means using the respective character codes in
#		IS 8859/1 (ISO Latin Alphabet 1)
#
# Default is no support for diacritics. You can use combinations
# of the above and the number of patterns will grow fast.
#
# Recommended options:
#
# isolatin1 	if you have TeX 3.0 with DC/EC fonts or ML-TeX
# TeX 		if you don't have the above
# ftc 		if you are used to ftc and don't have the above
#
# h is not here.
consonants="b d g j k l m n r w y"
# Open vowels: a e o
vop="a o"
# Closed vowels: i u
vcl="i"
# Groups that cannot be broken.
legal="rd ny rn ng rl ly rr"
isolatin1=0
ftc=0
TeX=0
options="basic"
for i
do
	if [ $i = "ftc" ]
	then
		ftc=1
		options="$options ftc"
	elif [ $i = "TeX" ]
	then
		TeX=1
		options="$options TeX"
	elif [ $i = "isolatin1" ]
	then
		isolatin1=1
		options="$options isolatin1"
	else
		echo -n Usage: `basename $0`
		echo " [TeX] [ftc] [isolatin1]"
		exit 1
	fi
done
if [ $ftc -ne 0 ]
then
	consonants="$consonants 'n"
fi
if [ $TeX -ne 0 ]
then
	consonants="$consonants ~n"
fi
if [ $isolatin1 -ne 0 ]
then
	consonants="$consonants ^^f1"
fi
vowels="$vop $vcl"
echo "\
% Hyphenation patterns for Basque.
% This file has been written by Juan M. Aguirregabiria
% (wtpagagj@lg.ehu.es) on February 1997 and is based
% on the shyphen.sh script that generates the Spanish patterns 
% as compiled by Julio Sanchez (jsanchez@gmv.es) on September 1991.
% The original Copyright follows and applies also to this file
% whose last version will be always available by anonymous ftp
% from tp.lc.ehu.es or by poynting your Web browser to
% http://tp.lc.ehu.es/basque.html
%
% Hyphenation patterns for Spanish.
% Compiled by Julio Sanchez (jsanchez@gmv.es) on September 1991.
% These patterns have been derived from \"On Word Division in Spanish\",
% Jos'e A. Ma~nas, Communications of the ACM, and implemented in his
% package ftc. You can get ftc and a draft of the abovementioned
% paper from goya.dit.upm.es in src/text.proc/ftc.Z. FTP access may
% be available. Otherwise, send help to info@goya.dit.upm.es for
% details on use of the mail server.
%
% Rules mentioned below are those described in that paper. After
% several unsatisfactory attempts to pretend I knew better, these 
% patterns closely follow that paper. Pattern 'tl' is not considered. 
% It is conflictive and ftc does not use it either.
%
% These patterns have been generated by shyphen.sh version $version, 
% shyphen.sh is a sh script that allows a number of choices. 
% Full benefit from some of these options can only be
% obtained if appropriate fonts are available.
%
% Follows a copyright notice. This is not in the public domain,
% but the copyright is essentially a hold-harmless clause. That
% is, use it at will, but don't sue me if you don't like it.
%
%			COPYRIGHT NOTICE
%
% These patterns and the generating sh script are Copyright (c) GMV 1991
% These patterns were developed for internal GMV use and are made
% public in the hope that they will benefit others. Also, spreading
% these patterns throughout the Spanish-language TeX community is
% expected to provide back-benefits to GMV in that it can help keeping
% GMV in the mainstream of spanish users. However, this is given
% for free and WITHOUT ANY WARRANTY. Under no circumstances can Julio
% Sanchez, GMV, Jos'e A. Ma~nas or any agents or representatives thereof 
% be held responsible for any errors in this software nor for any damages
% derived from its use, even in case any of the above has been notified
% of the possibility of such damages. If any such situation arises, you
% responsible for repair. Use of this software is an explicit
% acceptance of these conditions. 
% 
% You can use this software for any purpose. You cannot delete this
% copyright notice. If you change this software, you must include 
% comments explaining who, when and why. You are kindly requested to 
% send any changes to tex@gmv.es. If you change the generating 
% script, you must include code in it such that any output is clearly
% labeled as generated by a modified script.
%
% Despite the lack of warranty, we would like to hear about any
% problem you find. Please report problems to tex@gmv.es.
%
%               END OF COPYRIGHT NOTICE
%
% Options included in this set: $options
% Open vowels: $vop
% Closed vowels: $vcl
% Consonants: $consonants
%
% Some of the patterns below represent combinations that never
% happen in Basque. Would they happen, they would be hyphenated
% according to the rules."
echo
echo "\
% This keeps {cat|lc}code changes, if any, local. Nice to users of
% multilingual versions. These are the minimum changes needed to process
% the patterns. These and other changes will have to be re-enacted when
% Basque be established as the current language. See the babel docs if
% you don't understand this.
\begingroup"
if [ $ftc -ne 0 ]
then
	echo "\catcode\`'=12 \lccode\`'=\`'"
fi
if [ $TeX -ne 0 ]
then
	echo "\catcode\`~=12 \lccode\`~=\`~"
fi
if [ $isolatin1 -ne 0 ]
then
	echo "\
\catcode\`\^^f1=11 \lccode\`\^^f1=\`\^^f1    % ~n"
fi
echo "\
\patterns{
% Rule SR1
% Vowels are kept together by the defaults"
echo "\
% Rule SR2
% Attach vowel groups to left consonant"
for i in $consonants
do
	for j in $vowels
	do
		echo -n 1${i}${j}" "
	done
	echo
done
echo "\
% Rule SR3
% Build legal consonant groups, leave other consonants bound to 
% the previous group. This overrides part of the SR2 pattern
% group."
for i in $legal
do
	set `echo $i | sed -e 's/^./& /'`
	for j in $vowels
	do
		echo -n 1${1}2${2}${j}" "
	done
	echo
done
echo "\
% We now avoid some problematic breaks.
su2b2r su2b2l"
echo "}"
echo "\endgroup"
