# Modulename  : t-pocketdiary

## Editorial

Author      : Willi Egger
License     : Public Domain
Version     : 2023-04-15


## Description

For those who are in need of a personal organizer this module offers a flexible solution based on a single sided printed A4. The pocket diary can be folded in such a way, that it forms a small booklet where only the printed pages are visible (see documentation).

The basic idea is to have to change only minimal information for getting an updated PocketDiary after first setup.
The personal organizer is based on week number and year. You can specify also a day number if you want a page containing  only that day. You can specify a month if you want the personal organizer to contain a month table.

Please refer to the documentation for further options.

This module is a overhauled version of the previous module. It is built for the use with MKIV and LUAMETATEX (LMTX). In addition to the first version it is also calculating moon cycle and the sunrise and sunset time.

## Usage

Create a file e.g. PocketDiary.tex

\usemodule[pocketdiary]

% Setup the bodyfont
\setupbodyfont[palatino,rm,9pt]

% Setup the language used: en, de, nl, it, fr, es and pl interface is available
\mainlanguage[en]

% Setup the variables for the calculations

\setvariables
  [PocketDiary]
  [WeekDay=1,
   Week=17,
   Month=5,
   Year=2023,
   Nextyear=no,
   Daybyday=no]

% Setup the personal organizer: 
\setvariables
  [PocketDiaryLayout]
  [Page1=Lost-Returnto,  
   Page2=Weekplan,
   Page3=Dayplan,
   Page4=Monthcurrentplan,
   Page5=Blank,
   Page6=Lines,
   Page7=Caro,
   Page8=Contact]

% Setup variables with personal information
\setvariables
	[PocketDiaryAddress]
	[Familyname=Yourfamiliname,
	Forename=Yourname,
	Street=Yourstreet xx
	Zipcode=Yourzip
	City=Yourcity,
	Country=Yourcountry
	Phone=+Yourphonenumber
	Mobile=+Yourmobilenumber,
	E-mail=Your-e-mail,
	Web=Yourwebsite]

% Setup your personal footer
\setvariables
	[PocketDiaryFooter]
	[Lefttext=PocketDiary,
	 Centertext=\pagenumber,
	 Righttext={\getvariable{PocketDiaryAddress}{Forename},{\currentdate[year]}}]

% Setup your favorite colors

\setvariables
	[PocketDiaryColors]
	[Separatorline=blue,
	 Gridline={s=.75}]

% Setup the data for sunrise and sunset
\setvariables
  [PocketDiaryGeoPosition]
  [lat=Latitude of your place,
   lon=Longitude of your place,
   timeoffset=Timezone (positive to the East, negative to the West from UTC),
   continent=EU] % US, empty for no Daylight Saving Time (DST)
	 
% Do the typesetting
\starttext
	\setuparranging[1*8] % this can be uncommented in t-pocketdiary.tex
	\getbuffer[Pocketdiary]
\stoptext


