#!/bin/sh
# Make the dvips-encoded vf/tfm

name=$1
OUT=$2
suffix=$3

base_enc=8r.enc
user_enc=dvips.enc
v_or_V=-v

if expr $name : '.*8r$' >/dev/null; then
  user_enc=8r.enc
  name=`echo $name | sed 's/8r$//'`
fi

# Do this after stripping the 8r.
base=$name
afm=$name
a2t_options=
# If we have a natural afm file (e.g., pagko), then we just use
# that. Otherwise (e.g., pplro), we manipulate the roman. Check this first,
# because the natural file might be almost anything (e.g., uaqrrc is not
# smallcaps).
if test ! -r ${name}8a${suffix}.afm
then
# Determine the AFM file to read for this, and/or the extra options for
# afm2tfm, and/or the name of the base font for the VF.
  case $name in
    *on) afm=`echo $name | sed 's/on$/o/'`	# oblique narrow -> oblique
         a2t_options="-e .82";;
    *rn) afm=`echo $name | sed 's/rn$//'`	# upright narrow -> rm
         a2t_options="-e .82";;
     *c) afm=`echo $name | sed 's/c$//'`	# caps and small caps -> rm
         base=$afm
         v_or_V=-V;;
     *u) afm=`echo $name | sed 's/u$/i/'`	# unslanted italic -> italic
         a2t_options="-s -.1763";;
    *re) afm=`echo $name | sed 's/re$//'`	# extended -> rm
         a2t_options="-e 1.2";;
     *o) afm=`echo $name | sed 's/o$//'`	# constructed oblique -> rm
         a2t_options="-s .167"
  esac  
fi

# Put back the 8r if we stripped it for the sake of the case.
if test $user_enc = 8r.enc; then
  name=${name}8r
fi

cmd="afm2tfm ${afm}8a${suffix}.afm -u -p $base_enc -t $user_enc \
  $a2t_options \
  $v_or_V $name.vpl \
  ${base}8r${suffix}.tfm"
echo $cmd
$cmd >>map

# We don't want the raw tfm unless we had funny options
if test "$a2t_options"x = "x"
then
	rm ${base}8r${suffix}.tfm
fi

# Times-Roman and obliqued Times-Roman can use the Greek letters from Symbol.
if test $base = ptmr || test $base = ptmro; then
  test $user_enc != 8r.enc && ed $name.vpl <$base.ed
fi
vptovf $name.vpl $name.vf $name.tfm
#rm $name.vpl
mv *.tfm ${OUT}/tfm
mv *.vf ${OUT}/vf

exit 0
