import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;

/*
 * PrefPathGUI.java
 *
 * Created on 14. Dezember 2005, 09:59
 */

/**
 *
 *  This class simply implements a GUI letting the user manage some
 *  paths. In this case the paths are the paths where CMS4talks will
 *  look for LaTeX-packages.
 *
 * @author  Olle Nebendahl
 */

public class PrefPathGUI extends JDialog {

    private JButton EditButton;
    private JButton moveUpButton;
    private JButton deleteButton;
    private JButton addButton;
    private JButton discardButton;
    private JButton saveButton;
    private JLabel jLabel1;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    
    private File startPath = new File(".");


    DefaultListModel myListModel;

    /** Creates new form PrefPathGUI */
    public PrefPathGUI(java.awt.Frame parent, boolean modal, DefaultListModel lm) 
    {
        super(parent, modal);
        myListModel=lm;
        initComponents();
    }

    public PrefPathGUI(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        myListModel=PackagePaths.getThem();
        initComponents();
    }
    
    private void initComponents() {
        jLabel1 = new JLabel();
        jPanel1 = new JPanel();
        jScrollPane1 = new JScrollPane();
        jList1 = new JList();
        jList1 = new JList(myListModel);
        jPanel2 = new JPanel();
        addButton = new JButton();
        EditButton = new JButton();
        moveUpButton = new JButton();
        deleteButton = new JButton();
        discardButton = new JButton();
        saveButton = new JButton();

        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        jLabel1.setText("Edit the preferred paths where to search packages:");
        getContentPane().add(jLabel1);

        jPanel1.setLayout(new BoxLayout(jPanel1, BoxLayout.X_AXIS));
        
        jList1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListMouseClicked(evt);
            }
        });

        jScrollPane1.setPreferredSize(new java.awt.Dimension(260, 32));
        jScrollPane1.setViewportView(jList1);

        jPanel1.add(jScrollPane1);

        jPanel2.setLayout(new BoxLayout(jPanel2, BoxLayout.Y_AXIS));

        addButton.setText("add");
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        jPanel2.add(addButton);

        EditButton.setText("edit");
        EditButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EditButtonActionPerformed(evt);
            }
        });

//     jPanel2.add(EditButton);

        moveUpButton.setText("move up");
        moveUpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveUpButtonActionPerformed(evt);
            }
        });

        jPanel2.add(moveUpButton);

        deleteButton.setText("delete");
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });

        jPanel2.add(deleteButton);

        jPanel1.add(jPanel2);

        getContentPane().add(jPanel1);

        discardButton.setText("discard & quit");
        discardButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                discardButtonActionPerformed(evt);
            }
        });
        
        getContentPane().add(discardButton);

        saveButton.setText("save changes & quit");
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveButtonActionPerformed(evt);
            }
        });
        getContentPane().add(saveButton);

        pack();
    }
    
    public void jListMouseClicked(java.awt.event.MouseEvent evt)
    {
        int clickCount=evt.getClickCount();
        if(2==clickCount)
        {
            doMoveUp();
        }
    }
    
    public void setVisible(boolean b)
    {
        if(!b)
        {
            getLocation(Constants.prefPathGUICoordinates);
            Constants.savePreferences();
        }
        else setLocation(Constants.prefPathGUICoordinates);
        super.setVisible(b);
    }
    

    private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        PackagePaths.update(myListModel);
        setVisible(false);
    }

    private void discardButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        setVisible(false);
    }

    private void EditButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
    }

    private void ChooseButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
    }

    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        final JFileChooser fc = new JFileChooser(startPath);
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if(returnVal==JFileChooser.APPROVE_OPTION)
        {
            //System.out.println(fc.getSelectedFile().toString());
            //System.out.println((new File(fc.getSelectedFile(),"preferences.ini")).isFile());
            myListModel.addElement(fc.getSelectedFile());
            jScrollPane1.getVerticalScrollBar().setValue(jScrollPane1.getVerticalScrollBar().getMaximum());
        }
        
        pack();
    }

    private void moveUpButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        doMoveUp();
    }
    
    private void doMoveUp()
    {
        int i=jList1.getSelectedIndex();
        if(i>0) 
        {
            Object swap=myListModel.get(i-1);
            myListModel.set(i-1, myListModel.get(i));
            myListModel.set(i, swap);
            jList1.setSelectedIndex(i-1);
        }
    }

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        int i=jList1.getSelectedIndex();
        if(i>-1)
        myListModel.remove(jList1.getSelectedIndex());
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) 
    {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new PrefPathGUI(new JFrame(), true).setVisible(true);
            }
        });
        
        /*
        File file = new File(".");
        final JFileChooser fc = new JFileChooser(file);
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(new PrefPathGUI(null,true));
        if(returnVal==JFileChooser.APPROVE_OPTION)
        {
            System.out.println(fc.getSelectedFile().toString());
            System.out.println((new File(fc.getSelectedFile(),"preferences.ini")).isFile());
        }*/
    }
}
