\documentstyle[german,ifthen,titlepage,twoside,makeidx]{article}

\ifthenelse{\equal{HAS_PSFIG}{yes}}{\input{psfig.sty}}{\newcommand{\psfig}[1]{}}

\selectlanguage{\DOCUMENTATIONLANGUAGE}

\newcommand{\German}[1]{\ifthenelse{\language=\german}{#1}{}}
\newcommand{\English}[1]{\ifthenelse{\language=\english}{#1}{}}

% $Id: Imake-TeX.tex.sed,v 1.0 1993/08/17 15:28:51 klute Exp klute $

\newcommand{\version}{IMAKETEXVERSION}

\makeindex

\setlength{\marginparwidth}{0.3cm}

\setlength{\evensidemargin}{0cm}
\setlength{\oddsidemargin}{0cm}
\setlength{\topmargin}{-1.5cm}
\setlength{\footskip}{0cm}

\setlength{\textheight}{29.7cm}		% DIN A4 paper height
\addtolength{\textheight}{-1.7cm}	% inaccessible space
\addtolength{\textheight}{-1in}
\addtolength{\textheight}{-\topmargin}
\addtolength{\textheight}{-\headheight}
\addtolength{\textheight}{-\headsep}
\addtolength{\textheight}{-\topskip}
\addtolength{\textheight}{-\footskip}
\setlength{\textwidth}{21cm}		% DIN A4 paper width
\addtolength{\textwidth}{-2cm}
\addtolength{\textwidth}{-2cm}
\addtolength{\textwidth}{-\marginparsep}
\addtolength{\textwidth}{-\marginparwidth}

\pagestyle{headings}
\flushbottom
\sloppy

\German{
\frenchspacing
\setlength{\parindent}{0cm}
\setlength{\parskip}{1.5ex}
}

\newcommand{\italic}[1]{{\em #1\/}}
\newcommand{\bold}[1]  {{\bf #1}}
\newcommand{\Command}[1]    {\italic{#1}}
\newcommand{\EnvVar}[1]     {#1}
\newcommand{\EnvVarRef}[1]  {\$(#1)}
\newcommand{\File}[1]       {\italic{#1}}
\newcommand{\ImakeRule}[1]  {\bold{#1}}
\newcommand{\Option}[1]     {\italic{#1}}
\newcommand{\Param}[1]      {\italic{#1}}
\newcommand{\Program}[1]    {\italic{#1}}
\newcommand{\String}[1]     {"`#1"'}
\newcommand{\Type}[1]       {{\tt #1}}

\newcommand{\Imake}     {\Program{Imake}}
\newcommand{\Imakefile} {Imakefile}
\newcommand{\Imakefiles}{Imakefiles}
\newcommand{\make}      {\Program{make}}
\newcommand{\Make}      {\Command{Make}}
\newcommand{\Makefile}  {Makefile}
\newcommand{\Makefiles} {Makefiles}
\newcommand{\SliTeX}    {{\rm Sli{\TeX}}}
\newcommand{\imt}       {\Program{Imake-{\TeX}}}

\newcommand{\irbtitle}[2]{
\title{\bf #1}
\author{
\newlength{\al}
\setlength{\al}{\linewidth}
\addtolength{\al}{-26pt}
\begin{minipage}{\al}{
\begin{center}
#2\\
\bigskip
Informatikrechner-Betriebsgruppe (IRB)\\
\bigskip
\mbox{\psfig{figure=UnidoLogo.eps,width=4cm}}
\end{center}
}
\end{minipage}
}
}

\irbtitle{
\German{Leichte {\TeX}nik\\
{\large \rm Verarbeitung von {\TeX}-Dateien mit Hilfe von Imake}\\
\bigskip}
Imake-{\TeX}\\Version \version{}}
{Rainer Klute\\
$<$klute@irb.informatik.uni-dortmund.de$>$}




\begin{document}

\bibliographystyle{unsrt}

\maketitle

\begin{titlepage}
\tableofcontents
\end{titlepage}




\section{Copyright}

\German{{\imt} darf ohne Einschr"ankungen kopiert und weitergegeben werden, ist aber}

\begin{center}
\bold{Copyright {\copyright} 1993 Rainer Klute}
\end{center}

\German{Eine Garantie f"ur das einwandfreie Funktionieren dieser Software kann
nicht "ubernommen werden. Der Autor haftet nicht f"ur etwaige Sch"aden, die aus
der Anwendung dieser Software resultieren.}

\English{Permission to use, copy, modify, and distribute this software for any
purpose and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies. The author makes no
representations about  the  suitability of this software for any purpose.  It
is provided ``as is'' without express or implied warranty.}




\German{\section{Einleitung}}
\English{\section{Introduction}}

\German{Die F"ahigkeiten des Satzsystems {\TeX}\index{TeX@{\TeX}} und
insbesondere des Makropakets {\LaTeX}\index{LaTeX@{\LaTeX}} wissen viele, die
damit ihre Dokumente erstellen, sehr zu sch"atzen. Leider ist das Verarbeiten
der erstellten {\LaTeX}-Dateien etwas m"uhsam, insbesondere, wenn
Inhalts-\index{Inhaltsverzeichnis}, Literatur-\index{Literaturverzeichnis} oder
Stichwortverzeichnisse\index{Stichwortverzeichnis} generiert werden.}

\English{The {\TeX}\index{TeX@{\TeX}} typesetting system and the macro package
{\LaTeX}\index{LaTeX@{\LaTeX}} are quite popular among those producing
professional documents. However, processing {\LaTeX} files is a bit
troublesome, especially if a table of contents\index{table of contents}, a
bibliography\index{Bibliography} or an index\index{Index} are to be generated.} 

\German{Nach "Anderungen an der Quelldatei mu"s {\LaTeX} aufgerufen werden, um
den Text zu setzen und eine DVI-Datei zu erzeugen; an\-schlie\-"send startet
der Benutzer einen Previewer wie \Program{xdvi}, um sich das Ergebnis am
Bildschirm anzusehen. Bei "Anderungen, die sich auf das Inhaltsverzeichnis oder
auf Querverweise auswirken, mu"s {\LaTeX} erneut ablaufen, damit sich diese
"Anderungen auch in der generierten DVI-Datei auswirken. Modifiziert der
Benutzer das Stichwortverzeichnis oder die Literaturliste, mu"s er nach dem
ersten {\LaTeX}-Durchlauf \Program{makeindex} beziehungsweise \Program{bibtex}
aufrufen; danach kann der zweite {\LaTeX}-Lauf stattfinden. Dabei k"onnen sich
wiederum Querverweise oder das Inhaltsverzeichnis verschieben, so da"s {\LaTeX}
ein drittes Mal ausgef"uhrt werden mu"s.}

\English{After changing the source file, {\LaTeX} must be executed to typeset
the text and to generate a DVI file. After that, the user starts a previewer
like \Program{xdvi} to see the result on the screen. If modifications are made
that have an influence on the table of contents or on cross references,
{\LaTeX} has to run once again in order to reflect the modifications in the DVI
file. If the user modifies the index or the bibliography, he has to execute
\Program{makeindex} or \Program{bibtex} after the first {\LaTeX} run; then the
second {\LaTeX} run can take place. During this process index or bibliography
entries can be displaced again, so that {\LaTeX} must be executed for the third
time.}

\German{Ans"atze, die wechselseitigen Abh"angigkeiten mit Hilfe von
{\Makefiles}\index{Makefile} zu beschreiben, blieben auf wenige Anwender
beschr"ankt: Da zur Erstellung eines geeigneten Makefiles recht intime
Kenntnisse sowohl von {\LaTeX} und seinen Hilfsprogrammen als auch von {\make}
und der Bourne-Shell erforderlich sind, ist diese L"osung nicht jedermann
zumutbar.}

\English{Efforts to describe these mutual dependencies in
Makefiles\index{Makefile} have always been limited to only a few users: In
order to establish such a Makefile you need to have good knowledge about
{\LaTeX} and its utility programs, about {\make} and about the Bourne shell. 
Consequently this solution cannot be expected of everybody.}

\German{Aus diesem Grund habe ich einen Ansatz mit
{\Imake}\index{Imake@{\Imake}} entwickelt ("`{\imt}"'), der allgemein
verf"ugbar ist, von jedem {\TeX}-Benutzer in kurzer Zeit beherrscht werden
kann, und der die Arbeitsabl"aufe entscheidend vereinfacht. Nach
Text"anderungen ruft der Benutzer lediglich das Kommando {\make} auf, und
dieses wiederum f"uhrt die erforderlichen Programme wie {\LaTeX},
\Program{makeindex} oder \Program{bibtex} automatisch so oft wie n"otig und in
der richtigen Reihenfolge aus. Die bequeme Generierung einer
PostScript-Variante aus der DVI-Datei sowie das Betrachten des Erzeugnisses am
(Graphik-)Bildschirm unterst"utzt {\imt} ebenfalls.}

\English{This was the reason for me to use {\Imake}\index{Imake@{\Imake}} as
the starting point ("`{\imt}"'). {\Imake} is publically available, every {\TeX}
user can master it after a short time, and it simplyfies processing
considerably.  After changing the text, the user just types the command
{\make}, which in turn executes the necessary programs like {\LaTeX},
\Program{makeindex}, or \Program{bibtex}---automatically, in the correct
sequence and as often as needed. {\imt} also supports the comfortable
generation of a PostScript variant from the DVI file together with displaying
it on the (graphical) screen.}

\German{"Uber Ihre Reaktion in Form von Lob oder
Fehlermeldungen\index{Fehlermeldungen} w"urde ich mich freuen. Hinweise auf
Schwachstellen dieser Dokumentation s"ahe ich ebenfalls recht gerne.}

\English{This documentation is written in "`German"' English. If \bold{you} are
a native English speaker, please improve the poor wording of this document, and
send me your modifications!}



\German{\section{Makefile-Generierung
\index{Makefile-Generierung@{\Makefile}-Generierung} mit Imake}}

\English{\section{Generating a Makefile\index{Makefile!generating a} with Imake}}


\German{Das Grundprinzip von {\Imake} ist recht einfach: Der Benutzer tr"agt in
einem {\Imakefile}\index{Imakefile@{\Imakefile}} einige
{\Imake}-Regeln\index{Imake-Regeln@{\Imake}-Regeln} ein. Das ist leicht und
schnell erledigt: {\Imakefiles} sind selten l"anger als zehn Zeilen. Aus diesem
{\Imakefile} generiert das Programm {\Imake} mit Hilfe vorgegebener
Template-Dateien ein {\Makefile}. Im Gegensatz zum {Imakefile} ist das erzeugte
{\Makefile} sehr komplex und enth"alt leicht "uber 500 Zeilen, was den Benutzer
aber nicht zu k"ummern braucht. Die genauen Abl"aufe bei der Ausf"uhrung von
{\Imake} sind an anderer Stelle ausf"uhrlich beschrieben
(\cite{DuBois:1993:Software-Portability-with-imake}, \cite{Imake/Unido},
\cite{Imake-Theorie/iX}), so da"s wir uns hier auf einige Benutzungshinweise
und die spezielle Unterst"utzung f"ur {\TeX} beschr"anken k"onnen.}

\English{{\Imake}'s working principle is simple: The user writes down a few
{\Imake} rules\index{Imake rules@{\Imake} rules} in an
{\Imakefile}\index{Imakefile@{\Imakefile}}. This is easy and done quickly:
{\Imakefiles} are seldom longer than ten lines. From the {\Imakefile} the
program {\Imake} generates a {\Makefile} using a set of predefined template
files. Contrary to the {\Imakefile}, the generated {\Makefile} is very complex
and likely contains more than 500 line. However, this must not irritate the
user. {\Imake}'s exact procedure has been explained elsewhere
(\cite{DuBois:1993:Software-Portability-with-imake}, \cite{Imake/TXJ}), so it
is sufficient to describe the special support for {\TeX} here.}



\German{\section{Ein einfaches Beispiel}}
\English{\section{A Simple Example}}

\German{Hier ein einfaches Beispiel, das ganz kurz die M"oglichkeiten von
{\imt} anrei"st. Die genaue Beschreibung finden Sie vom n"achsten Kapitel an.}

\English{Here is a simple example which shows the possibilities of {\imt} in
short. The exact descriptions starts with the next chapter.}



\German{\subsection{Das Imakefile}}
\English{\subsection{The Imakefile}}

\German{Nehmen wir an, Sie haben eine {\LaTeX}-Datei namens \File{example.tex}
erstellt. Das Dokument soll zun"achst noch ohne ein Stichwort- oder
Literaturverzeichnis auskommen; ein Inhaltsverzeichnis dagegen sei erlaubt. 
Diese {\LaTeX}-Datei beschreiben Sie in der Datei {\Imakefile} durch folgende
Zeilen:}

\English{Consider you have created a {\LaTeX} file called \File{example.tex}. 
In this first example it does not need to have an index or bibliography. 
However, it may have a table of contents. You will describe this {\LaTeX} file
in the file {\Imakefile} by the following lines:}

{\samepage
\begin{quote}
\begin{verbatim}
#include <TeX.tmpl>
SimpleLatexTarget(example)
\end{verbatim}
\end{quote}
\index{SimpleLatexTarget}
\label{ExamSimple}
}

\German{Das ist alles. Aus diesen wenigen Angaben kann {\Imake} nun mit Hilfe
geeigneter Template-Dateien ein {\Makefile} erzeugen. Dazu geben Sie das
Kommando \Command{texmkmf}\index{texmkmf}\footnote{"`{\TeX} make {\Makefile}"'
--- ein Shell-Script, das wiederum {\Imake} aufruft} ein.}

\English{\noindent That's all. From these few specifications {\Imake}
can---with the help of suitable template file---generate a {\Makefile}. In
order to do this type the command
\Command{texmkmf}\index{texmkmf}\footnote{"`{\TeX} make {\Makefile}"'---a shell
script which in turn calls {\Imake}}.}



\German{\subsection{Das generierte Makefile}}
\English{\subsection{The Generated Makefile}}

\German{Das {\Makefile} stellt Ihnen eine Reihe von Kommandos zur
Verf"ugung:\footnote{Dies ist nur eine kurze "Ubersicht; die genaue
Beschreibung finden Sie in Kapitel \ref{MakeTargets} auf
Seite~\pageref{MakeTargets}.}}

\English{What you can do with the {\Makefile}---a short overview.\footnote{The
exact description you will find in chapter \ref{MakeTargets} on
page~\pageref{MakeTargets}.}}

\begin{description}

\item[\Command{make depend}\index{make depend}]

\German{durchsucht die {\TeX}-Quelldatei nach weiteren Dateien, die zum
Beispiel durch den \Type{\char'134input}-Befehl eingelesen werden. F"ur jede
gefundene Datei f"ugt {\imt} eine {\make}-Abh"angigkeit
(Dependency\index{Dependency}) an das {\Makefile} an und sorgt auf diese Weise
f"ur eine Neu\-ge\-ne\-rie\-rung der DVI-Datei, wenn an einer der eingelesen
Datei eine "Anderung durchgef"uhrt wurde. Sie sollten dieses Kommando
unmittelbar nach der {\Makefile}-Generierung mit
\Command{texmkmf}\index{texmkmf} ausf"uhren.}

\English{searches the {\TeX} source file for other files which are read for
example by the \Type{\char'134input} command. For each file found {\imt}
appends a {\make} dependency\index{Dependency} to the {\Makefile}. This causes
a re-generation of the DVI file after changes in input files. You should
execute this command right after generating the {\Makefile} with
\Command{texmkmf}\index{texmkmf}.}

\item[\Command{make dvi}\index{make dvi}]

\German{ruft das Programm \Program{latex} so oft wie n"otig auf und erzeugt so
die DVI-Datei \File{example.dvi}. Statt \Command{make dvi} kann man auch
\Command{make all}\index{make all} verwenden, in vielen F"allen auch einfach
\Command{make} (siehe Kapitel \ref{AllTarget} auf Seite~\pageref{AllTarget}).}

\English{calls the program \Program{latex} as often as necessary and thus
creates the DVI file \File{example.dvi}. Instead of \Command{make dvi} you can
also use \Command{make all}\index{make all}, or in many cases simply
\Command{make} (see chapter \ref{AllTarget} on page~\pageref{AllTarget}).}

\item[\Command{make viewdvi}\index{make viewdvi}]

\German{zeigt zus"atzlich die DVI-Datei mit Hilfe des
Previewers\index{Previewer} \Program{xdvi}\index{xdvi} auf dem Bildschirm an.}

\English{additionally shows the DVI file on the screen, using the
previewer\index{Previewer} \Program{xdvi}\index{xdvi}.}

\item[\Command{make ps}\index{make ps}]

\German{erzeugt --- falls erforderlich --- eine aktuelle DVI-Datei (siehe
\Command{make dvi}) und generiert aus dieser an\-schlie\-"send die
PostScript-Datei\index{PostScript} \File{example.ps}.}

\English{creates---if necessary---an up-to-date DVI file (see \Command{make
dvi}) and generates the PostScript file\index{PostScript} \File{example.ps}.}

\item[\Command{make viewps}\index{make viewps}]

\German{zeigt zus"atzlich die PostScript-Datei mit Hilfe des
Previewers\index{Previewer} \Program{ghostview}\index{ghostview} auf dem
Bildschirm an.}

\English{additionally shows the PostScript file on the screen, using the
previewer\index{Previewer} \Program{ghostview}\index{ghostview}.}

\item[\Command{make clean}\index{make clean}]

\German{l"oscht alle Hilfs-, Log- und sonstigen Dateien, die durch ein
entsprechendes {\make} leicht wieder erzeugt werden k"onnten.}

\English{removes help files, log files, and other files that can be re-created
by a {\make} comand.}

\item[\Command{make veryclean}\index{make veryclean}]

\German{l"oscht auch die DVI-Datei.}

\English{removes the DVI file, too.}

\item[\Command{make Makefiles}\index{make Makefiles}]

\German{generiert {\Makefiles} in Unterverzeichnissen.}

\English{generates {\Makefiles} in subdirectories.}

\end{description}




\German{\section{Beschreibung des {\LaTeX}-Dokuments im Imakefile}}
\English{\section{Describing the {\LaTeX} Document in the Imakefile}}
\label{SimpleLatexTarget}

\German{Der Benutzer beschreibt sein Dokument im
{\Imakefile}\index{Imakefile@{\Imakefile}} mit Hilfe von
{\Imake}-Regeln\index{Imake-Regeln@{\Imake}-Regeln}. Schauen wir uns noch
einmal das {\Imakefile} aus dem Beispiel an:}

\English{The user describes his document in the {\Imakefile}\index{\Imakefile}
using {\Imake} rules\index{Imake rules@{\Imake} rules}. Let's have a look at the sample
{\Imakefile} again:}

{\samepage
\begin{quote}
\begin{verbatim}
#include <TeX.tmpl>
SimpleLatexTarget(example)
\end{verbatim}
\end{quote}
\index{SimpleLatexTarget}

\begin{itemize}

\item

\German{Die erste Anweisung \Type{\#include
<TeX.tmpl>}\index{include@\#include} stellt die Template-Datei
\File{TeX.tmpl}\index{TeX.tmpl} zur Verf"ugung. Sie enth"alt die
{\Imake}-Regeln f"ur {\imt}, die im folgenden benutzt werden.}

\English{The first statement \Type{\#include
<TeX.tmpl>}\index{include@\#include} makes the template file
\File{TeX.tmpl}\index{TeX.tmpl} available. It contains the {\Imake} rules for
{\imt}, which are used subsequently.}

\item

\German{Die Regel \Type{SimpleLatexTarget(example)}\index{SimpleLatexTarget}
sagt: Mein {\LaTeX}-Dokument steht in der Datei \File{example.tex}, es enth"alt
weder Stichwort- noch Literaturverzeichnis, und es verwendet auch keine
Eingabedateien, die \Command{make depend}\index{make depend} nicht finden
kann\footnote{Dummerweise findet \Command{make depend} Dateien dann nicht, wenn
das {\TeX}-Dokument sie nicht mit \Type{\char'134input}, sondern "uber ein
selbstdefiniertes Kommando einliest. Einzelheiten und Tips zur Abhilfe finden
Sie in den Kapiteln \ref{make depend} (Seite~\pageref{make depend})
\ref{TeX-Eingabedateien} (Seite~\pageref{TeX-Eingabedateien}) und \ref{Aendern
des Suchmusters} (Seite~\pageref{Aendern des Suchmusters})}.}

\English{Rule \Type{SimpleLatexTarget(example)}\index{SimpleLatexTarget} says:
The {\LaTeX} document is in file \File{example.tex}, it contains neither index
nor bibliography and it does not use input files \Command{make
depend}\index{make depend} cannot find\footnote{Unfortunately \Command{make
depend} does not find files which the {\TeX} document does not read using
\Type{\char'134input}, but with a selfdefined command. Details and tips to
circumvent this deficiency you will find in chapters \ref{make depend}
(page~\pageref{make depend}), \ref{TeX-Eingabedateien}
(page~\pageref{TeX-Eingabedateien}) and \ref{Aendern des Suchmusters}
(page~\pageref{Aendern des Suchmusters}).}.}

\end{itemize}

\German{F"ur komplexere Anwendungen, f"ur die \ImakeRule{SimpleLatexTarget}
nicht ausreicht, stehen weitere {\Imake}-Regeln zur Verf"ugung, die wir im
folgenden betrachten.}

\English{\noindent For more complex applications, where
\ImakeRule{SimpleLatexTarget} is not suffient, additional {\Imake} rules are
available. We shall have a look at them now.}



\German{\subsection{"`Einfache"' und "`normale"' Dokumente}}
\English{\subsection{``Simple'' and ``Normal'' Documents}}
\label{NormalLatexRule}
\label{NormalLatexTarget}

\German{Was ist an der gerade behandelten Regel
\Type{SimpleLatexTarget}\index{SimpleLatexTarget} "`einfach"'? Sie beschreibt
ein {\LaTeX}-Dokument, {\dots}}

\English{What is the ``simple'' thing with
\Type{SimpleLatexTarget}\index{SimpleLatexTarget}? It describes a {\LaTeX}
document {\dots}}

\begin{list}{\dots}{}

\item

\German{das keine Eingabedatei einliest, die \Command{make depend} nicht finden
kann,}

\English{which does not read another input file, which \Command{make depend}
cannot find,}

\item

\German{das das einzige Dokument ist, das dieses {\Imakefile} beschreibt.}

\English{which is the only document described by this {\Imakefile}.}

\end{list}

\German{In allen anderen F"allen findet die Regel
\ImakeRule{NormalLatexTarget}\index{NormalLatexTarget} Anwendung: Nehmen wir
an, wir wollen die zwei Dokumente \File{example1.tex} und \File{example2.tex}
beschreiben, und \File{example2.tex} verwende wiederum zwei Eingabedateien
\File{input1.tex} und \File{input2.tex}, die \Command{make depend} nicht finden
kann. Das entsprechende {\Imakefile} sieht so aus:}

\English{\noindent In all other cases you should use rule
\ImakeRule{NormalLatexTarget}\index{NormalLatexTarget}. For instance, you want
to describe two documents \File{example1.tex} and \File{example2.tex}, and
\File{example2.tex} inputs two files \File{input1.tex} and \File{input2.tex}
which \Command{make depend} cannot find. In this case the {\Imakefile} should
look like this:}

{\samepage
\begin{quote}
\begin{verbatim}
#include <TeX.tmpl>
NormalLatexRule()
NormalLatexTarget(example1,)
NormalLatexTarget(example2,input1.tex input2.tex)
\end{verbatim}
\end{quote}
\index{NormalLatexRule}
\index{NormalLatexTarget}
\label{ExamNormal}
}

\German{Man beachte die zus"atzliche {\Imake}-Regel
\ImakeRule{NormalLatexRule}\index{NormalLatexRule}! Sie ist das Herzst"uck des
gesamten Verfahrens und "`wei"s"', wie aus einer {\LaTeX}-Datei eine DVI-Datei
zu machen ist. \ImakeRule{SimpleLatexTarget}\index{SimpleLatexTarget} verwendet
sie implizit; bei \ImakeRule{NormalLatexTarget} mu"s sie der Anwender selbst
ins {\Imakefile} eintragen.\footnote{F"ur {\SliTeX}-Dokumente existiert eine
entsprechende Regel \ImakeRule{NormalSlitexRule()}\index{NormalSlitexRule}.}}

\English{\noindent Please note the additional {\Imake}-Rule
\ImakeRule{NormalLatexRule}\index{NormalLatexRule}! It is the core of the whole
procedure and ``knows'' how to transform a {\LaTeX} file to a DVI file. 
\ImakeRule{SimpleLatexTarget}\index{SimpleLatexTarget} uses it implicitly; when
using \ImakeRule{NormalLatexTarget} you have to write it into the {\Imakefile}
yourself.\footnote{For {\SliTeX} documents there is an equivalent rule
\ImakeRule{NormalSlitexRule()}\index{NormalSlitexRule}.}}

\German{\ImakeRule{NormalLatexTarget}\index{NormalLatexTarget} kann im
{\Imakefile} mehrfach stehen und entsprechend mehrere Dokumente beschreiben.
Sie besitzt gegen"uber \ImakeRule{SimpleLatexTarget} einen zus"atzlichen
Parameter: An den Namen des Dokuments schlie"st sich eine Liste von weiteren
Dateinamen an. Hier sind diejenigen Dateien aufgef"uhrt, die \Command{make
depend} nicht findet.  Diese \italic{Dependency-Liste}\index{Dependency-Liste}
kann leer sein (siehe \File{example1}), einen einzigen oder mehrere Dateinamen
enthalten (siehe \File{example2}). Im letzteren Fall trennt man die einzelnen
Namen durch Leerzeichen.}

\English{You may use \ImakeRule{NormalLatexTarget}\index{NormalLatexTarget}
more than once in a single {\Imakefile} and thus describe multiple documents. 
Different from \ImakeRule{SimpleLatexTarget} \ImakeRule{NormalLatexTarget} has
an additional parameter: After the document's name a list of further files
follows. Here those files not found by \Command{make depend} are listed. This
\italic{dependency list}\index{Dependency!list} may be empty (see
\File{example1}), or may contain one or more file names (see \File{example2}). 
In the latter case you have to separate them by spaces.}

\German{Bei den folgenden Regeln werden der Einfachheit halber durchweg nur die
\ImakeRule{Normal{\dots}}-Varianten beschrieben. Die entsprechenden
\ImakeRule{Simple{\dots}}-Regeln ergeben sich durch Weglassen der
Dependency-Liste und der Regel \ImakeRule{NormalLatexRule}. Die
Dependency-Liste\index{Dependency-Liste} steht \italic{immer} unmittelbar
hinter dem Dokumentnamen.}



\German{\subsection{Dokumente mit
Stichwortverzeichnis}\index{Stichwortverzeichnis}}
\English{\subsection{Documents with an Index}\index{Index}}
\label{Stichwortverzeichnis} \label{NormalLatexIndexTarget}

\German{Ein Stichwortverzeichnis\index{Stichwortverzeichnis} l"a"st sich in
{\LaTeX}-Dokumenten mit Hilfe des Styles {\tt makeidx}\index{makeidx@{\tt
makeidx}!LaTeX-Style@{\LaTeX}-Style} und dem zugeh"origen Programm
\Program{makeindex}\index{makeindex} erzeugen. Im {\Imakefile} verwendet man
anstelle von \ImakeRule{NormalLatexTarget} die Regel
\ImakeRule{NormalLatexIndexTarget}\index{NormalLatexIndexTarget}. Diese Regel
sorgt f"ur die Ausf"uhrung des Programms \Program{makeindex}\index{makeindex}
nach einem {\LaTeX}-Lauf, damit das Stichwortverzeichnis stets aktuell bleibt. 
Diesen Index integriert der nachfolgende {\LaTeX}-Lauf in die DVI-Datei.}

\English{An index\index{Index} can be generated using the {\LaTeX} style {\tt
makeidx}\index{makeidx@{\tt makeidx}!LaTeX style@{\LaTeX} style} and the
supplementary program \Program{makeindex}\index{makeindex}. In the {\Imakefile}
instead of \ImakeRule{NormalLatexTarget} use the rule
\ImakeRule{NormalLatexIndexTarget}\index{NormalLatexIndexTarget}. This rule
executes \Program{makeindex}\index{makeindex} after a {\LaTeX} run in order to
keep the index up to date. The subsequent {\LaTeX} run includes this index in
the DVI file.}



\German{\subsection{Literaturverzeichnis mit
BIB{\TeX}}\index{Literaturverzeichnis}}
\English{\subsection{Bibliography with BIB{\TeX}}\index{Bibliography}}
\index{BIB{\TeX}}}
\label{Literaturverzeichnis}
\label{NormalLatexBibtexTarget}

\German{Ein Literaturverzeichnis\index{Literaturverzeichnis} mu"s mit Hilfe des
Programms \Program{bibtex}\index{bibtex} neu erstellt werden, wenn sich die
zugrundeliegende Literaturdatenbank\index{Literaturdatenbank} oder das
{\LaTeX}-Dokument ge"andert haben. Daran an\-schlie\-"send bindet {\LaTeX} das
neu erstellte Literaturverzeichnis in die DVI-Datei ein. Im {\Imakefile} mu"s
der Benutzer die {\Imake}-Regel
\ImakeRule{NormalLatexBibtexTarget}\index{NormalLatexBibtexTarget} verwenden:}

\English{A bibliography\index{Bibliography} must be regenerated using the
program \Program{bibtex}\index{bibtex} when the corresponding bibliography
database\index{Bibliography!database} or the {\LaTeX} document have been
modified. The subsequent {\LaTeX} run includes the bibliography in the DVI
file. In the {\Imakefile} the user has to write the {\Imake} rule
\ImakeRule{NormalLatexBibtexTarget}\index{NormalLatexBibtexTarget}:}

\begin{quote}
\begin{verbatim}
#include <TeX.tmpl>
NormalLatexRule()
NormalLatexBibtexTarget(example3,input.tex,paper.bib)
\end{verbatim}
\end{quote}
\index{NormalLatexBibtexTarget}

\German{Der dritte Parameter (hier: \File{paper.bib}) benennt die von
\Program{bibtex} auszuwertende Literaturdatenbank\index{Literaturdatenbank}. 
(Der Dokumentname steht immer als erster Parameter; bei \File{input.tex} im
Beispiel handelt es sich folglich um die Dependency-Liste.)}

\English{\noindent The third parameter (here: \File{paper.bib}) names the
bibliography database\index{Bibliography!database} to be searched by
\Program{bibtex}. (The document's name always comes first; so \File{input.tex}
in the example is the dependency list.)}


\German{\subsection{Dokumente mit Index und Literaturverzeichnis}}
\English{\subsection{Documents with Index and Bibliography}}
\label{NormalLatexBibtexIndexTarget}
\label{NormalLatexIndexBibtexTarget}

\German{Enth"alt das Dokument sowohl Index\index{Index} als auch
Literaturverzeichnis\index{Literaturverzeichnis}, findet die Regel
\ImakeRule{NormalLatexBibtexIndexTarget}\index{NormalLatexBibtexIndexTarget}
Anwendung. Die Parameter sind die gleichen wie bei
\ImakeRule{NormalLatexBibtexTarget} (siehe Kapitel \ref{Literaturverzeichnis}).
Damit sich der Anwender nicht eine bestimmte Reihefolge merken mu"s, kann er
genausogut
\ImakeRule{NormalLatexIndexBibtexTarget}\index{NormalLatexIndexBibtexTarget}
benutzen.}

\English{If the document holds an index\index{Index} as well as a
bibliography\index{Bibliography} the rule
\ImakeRule{NormalLatexBibtexIndexTarget}\index{NormalLatexBibtexIndexTarget}
should be used. The parameters are the same as those of
\ImakeRule{NormalLatexBibtexTarget} (see chapter \ref{Literaturverzeichnis}). 
Since you won't want to have to remember any particular order, you can also use
\ImakeRule{NormalLatexIndexBibtexTarget}\index{NormalLatexIndexBibtexTarget}.}



\German{\subsection{Folien mit SLI{\TeX}}
\index{SLITeX@SLI{\TeX}}
\index{LaTeX-Dokumente und SLITeX-Folien@{\LaTeX}-Dokumente und
SLI{\TeX}-Folien}
\index{SLITeX-Folien und LaTeX-Dokumente@SLI{\TeX}-Folien und
{\LaTeX}-Dokumente}}

\English{\subsection{Slides with SLI{\TeX}}
\index{SLITeX@SLI{\TeX}}
\index{LaTeX documents and SLITeX slides@{\LaTeX} documents and SLI{\TeX} slides}
\index{SLITeX slides and LaTeX documents@SLI{\TeX} slides and {\LaTeX} documents}}

\label{SLITeX}


\German{Die f"ur {\LaTeX} beschriebenen {\Imake}-Regeln stehen zus"atzlich in
einer Variante f"ur SLI{\TeX}\index{SLITeX@SLI{\TeX}} mit analoger Bedeutung
zur Verf"ugung. In den Regelbezeichnungen ist \ImakeRule{Latex} durch
\ImakeRule{Slitex} zu ersetzen.}

\English{The rules described above for {\LaTeX} are also available in a
SLI{\TeX}\index{SLITeX@SLI{\TeX}} variant with analogous meanings. Simply
replace \String{Latex} in the rules' names by \String{Slitex}.}

\German{Beachten Sie, da"s Sie pro {\Imakefile} nur eine der Regeln
\ImakeRule{NormalLatexRule}\index{NormalLatexRule} und
\ImakeRule{NormalSlitexRule}\index{NormalSlitexRule} verwenden k"onnen!
Gegebenenfalls m"ussen Sie {\LaTeX}-Dokumente und SLI{\TeX}-Folien auf
verschiedene Unterverzeichnisse mit getrennten {\Imakefiles} aufteilen.}

\English{Please note that you can use only one of
\ImakeRule{NormalLatexRule}\index{NormalLatexRule} and
\ImakeRule{NormalSlitexRule}\index{NormalSlitexRule} in a single {\Imakefile}!
However, you can distribute {\LaTeX} documents and SLI{\TeX} slides to separate
subdirectories with separate {\Imakefiles}.}




\German{\section{Make-Targets}\index{Make-Targets}}
\English{\section{Make targets}\index{Make targets}}
\label{MakeTargets}

\German{Das aus dem {\Imakefile} generierte {\Makefile} stellt eine Reihe von
{\make}-Targets\index{Make-Targets} zur Verf"ugung, die im folgenden
ausf"uhrlich vorgestellt werden.}



\subsection{make dvi, make viewdvi}

\German{Das Kommando \Command{make dvi}\index{make dvi} ruft (falls n"otig) das
Programm \Program{latex} auf, das aus dem Dokumentquelltext die DVI-Datei
erzeugt.  Falls die Quelldatei die Generierung eines Inhaltsverzeichnisses
fest\-legt oder Querverweise im Text vorkommen, wird \Program{latex}
hinreichend oft erneut aufgerufen. Damit es im Fehlerfall aber zu keiner
Endlosschleife kommt, ist "`hinreichend"' auf drei Mal beschr"ankt. Statt
\Command{make dvi} kann man auch \Command{make all}\index{make all} verwenden,
in vielen F"allen auch einfach \Command{make} (siehe Kapitel \ref{AllTarget}
auf Seite~\pageref{AllTarget}).}

\English{The command \Command{make dvi}\index{make dvi} calls (if needed) the
program \Program{latex}, which generates the DVI file from the document's
source. If the source file specifies generation of a table of contents or if
cross references are found in the text, \Program{latex} is called anew as often
as needed. In order to prevent an endless loop in case of an error, ``as often
as needed'' is limited to three times. Instead of \Command{make dvi} you can
also use \Command{make all}\index{make all}, and in many cases simply
\Command{make} (see chapter \ref{AllTarget} on page ~\pageref{AllTarget}).}

\German{Durch \Command{make viewdvi}\index{make viewdvi} k"onnen Sie sich die
DVI-Datei mit Hilfe eines Previewers\index{Previewer} (Voreinstellung:
\Program{xdvi}\index{xdvi}) auf dem Bildschirm ansehen.}

\English{By \Command{make viewdvi}\index{make viewdvi} you can view a DVI file
on the screen using a previewer (default: \Program{xdvi}\index{xdvi}).}

\German{Bei mehreren Dokumenten im {\Imakefile} l"a"st sich eine bestimmte
DVI-Datei durch das Kommando \Command{make name.dvi} erzeugen, wobei
\File{name} der Basisname des Dokuments ist.}

\English{If your {\Imakefile} describes several documents, you generate a
specific DVI file by \Command{make name.dvi}, where \File{name} is the
document's base name.}



\subsection{make ps, make viewps}

\German{Die Konvertierung nach PostScript erledigt das Kommando \Command{make
ps}\index{make ps} (auch m"oglich: \Command{make postscript}\index{make
postscript}). Intern ruft \Command{make ps} einen Wandler (Voreinstellung:
\Program{dvips}\index{dvips}) auf, der aus der DVI-Datei eine solche im
PostScript-Format\index{PostScript} generiert. Erforderlichenfalls erzeugt
\Command{make ps} zuvor auch die DVI-Datei.

Die PostScript-Datei kann man sich man sich am Bildschirm ansehen: Analog zu
\Command{make viewdvi} startet \Command{make viewps}\index{make viewps} einen
Previewer\index{Previewer} (Voreinstellung:
\Program{ghostview}\index{ghostview}).

Bei mehreren Dokumenten im {\Imakefile} l"a"st sich auch hier eine bestimmte
PostScript-Datei erzeugen: \Command{make name.ps} erledigt dies.}

\English{The command \Command{make ps}\index{make ps} (or \Command{make
postscript}\index{make postscript}) performs the generation of PostScript
output. Internally \Command{make ps} executes a converter program (default:
\Program{dvips}\index{dvips}) which reads the DVI file and produces an
equivalent PostScript\index{PostScript} file. If necessary, \Command{make ps}
generates an up-to-date DVI file first.

You can view the PostScript file at your screen: In analogy to \Command{make
viewdvi} the command \Command{make viewps}\index{make viewps} starts a
previewer (default: \Program{ghostview}\index{ghostview}).

If your {\Imakefile} describes more than one document, \Command{make name.ps}
generates the PostScript version of a  particular one.}



\German{
\subsection{make dvipsfig}

Zur Unterst"utzung der effizienten Nutzung des zentralen Drucksystems Siemens
2050\index{Drucker!Siemens 2050} am Fachbereich Informatik der Universit"at
Dortmund existiert das spezielle {\make}-Target \Command{dvipsfig}\index{make
dvipsfig}, das eine Datei mit Endung \File{.dvipsfig}\index{DVIPSFIG-Format}
zur Ausgabe auf diesem Drucker erzeugt.  Sofern Sie Ihr Erzeugnis auf dem
Siemens 2050 ausdrucken wollen, sollten Sie stets dieses Format an Stelle von
PostScript verwenden, da die Ausgabe dann wesentlich schneller erfolgt.}



\subsection{make clean, make veryclean}

\German{Mit \Command{make clean}\index{make clean} l"oschen Sie alle Hilfs- und
Logdateien sowie die PostScript- und DVIPSFIG-Dateien, kurz: s"amtliche Files,
die durch ein entsprechendes {\make}-Kommando neu identisch generiert werden
k"onnten.

Das Kommando \Command{make veryclean}\index{make veryclean} ist noch etwas
durchgreifender: Es l"oscht auch die DVI-Datei.}

\English{With \Command{make clean}\index{make clean} you can remove all help
files, log files and PostScript files. In short: all files you can easily
regenerate identically by a {\make} command.

The command \Command{make veryclean}\index{make veryclean} is a bit more
decisive: It also deletes the DVI file.}


\German{\subsection{make depend}}
\English{\subsection{make depend}}
\label{make depend}
\index{make depend|(}

\German{Umfangreiche Dokumente teilt man gern auf mehrere Dateien auf, die von
der Hauptdatei durch das {\LaTeX}-Kommando
\Type{$\backslash$input}\index{input@\Type{input}} eingelesen werden, zum
Beispiel:}

\English{Extensive documents you will likely split into several files which are
combined in the main file by the {\LaTeX} command
\Type{$\backslash$input}\index{input@\Type{input}}. Example:}

\begin{quote}
\begin{verbatim}
\input{chapter1.tex}
\input{chapter2.tex}
\input{chapter3.tex}
\end{verbatim}
\end{quote}

\German{Wenn Sie in einer dieser Dateien etwas "andern, kann {\make} nicht ohne
weiteres wissen, da"s jetzt ein {\LaTeX}-Lauf f"allig w"are, um die DVI-Datei
neu zu erzeugen, da die Hauptdatei nicht ge"andert wurde. Abhilfe schafft das
Kommando \Command{make depend}: es sorgt daf"ur, da"s ein an\-schlie\-"sen\-des
\Command{make dvi} auch diese Dateien ber"ucksichtigt. Dazu untersucht es die
Hauptdatei auf \Type{$\backslash$input}-Anweisungen und f"ugt f"ur die
erkannten Dateinamen entsprechende
Abh"angigkeiten\index{Abhangigkeiten@Abh\"{a}ngigkeiten!von eingelesenen
Dateien}\index{eingelesene Dateien} an das {\Makefile} an. 
Selbst\-ver\-st"and\-lich werden die gefundenen Dateien auf weitere
Eingabefiles untersucht.  \Command{make depend} erkennt "ubrigens nicht nur die
Anweisung \Type{$\backslash$input}\index{input@\Type{input}}, sondern auch die
Kommandos \Type{$\backslash$include}\index{include@\Type{include}},
\Type{$\backslash$verbfile}\index{verbfile@\Type{verbfile}},
\Type{$\backslash$blackandwhite}\index{blackandwhite@\Type{blackandwhite}},
\Type{$\backslash$epsffile}\index{epsffile@\Type{epsffile}} und
\Type{$\backslash$psfig}\index{psfig@\Type{psfig}}.}

\English{\noindent If you modify one of these files, {\make} will not
automatically run {\LaTeX} in order to recreate the DVI file, because the main
file remained unchanged. The command \Command{make depend} solves this problem:
It searches the main source file for \Type{$\backslash$input} commands and for
each file found it appends an appropriate {\make}
dependency\index{Dependency} to the {\Makefile}. Of course  the files found
are searched in turn for more input files. By the way, \Command{make depend}
not only recognizes the \Type{$\backslash$input}\index{input@\Type{input}}
command, but also \Type{$\backslash$include}\index{include@\Type{include}},
\Type{$\backslash$verbfile}\index{verbfile@\Type{verbfile}},
\Type{$\backslash$blackandwhite}\index{blackandwhite@\Type{blackandwhite}},
\Type{$\backslash$epsffile}\index{epsffile@\Type{epsffile}} und
\Type{$\backslash$psfig}\index{psfig@\Type{psfig}}.}

\German{Sollten Sie Ihre Unterdateien allerdings nicht mit einer der genannten
Anweisungen einlesen, sondern daf"ur beispielsweise ein eigenes
Makro\index{Makro!eigenes} verwenden, funktioniert dieser Mechanismus nicht. 
Sie haben aber die M"oglichkeit, die Dateien explizit in einer {\Imake}-Regel
anzugeben. An Stelle von}

\English{However, this mechanism does not work if you do not read your input
files with these commands but with self-defined
macros\index{Macro!self-defined} instead. Such input files you can specify
explicitly in an {\Imake} rule. Instead of}

\begin{quote}
\begin{verbatim}
SimpleLatexTarget(example)
\end{verbatim}
\end{quote}

\German{schreiben Sie im}
\English{\noindent you write in the}
{\Imakefile}:

\begin{quote}
\begin{verbatim}
NormalLatexTarget(example,chapter1.tex chapter2.tex chapter3.tex)
\end{verbatim}
\end{quote}

\German{Eine weitere M"oglichkeit ist die Erweiterung des von \Command{make
depend} verwendeten Suchmusters. Einzelheiten dazu finden Sie in Kapitel
\ref{Aendern des Suchmusters} auf Seite~\pageref{Aendern des Suchmusters}.}

\English{\noindent Another option you have is to extend the search pattern
\Command{make depend} uses. See chapter \ref{Aendern des Suchmusters} on
page~\pageref{Aendern des Suchmusters} for details.}

\index{make depend|)}


\subsection{make Makefiles}\index{make Makefiles|(}

\German{{\imt} ist in der Lage, sich auch um Dokumente in
Unterverzeichnissen\index{Unterverzeichnisse}\index{Subdirectories} zu
k"ummern. Mehrfache Verschachtelungen sind ebenfalls m"oglich. Jedes einzelne
Directory enth"alt ein eigenes {\Imakefile}. Sofern es "uber Unterverzeichnisse
verf"ugt, m"ussen diese in das {\Imakefile} eingetragen werden. Hier ein
Beispiel:}

\English{{\imt} is able to care for documents residing in
subdirectories\index{subdirectories}. Multiple nesting is also possible. Each
single directory holds its own {\Imakefile}. If it has subdirectories, you must
list them in the {\Imakefile} as the following example shows:}

\begin{quote}
\begin{verbatim}
#include <TeX.tmpl>

#define IHaveSubdirs
#define PassCDebugFlags /* not useful here, but must be defined */

SUBDIRS = doc1 doc2 examples

MakeSubdirs($(SUBDIRS))
DependSubdirs($(SUBDIRS))
\end{verbatim}
\end{quote}

\German{Das Kommando \Command{make Makefiles} auf der obersten Ebene erstellt
die notwendigen {\Makefiles} in den Unterverzeichnissen. Anschlie"send
verzweigen die Kommandos \Command{make all}, \Command{make depend} und
\Command{make clean} auch in die Subdirectories. Bei den "ubrigen
{\make}-Targets ist dies in dieser {\imt}-Version noch nicht der Fall.}

\English{\noindent Given in the top-level directory, the command \Command{make
Makefiles} creates the necessary {\Makefiles} in the subdirectories. 
Subsequent \Command{make all}, \Command{make depend} and \Command{make clean}
also descend down into subdirectories. This is not the case with the rest of
the {\make} targets in this {\imt} version.}

\index{make Makefiles|)}


\German{\subsection{Wenn's schnell gehen soll{\dots}}}
\English{\subsection{If You Are In a Hurry{\dots}}}

\German{{\dots}und das Inhaltsverzeichnis oder die Literatur"ubersicht noch
nicht unbedingt korrekt sein m"ussen, definiert man das {\make}-Makro oder die
Environment-Variable \EnvVar{TEXDRAFT}\index{TEXDRAFT}. (Wie das geht,
schildert Kapitel \ref{Konfiguration mit Environment-Variablen und
Make-Makros}.) Ist dieser Parameter gesetzt, startet das
\Command{make}-Kommando maximal einen
{\LaTeX}-Lauf\index{LaTeX-Lauf@{\LaTeX}-Lauf!schneller}\index{schneller
LaTeX-Lauf@schneller {\LaTeX}-Lauf}, und der Benutzer hat das Ergebnis nach
kurzer Zeit vorliegen.}

\English{{\dots}and don't care for a correct table of contents or bibliography,
define the {\make} macro or environment variable
\EnvVar{TEXDRAFT}\index{TEXDRAFT}. (How you can do this is explained in chapter
\ref{Konfiguration mit Environment-Variablen und Make-Makros}.) If this
parameter is set, the \Command{make} command executes only a single {\LaTeX}
run\index{LaTeX run@{\LaTeX} run!fast}, and you have your document available
after only a short while.}




\German{\section{Spezialit"aten}}
\English{\section{Specialities}}

\German{Neben den oben beschriebenen Standardregeln unterst"utzt {\imt} einige
spezielle Problemf"alle durch geeignete Regeln oder Environment-Variablen
beziehungsweise {\make}-Makros.}

\English{Besides the standard rules described above {\imt} supports some
special cases by suitables rules or environment variables resp. {\make} macros.}



\German{\subsection{Konfiguration mit Environment-Variablen und
Make-Makros}\index{Konfiguration}}
\English{\subsection{Configuration With Environment Variables and Make
Makros}\index{Configuration}}

\label{Konfiguration mit Environment-Variablen und Make-Makros}

\German{Environment-Variablen\index{Environment-Variablen} und {\make}-Makros
werden per Konvention stets mit Gro"sbuchstaben geschrieben, zum Beispiel
\EnvVar{TEXINPUTS}. Es existieren folgende M"oglickeiten zur Definition solcher
Verarbeitungsparameter:}

\English{Environment variables\index{Environment variables} and {\make} macros
are written with capital letters by convention, for example \EnvVar{TEXINPUTS}.
You have the following possiblities to define such processing parameters:}

\begin{itemize}

\item

\German{{\Make}-Makros k"onnen im {\Imakefile}\index{Makro!im {\Imakefile}}
definiert werden. Diese Methode ist vorzuziehen, wenn es sich um einen
Parameter handelt, der permanent f"ur alle {\make}-L"aufe gesetzt sein soll. 
Beispiel:}

\English{You can define {\make} macros\index{Macro!in {\Imakefile}} in the
{\Imakefile}. This method is suitable for a parameter you want to set
permanently for all {\make} runs. Example:}

\begin{quote}
\begin{verbatim}
TEXINPUTS = $(HOME)/TeX:$(TEXDEFAULTINPUTS)
\end{verbatim}
\end{quote}

\item

\German{Makros lassen sich auch auf der
\Command{make}-Kommandozeile\index{Makro!auf der Kommandozeile} spezifieren
und "uberschreiben dabei gegebenenfalls entsprechende Definitionen im
{\Imakefile}. Dadurch lassen sich tempor"are "Anderungen bequem erledigen. 
Beispiel:}

\English{Macros can also be defined of the command line\index{Macro!on
commandline} and overwrite corresponding definitions in the {\Imakefile}. This
way temporary settings can be handled easily. Example:}

\begin{quote}
\begin{verbatim}
make TEXINPUTS='$(HOME)/lib/TeX:$(TEXDEFAULTINPUTS)'
\end{verbatim}
\end{quote}

\item

\German{Irgendwo dazwischen liegt das dritte Verfahren: Man definiert eine
Environment-Variable\index{Makro!\"{u}ber Environment-Variable}, die w"ahrend
ihrer Lebensdauer f"ur alle {\make}-L"aufe gilt. Soll die Environment-Variable
ein gleichnamiges Makro im {\Imakefile} "uberschreiben, mu"s der Benutzer die
{\make}-Option \Option{-e} angeben.  Beispiel:}

\English{The third procedure is lying somewhere in between: You can define an
environment variable\index{Macro!as environment variable}, which is taken into
account by all {\make} runs as long as it exists. If the environment variable
should overwrite an equally-named macro defined in the {\Imakefile}, you have
to specify the {\make} option \Option{-e}. Example:}

\begin{quote}
\begin{verbatim}
setenv TEXINPUTS '$(HOME)/lib/TeX:$(TEXDEFAULTINPUTS)'
make -e
\end{verbatim}
\end{quote}

\end{itemize}



\subsection{AllTarget}\index{AllTarget}\label{AllTarget}

\German{Gibt der Anwender das Kommando {\make}\index{make!ohne Parameter} ohne
Parameter ein, versucht {\make}, das erste Target im {\Makefile} zu erstellen. 
Normalerweise ist dies die erste DVI-Datei, beispielsweise \File{example1.dvi}
im {\Imakefile} auf Seite~\pageref{ExamNormal}. Wer gern eine andere Regelung
h"atte, kann die {\Imake}-Regel
\ImakeRule{AllTarget}\index{AllTarget}\footnote{\ImakeRule{AllTarget} ist eine
Regel, die {\Imake} standardm"a"sig unterst"utzt.} verwenden. Diese Regel
besitzt einen Parameter, n"amlich eine Liste von {\make}-Targets, die bei
\Command{make all}\index{make all} erzeugt werden. Steht \ImakeRule{AllTarget}
vorn im {\Imakefile}, so ist gew"ahrleistet, da"s bei einem
\Command{make}-Aufruf ohne Parameter das Target \String{all} und mithin die in
\ImakeRule{AllTarget} angegebenen Targets generiert werden. Ein Beispiel m"oge
dies verdeutlichen:}

\English{If you enter the command {\make}\index{make!without parameters}
without parameters, {\make} will try to generate the first target in the
{\Makefile}. Usually this is the first DVI file, for example
\File{example1.dvi} in the {\Imakefile} on page~\pageref{ExamNormal}. If you
want something else, use the {\Imake} rule
\ImakeRule{AllTarget}\index{AllTarget}\footnote{\ImakeRule{AllTarget} is a
standard {\Imake} rule.}. This rule has one parameter: a list of {\make}
targets \Command{make all}\index{make all} should generate. Put the rule
\ImakeRule{AllTarget} in front of all other targets to generate its targets
when you enter just {\make}. An example might make this more clear:}

{\samepage
\begin{quote}
\begin{verbatim}
#include <TeX.tmpl>
NormalLatexRule()
AllTarget(example1.dvi example2.dvi)
NormalLatexTarget(example1,)
NormalLatexTarget(example2,input.tex)
\end{verbatim}
\end{quote}
}

\German{\ImakeRule{AllTarget(example1.dvi example2.dvi)} sorgt daf"ur, da"s bei
{\make} nicht nur die erste Datei \File{example1.dvi} erzeugt wird, sondern
auch \File{example2.dvi}. Es reichte sogar aus, die \ImakeRule{AllTarget()}
ohne Parameter zu schreiben, da {\imt} f"ur jede DVI-Datei \File{name.dvi}
intern ohnehin \ImakeRule{AllTarget(name.dvi)} verwendet.}

\English{\noindent In order to create not only the first file
\File{example1.dvi}, \ImakeRule{AllTarget(example1.dvi example2.dvi)} has been
written here.}



\German{\subsection{Einbinden von Graphiken}\index{Graphiken}}
\English{\subsection{Including Graphics}\index{Graphics}}

\label{Einbinden von Graphiken}


\German{\subsubsection{Imake-Regeln}}
\English{\subsubsection{Imake Rules}}

\index{PostScript|(}

\German{PostScript-Graphiken\index{Graphikformate!PostScript} kann das Makro
\Type{$\backslash$psfig}\index{psfig@\Type{psfig}} in {\LaTeX}-Dokumente
einbinden. Viele Graphiken liegen jedoch urspr"unglich nicht als
PostScript-Dateien, sondern in einem anderen Format vor, und m"ussen erst nach
Encapsulated PostScript\index{Encapsulated
PostScript}\index{PostScript!Encapsulated} konvertiert werden.  Auch dieser
Vorgang l"a"st sich mit {\imt} automatisch abwickeln.}

\English{You can include PostScript graphics\index{Graphic formats!PostScript}
in your {\LaTeX} document with the macro
\Type{$\backslash$psfig}\index{psfig@\Type{psfig}}. However, many pictures at
hand have a different image format and must be converted to Encapsulated
PostScript\index{Encapsulated PostScript}\index{PostScript!Encapsulated} first.
{\imt} can do that automatically.}

\German{{\imt} enth"alt zur Zeit Regeln zur Konvertierung von
FIG-\index{FIG}\index{Graphikformate!FIG},
GIF-\index{GIF}\index{Graphikformate!GIF},
TIFF-\index{TIFF}\index{Graphikformate!TIFF} und
TGIF-Dateien\index{TGIF}\index{Graphikformate!TGIF} nach PostScript.  Falls Sie
weitere Konverter ben"otigen und diese verf"ugbar sind, nehme ich sie gern in
{\imt} auf. Bitte setzen Sie sich mit mir in Verbindung!}

\English{Presently {\imt} comprises rules to convert
FIG\index{FIG}\index{Graphic formats!FIG}, GIF\index{GIF}\index{Graphic
formats!GIF}, TIFF\index{TIFF}\index{Graphic formats!TIFF} and
TGIF\index{TGIF}\index{Graphic formats!TGIF} files into PostScript. If you need
any more converters and such are available I'd be pleased to include them in
{\imt}. Please get in touch with me!}

\index{EpsRules|(}

\German{Die {\Imake}-Regel \ImakeRule{EpsRules()} bindet die Graphikkonverter
in das generierte {\Makefile} ein. Jede zu generierende PostScript-Bilddatei
wird in einer \ImakeRule{Eps\-Tar\-get()}\index{EpsTarget}-Regel spezifiziert. 
Das sieht zum Beispiel so aus:}

\English{The {\Imake} rule \ImakeRule{EpsRules()} includes the graphics
converters in the generated {\Makefile}. Each PostScript image file which
{\imt} must generate is specified by a
\ImakeRule{Eps\-Tar\-get()}\index{EpsTarget} rule. Consider the following
example:}

\begin{quote}
\begin{verbatim}
#include <TeX.tmpl>

AllTarget(example.dvi)

EpsRules()
EpsTarget(bild1)
EpsTarget(bild2)

NormalLatexTarget(Folien,EpsObject(bild1) EpsObject(bild2))
\end{verbatim}
\end{quote}

\index{AllTarget}
\index{EpsRules}
\index{EpsTarget}
\index{EpsObject}
\index{NormalLatexTarget}

\German{Wie in \ref{AllTarget} beschrieben, sorgt die Regel
\ImakeRule{AllTarget(example.dvi)} daf"ur, da"s bei Eingabe des Kommandos
{\make} ohne Parameter die Zieldatei \File{example.dvi} erzeugt wird. Ohne
diese Regel erstellte {\make} das erste im {\Makefile} angegebene Ziel, hier
die PostScript-Datei \File{bild1.eps}.}

\English{\noindent As described in \ref{AllTarget}, rule
\ImakeRule{AllTarget(example.dvi)} allows the user to simply type
\Command{make} without any parameters in order create the target file
\File{example.dvi}. Without this rule {\make} would create the first target
mentioned in the {\Makefile}, here the PostScript file \File{bild1.eps}.}

\German{Damit ist bereits die Wirkung von
\ImakeRule{Eps\-Tar\-get}\index{EpsTarget} angedeutet: Diese {\Imake}-Regel
erzeugt automatisch die angegebene PostScript-Bilddatei aus der zugeh"origen
Quelldatei. Welcher Konverter ausgef"uhrt wird, bestimmt die Endung des
Originaldateinamens. Wurde die Quelldatei zum Beispiel mit
\Program{xfig}\index{xfig} erzeugt und liegt im
FIG-Format\index{FIG}\index{Graphikformate!FIG} vor (Endung {\tt .fig}),
erfolgt die Konvertierung durch}

\English{\ImakeRule{Eps\-Tar\-get}\index{EpsTarget} automatically generates the
specified PostScript image file from the corresponding source file. The source
file's extension determines which converter is to be used. If the source file
has been created with \Program{xfig}\index{xfig} and is present in the FIG
format\index{FIG}\index{Graphic formats!FIG} (Extension {\tt .fig}) the
conversion is done by}

\begin{quote}
\begin{verbatim}
(fig2dev -L ps | sed -e 's/setgray fill/setgray eofill/g') \
<bild1.fig >bild1.eps
\end{verbatim}
\end{quote}

\German{Bei GIF-Dateien\index{GIF}\index{Graphikformate!GIF} (Endung {\tt
.gif}) f"uhrt {\make} folgende Kommandos aus:}

\English{\noindent GIF files\index{GIF}\index{Graphic formats!GIF} (Extension
{\tt .gif}) are converted as follows:}

\begin{quote}
\begin{verbatim}
(giftoppm | ppmtopgm | pnmtops -noturn -rle) <bild2.gif >bild2.eps
\end{verbatim}
\end{quote}

\German{Diese Kommandofolge wandelt das GIF-Datei zun"achst mit Hilfe des
PBMPLUS-Programms\index{PBMPLUS} \Program{giftoppm}\index{giftoppm} in das
PPM-Format\index{PPM}\index{Graphikformate!PPM} (Portable Pixmap, f"ur
Farbbilder), generiert daraus ein entsprechendes Graustufenbild
(\Program{ppmtopgm}\index{ppmtopgm}) und konvertiert dieses schlie"slich nach
PostScript (\Program{pnmtops}\index{pnmtops}). Die Farb\-in\-for\-ma\-tion ist
sicher in den meisten F"allen entbehrlich, n"amlich wenn auf einem
Schwarzwei"sdrucker\index{Drucker!schwarzwei{\ss}} ausgegeben wird. Wer seinen
Ausdruck unbedingt farbig braucht, kann die Voreinstellung durch die Anweisung}

\English{\noindent This command sequence first uses the PBMPLUS\index{PBMPLUS}
program \Program{giftoppm}\index{giftoppm} to convert the GIF file into the
PPM\index{PPM}\index{Graphic formats!PPM} representation (Portable Pixmap, for
color images), reduces it to a corresponding grayscale image
(\Program{ppmtopgm}\index{ppmtopgm}) and finally creates the PostScript file
(\Program{pnmtops}\index{pnmtops}). If the output goes to a blank-and-white
printer\index{Printer!blank-and-white}, the color information is dispensable. 
However, if you need color output, change the default by the line}

\begin{quote}
\begin{verbatim}
GIFTOEPS = (giftoppm | pnmtops -noturn -rle)
\end{verbatim}
\end{quote}

\German{im {\Imakefile} "uberschreiben.}

\English{\noindent in your {\Imakefile}.}

\German{Bei reinen
Schwarzwei"sbildern\index{Schwarzweisbilder@Schwarzwei{\ss}bilder} (ohne
Graustufen) kann der Benutzer seine GIF-Datei so umbenennen, das sie die Endung
{\tt .gif-bw} an Stelle von {\tt .gif} erh"alt. Bei solchen Dateien schickt
{\imt} das Graustufenbild noch durch den Filter
\Program{pgmtopbm}\index{pgmtopbm}, und die PostScript-Datei wird deutlich
kleiner.}

\English{GIF files with pure blank-and-white images (without grayscales) you
should give a filename extension of {\tt .gif-bw} instead of {\tt .gif}. {\imt}
will pipe files with such an extension through the additional filter
\Program{pgmtopbm}\index{pgmtopbm}, which will reduce the size of the
PostScript file considerably.}

\German{\bold{Achtung:} F"ur eine Datei, die im Original bereits im
PostScript-Format vorliegt, darf \bold{kein}
\ImakeRule{Eps\-Tar\-get}\index{EpsTarget} vorhanden sein. Die Datei w"urde
sonst durch \Command{make clean}\index{make clean} gel"oscht.}

\English{\bold{Attention:} Never write down an
\ImakeRule{Eps\-Tar\-get}\index{EpsTarget} for a file which is in PostScript
format originally! Any \Command{make clean}\index{make clean} would remove it.}

\German{Der\footnote{Dies ist in der Tat ein einziger Parameter, n"amlich ---
aus der Sicht von {\Imake} --- ein simpler String.} Parameter
\bold{EpsObject(bild1) EpsObject(bild2)}\index{EpsObject} besagt, da"s die
DVI-Datei von den Graphiken \File{bild1} und \File{bild2} abh"angt.  Sofern die
entsprechenden PostScript-Dateien \File{bild1.eps} und \File{bild2.eps} per
\Type{$\backslash$psfig} eingelesen werden, kann dieser
\ImakeRule{NormalLatexTarget}-Parameter leer gelassen werden.}

\English{The parameter \bold{EpsObject(bild1)
EpsObject(bild2)}\index{EpsObject} tells {\imt} that the DVI file depends on
the pictures \File{bild1} and \File{bild2}. If their PostScript representations
\File{bild1.eps} and \File{bild2.eps} are read by \Type{$\backslash$psfig},
this \ImakeRule{NormalLatexTarget} parameter may be left blank.}

\index{EpsRules|)}
\index{PostScript|)}



\German{\subsubsection{Konfigurationsm"oglichkeiten}}
\English{\subsubsection{Configuration Options}}

\German{Die Konvertierung\index{Konvertierung!von Bilddateien} der Quellformate
nach EPS erledigen Filter, die der Benutzer "uber folgende Makros definieren
kann:}

\English{Image conversion\index{Image convertion} from source formats to EPS is
done by filters. You can change the default filters by redefining the following
macros:}

\begin{description}

\item[GIFTOEPS\index{GIFTOEPS}:] 

\German{konvertiert GIF nach EPS.\\ Voreinstellung: }\English{converts GIF into
EPS.\\ Default: }\Type{(giftoppm $|$ ppmtopgm $|$ pnmtops -noturn -rle)}

\item[GIFBWTOEPS\index{GIFBWTOEPS}:]

\German{konvertiert Schwarzwei"s-GIF nach EPS.\\ Voreinstellung:
}\English{converts black-and-white GIFs into EPS.\\ Default: }\Type{(giftoppm
$|$ ppmtopgm $|$ pgmtopbm $|$ pnmtops -noturn -rle)}

\item[FIGTOEPS\index{FIGTOEPS}:]

\German{konvertiert FIG nach EPS.\\ Voreinstellung: }\English{converts FIG into
EPS.\\ Default: }\Type{(fig2dev -L ps $|$ sed -e 's/setgray fill/setgray
eofill/g'}

\end{description}



\German{\subsection{Papierformate}\index{Papierformat}}
\English{\subsection{Paper Formats}\index{Paper formats}}

\label{Papierformate}

\German{Die von {\imt} unterst"utzten Previewer\index{Previewer}
\Program{xdvi}\index{xdvi} und \Program{ghostview}\index{ghostview} sowie der
Konverter \Program{dvips}\index{dvips} verlangen die Spezifikation des
verwendeten Papierformats.  Findet das Programm keine entsprechende
Kommandozeilenoption, w"ahlt es eine programmspezifische
Voreinstellung\index{Papierformat!programmspezifische Voreinstellung}. 
Europ"aische Anwender sind damit zumeist schlecht bedient, da es sich dabei in
der Regel um amerikanische Formate handelt. Es empfiehlt sich daher, das
verwendete Papierformat durch eine entsprechende {\Imake}-Regel explizit
festzulegen. Folgende Regeln unterst"utzt {\imt} derzeit:}

\English{The previewers\index{Previewer} \Program{xdvi}\index{xdvi} and
\Program{ghostview}\index{ghostview} as well as the converter
\Program{dvips}\index{dvips} require the specification of the paper format you
want to use. If the program does not find an appropriate command line option it
will take an application specific default. The latter are mostly American
formats and thus usually unsuitable for European users. It is therefore not a
bad idea to specify the paper format explicitly by an {\Imake} rule. {\imt}
presently supports the following rules:}

\begin{center}
\begin{tabular}{l|l}
\German{{\Imake}-Regel}\English{{\Imake} rule} & \German{Papierformat}\English{Paper format} \\
\hline
PaperFormatA4()\index{PaperFormatA4}           & DIN A4 \German{hochkant}\English{portrait}\\
PaperFormatA4R()\index{PaperFormatA4R}         & DIN A4 \German{quer}\English{landscape} \\
PaperFormatLetterR()\index{PaperFormatLetterR} & Letter \German{quer}\English{landscape} \\
\end{tabular}
\end{center}

\German{Diese Regeln vermitteln die korrekten Gr"o"senangaben an die oben
genannten Programme  weiter. \bold{Achtung:} Auf den {\LaTeX}-Lauf und die
Erzeugung der DVI-Datei sind die Angaben zum Papierformat ohne Einflu"s. Hier
z"ahlen nur die Gr"o"senangaben\index{Papierformat!Grosenangaben in der
TeX-Quelldatei@Gr\"{o}{\ss}enangaben in der {\TeX}-Quelldatei} in der
{\TeX}-Quelldatei.}

\English{\noindent These rules pass the correct paper sizes to the above
mentioned programs. {\bf Attention:} The paper format rules do not affect the
{\LaTeX} run and the DVI file generation in any way. Here only the settings in
the {\TeX} source file\index{Paper formats!Settings in TeX source file@Settings
in {\TeX} source file} are taken into consideration.}

\German{Sollten Sie neben den oben aufgelisteten weitere Formate ben"otigen,
setzen Sie sich bitte mit mir in Verbindung!}

\English{In case you should need any more paper formats, please let me know!}


\German{\subsubsection{Konfigurationsm"oglichkeiten}}
\English{\subsubsection{Configuration Options}}

\German{Das vom Benutzer im {\Imakefile} gew"ahlte Format vermittelt {\imt}
"uber die Makros \EnvVar{FORMATXDVI}\index{FORMATXDVI},
\EnvVar{FORMATDVIPS}\index{FORMATDVIPS} und
\EnvVar{FORMATGHOSTVIEW}\index{FORMATGHOSTVIEW} weiter. \EnvVar{FORMATXDVI}
enth"alt dabei die Option \Option{-paper} von \Program{xdvi},
\EnvVar{FORMATDVIPS} die Option \Option{-t} von \Program{dvips}, und
\Program{ghostview} erf"ahrt sein Format "uber \EnvVar{FORMATGHOSTVIEW}.}

\English{The paper format you have selected in the {\Imakefile} {\imt} passes
on by use the macros \EnvVar{FORMATXDVI}\index{FORMATXDVI},
\EnvVar{FORMATDVIPS}\index{FORMATDVIPS} and
\EnvVar{FORMATGHOSTVIEW}\index{FORMATGHOSTVIEW}. \EnvVar{FORMATXDVI} holds
\Program{xdvi}'s option \Option{-paper}, \EnvVar{FORMATDVIPS} \Program{dvips}'
option \Option{-t}, and \Program{ghostview} learns about its paper format by
\EnvVar{FORMATGHOSTVIEW}.}



\German{\subsection{{\TeX}-Eingabedateien}\index{TeX-Eingabedateien@{\TeX}-Eingabedateien}}
\English{\subsection{{\TeX} Input Files}\index{TeX input files@{\TeX} input
files}}

\label{TeX-Eingabedateien}

\German{Wenn nichts weiter angegeben ist, sucht der
\Type{$\backslash$input}-Befehl eine einzulesende Datei\index{eingelesene
Dateien} zun"achst im aktuellen Directory und an\-schlie\-"send im globalen
{\TeX}-Inputs-Verzeichnis. Weitere Directories, in denen {\TeX} nach solchen
Dateien suchen soll, k"onnen Sie mit Hilfe der Environment-Variablen
\EnvVar{TEXINPUTS}\index{TEXINPUTS} spezifizieren.  Beispiel: Sie besitzen
eigene Style-Dateien im Directory \File{TeX} unterhalb Ihres
Home-Verzeichnisses. Damit {\TeX} sie findet, tragen Sie die Zeile}

\English{Normally the \Type{$\backslash$input} command looks for an input
file\index{Input files} in the currect directory first and, if it is not found
there, in the global {\TeX} inputs directory. You can specify further
directories with the help of the \EnvVar{TEXINPUTS}\index{TEXINPUTS}
environment variable. Example: You have your own style files in directory
\File{TeX} below your home directory. To let {\TeX} find them, put the line}

\begin{quote}
\begin{verbatim}
TEXINPUTS = .:$(HOME)/TeX:$(TEXDEFAULTINPUTS)
\end{verbatim}
\end{quote}

\German{in Ihr {\Imakefile} ein.}
\English{\noindent into your {\Imakefile}.}

\German{Wie Sie richtig vermuten, k"onnen Sie "uber die symbolische Bezeichnung
\EnvVarRef{TEXDEFAULTINPUTS}\index{TEXDEFAULTINPUTS} das
\File{inputs}-Directory der lokalen {\TeX}-Installation ansprechen, ohne da"s
Sie wissen m"ussen, wo genau sich dieses Verzeichnis befindet.}

\English{As you might guess see, the symbolic name
\EnvVarRef{TEXDEFAULTINPUTS}\index{TEXDEFAULTINPUTS} addresses the
\File{inputs} directory of your local {\TeX} installation. You don't have to
know where this directory is actually located.}



\German{\subsection{"Andern des Suchmusters f"ur "`make depend"'}}
\English{\subsection{Changing the Search Pattern For ``make depend''}}

\label{Aendern des Suchmusters}

\German{\index{make depend!\"{A}ndern des Suchmusters|(}}
\English{\index{make depend!changing the search pattern|(}}

\German{Das Kommando \Command{make depend}\index{make depend} erkennt nur
solche Dateien, die, ausgehend von der Hauptdatei, mit mit
\Type{$\backslash$input}\index{input@\Type{input}},
\Type{$\backslash$verbfile}\index{verbfile@\Type{verbfile}},
\Type{$\backslash$blackandwhite}\index{blackandwhite@\Type{blackandwhite}} oder
\Type{$\backslash$psfig}\index{psfig@\Type{psfig}} eingelesen werden. Sie
k"onnen diese Liste um weitere Schl"usselw"orter erweitern, indem Sie das von
\Command{make depend} voreingestellte Suchmuster entsprechend erweitern. Die
Voreinstellung sieht so aus:}

\English{The command \Command{make depend}\index{make depend} recognizes only
those files which are read by
\Type{$\backslash$input}\index{input@\Type{input}},
\Type{$\backslash$include}\index{include@\Type{include}},
\Type{$\backslash$verbfile}\index{verbfile@\Type{verbfile}},
\Type{$\backslash$blackandwhite}\index{blackandwhite@\Type{blackandwhite}},
\Type{$\backslash$epsffile}\index{epsffile@\Type{epsffile}} or
\Type{$\backslash$psfig}\index{psfig@\Type{psfig}}. You can add further key
words to this list by amending \Command{make depend}'s default search pattern. 
The default looks like this:}

\begin{quote}
\begin{verbatim}
-e '/\\psfig/ s/^.*figure=\([^,}]*\).*/\1/p' \
-e '/\\epsffile/ s/.*epsffile *{\([^}]*\)}.*/\1/p' \
-e '/\\input/ s/.*input *{\([^}]*\.tex\)}.*/\1/p' \
-e '/\\verbfile/ s/.*verbfile {\([^}]*\.tex\)}.*/\1/p' \
-e '/\\blackandwhite/ s/.*blackandwhite *{\([^}]*.tex\)}.*/\1/p' \
-e '/\\input/ s/.*input *{\([^}]*\)}.*/\1.tex/p' \
-e '/\\include/ s/.*include *{\([^}]*\)}.*/\1.tex/p' \
-e '/\\verbfile/ s/.*verbfile *{\([^}]*\)}.*/\1.tex/p' \
-e '/\\blackandwhite/ s/.*blackandwhite *{\([^}]*\)}.*/\1.tex/p'
\end{verbatim}
\end{quote}

\German{Was hier so f"urchterlich aussieht, sind Suchmuster f"ur den
Stream-Editor \Program{sed}\index{sed}, der intern von \Command{make depend}
aufgerufen wird.  Solange Sie nur solche neuen Einlesekommandos definieren
wollen, die die gleiche Aufrufsyntax wie
\Type{$\backslash$input}\index{input@\Type{input}} besitzen, ist die "Anderung
nicht schwer. Kopieren Sie die beiden Zeilen mit \Type{-e
'/$\backslash\backslash$input} am Anfang\footnote{Sie finden diese Zeilen im
generierten {\Makefile}.} und ersetzen Sie in den Kopien "`input"' durch Ihr
eigenes Kommando, zum Beispiel \Type{$\backslash$einlesen}. Schlie"slich tragen
Sie im {\Imakefile} ein:}

\English{\noindent This horrible thing is a search pattern for the stream
editor \Program{sed}\index{sed}, which is called internally by \Command{make
depend}.  As long as you define only input commands which have the same calling
syntax as \Type{$\backslash$input}\index{input@\Type{input}}, amending the list
is not hard. Copy the tow lines starting with \Type{-e
'/$\backslash\backslash$input}\footnote{You will find these lines in the
generated {\Makefile}} and within the copies replace "`input"' by your own
command, for example \Type{$\backslash$einlesen}. Finally you enter into your
{\Imakefile}:}

\begin{quote}
\begin{verbatim}
TEXDEPENDPATTERN = -e '/\\psfig/ s/^.*figure=\([^,}]*\).*/\1/p' \
-e '/\\epsffile/ s/.*epsffile *{\([^}]*\)}.*/\1/p' \
-e '/\\input/ s/.*input *{\([^}]*\.tex\)}.*/\1/p' \
-e '/\\einlesen/ s/.*einlesen *{\([^}]*\.tex\)}.*/\1/p' \
-e '/\\verbfile/ s/.*verbfile {\([^}]*\.tex\)}.*/\1/p' \
-e '/\\blackandwhite/ s/.*blackandwhite *{\([^}]*.tex\)}.*/\1/p' \
-e '/\\input/ s/.*input *{\([^}]*\)}.*/\1.tex/p' \
-e '/\\einlesen/ s/.*einlesen *{\([^}]*\)}.*/\1.tex/p' \
-e '/\\include/ s/.*include *{\([^}]*\)}.*/\1.tex/p' \
-e '/\\verbfile/ s/.*verbfile *{\([^}]*\)}.*/\1.tex/p' \
-e '/\\blackandwhite/ s/.*blackandwhite *{\([^}]*\)}.*/\1.tex/p'
\end{verbatim}
\end{quote}
\index{TEXDEPENDPATTERN}
\index{make depend!\"{A}ndern des Suchmusters|)}


\German{\subsection{Konfiguration von Konvertern und Previewern}}
\English{\subsection{Configuring Converters and Previewers}}

\German{
\index{Konfiguration!Konverter}
\index{Konfiguration!Previewer}
\index{Previewer!Konfiguration}}

\English{
\index{Configuration!converters}
\index{Configuration!previewers}
\index{Previewer!configuration}}

\German{Die Konverter, die aus der DVI-Datei Daten im PostScript- und
DVIPSFIG-Format erzeugen, und die zu verwenden Previewer lassen sich "uber
folgende Makros festlegen:}

\English{The converter to transform the DVI file to PostScript and the
previewers to be used you can specify by the following macros:}

\begin{description}

\item[DVITOPSCMD\index{DVITOPSCMD}:]

\German{konvertiert DVI nach PostScript.  Voreinstellung: }\English{converts
DVI into PostScript. Default: }\verb+dvips+

\item[DVITOPSOPT\index{DVITOPSOPT}:] \German{Optionen f"ur den
PostScript-Konverter.  Voreinstellung: }\English{options for the PostScript
converter. Default: }\verb+$(FORMATDVIPS) -f+

\item[DVITOPSFIGCMD\index{DVITOPSFIGCMD}:] \German{konvertiert DVI nach
DVIPSFIG. Voreinstellung: }\English{converts DVI into DVIPSFIG. Default:
}\verb+dvi2prt+

\item[DVITOPSFIGOPT\index{DVITOPSFIGOPT}:] \German{Optionen f"ur den
DVIPSFIG-Konverter. Voreinstellung: leer}\English{options for the DVIPSFIG
converter. Default: empty}

\item[VIEWDVICMD\index{VIEWDVICMD}:] \German{zeigt die DVI-Datei an. 
Voreinstellung:}\English{displays the DVI file. Default: } \verb+xdvi+

\item[VIEWDVIOPT\index{VIEWDVIOPT}:] \German{Optionen f"ur den DVI-Previewer. 
Voreinstellung:}\English{options for the DVI previewer. Default: }
\verb+$(FORMATXDVI)+

\item[VIEWPSCMD\index{VIEWPSCMD}:] \German{zeigt die PostScript-Datei an. 
Voreinstellung: }\English{displays the PostScript file. Default: }
\verb+ghostview+

\item[VIEWPSOPT\index{VIEWPSOPT}:] \German{Optionen f"ur den
PostScript-Previewer.\\ Voreinstellung:}\English{options for the PostScript
previewer.\\ Default:} \verb+$(FORMATGHOSTVIEW) -magstep -1+

\end{description}

\newpage




\German{\section{"Ubersicht: Imake-Regeln}}
\English{\section{Overview: Imake Rules}}

\newcommand{\entry}[1]{#1\index{#1}}

\German{\subsection{Standardregeln}}
\English{\subsection{Standard rules}}

\begin{center}
\begin{tabular}{|lll|}
\hline
\German{\bold{Regel}}\English{\bold{Rules}} & \bold{Parameter} & \German{\bold{Beschreibung}}\English{\bold{Description}} \\
\hline
\hline
\entry{SimpleLatexTarget}             & texfile                & \ref{SimpleLatexTarget} \\
\entry{SimpleLatexIndexTarget}        & texfile                & \ref{NormalLatexIndexTarget}, \ref{NormalLatexTarget} \\
\entry{SimpleLatexBibtexTarget}       & texfile,bibtexlib      & \ref{NormalLatexBibtexTarget}, \ref{NormalLatexTarget} \\
\entry{SimpleLatexBibtexIndexTarget}  & texfile,bibtexlib      & \ref{NormalLatexBibtexIndexTarget}, \ref{NormalLatexTarget} \\
\entry{SimpleLatexIndexBibtexTarget}  & texfile,bibtexlib      & \ref{NormalLatexIndexBibtexTarget}, \ref{NormalLatexTarget} \\
\hline
\entry{NormalLatexRule}               & ---                    & \ref{NormalLatexRule} \\
\entry{NormalLatexTarget}             & texfile,deps           & \ref{NormalLatexTarget} \\
\entry{NormalLatexIndexTarget}        & texfile,deps           & \ref{NormalLatexIndexTarget} \\
\entry{NormalLatexBibtexTarget}       & texfile,deps,bibtexlib & \ref{NormalLatexBibtexTarget} \\
\entry{NormalLatexBibtexIndexTarget}  & texfile,deps,bibtexlib & \ref{NormalLatexBibtexIndexTarget} \\
\entry{NormalLatexIndexBibtexTarget}  & texfile,deps,bibtexlib & \ref{NormalLatexIndexBibtexTarget} \\
\hline
\entry{SimpleSlitexTarget}            & texfile                & \ref{SimpleLatexTarget}, \ref{SLITeX} \\
\entry{SimpleSlitexIndexTarget}       & texfile                & \ref{NormalLatexIndexTarget}, \ref{NormalLatexTarget}, \ref{SLITeX} \\
\entry{SimpleSlitexBibtexTarget}      & texfile,bibtexlib      & \ref{NormalLatexBibtexTarget}, \ref{NormalLatexTarget}, \ref{SLITeX} \\
\entry{SimpleSlitexBibtexIndexTarget} & texfile,bibtexlib      & \ref{NormalLatexBibtexIndexTarget}, \ref{NormalLatexTarget}, \ref{SLITeX} \\
\entry{SimpleSlitexIndexBibtexTarget} & texfile,bibtexlib      & \ref{NormalLatexIndexBibtexTarget}, \ref{NormalLatexTarget}, \ref{SLITeX} \\
\hline
\entry{NormalSlitexRule}              & ---                    & \ref{NormalLatexRule}, \ref{SLITeX} \\ 
\entry{NormalSlitexTarget}            & texfile,deps           & \ref{NormalLatexTarget}, \ref{SLITeX} \\
\entry{NormalSlitexIndexTarget}       & texfile,deps           & \ref{NormalLatexIndexTarget}, \ref{SLITeX} \\
\entry{NormalSlitexBibtexTarget}      & texfile,deps,bibtexlib & \ref{NormalLatexBibtexTarget}, \ref{SLITeX} \\
\entry{NormalSlitexBibtexIndexTarget} & texfile,deps,bibtexlib & \ref{NormalLatexBibtexIndexTarget}, \ref{SLITeX} \\
\entry{NormalSlitexIndexBibtexTarget} & texfile,deps,bibtexlib & \ref{NormalLatexIndexBibtexTarget}, \ref{SLITeX} \\
\hline
\end{tabular}
\end{center}



\German{\subsection{Einbinden von Graphiken}}
\English{\subsection{Including Graphics}}

\begin{center}
\begin{tabular}{|lll|}
\hline
\German{\bold{Regel}}\English{\bold{Rules}} & \bold{Parameter} & \German{\bold{Beschreibung}}\English{\bold{Description}} \\
\hline
\hline
\entry{EpsRules}       & ---              & \ref{Einbinden von Graphiken} \\
\entry{EpsObject}      & psname           & \ref{Einbinden von Graphiken} \\
\entry{EpsTarget}      & psname           & \ref{Einbinden von Graphiken} \\
\hline
\entry{FigToEpsRule}   & ---              & \ref{Einbinden von Graphiken} \\
\entry{GifToEpsRule}   & ---              & \ref{Einbinden von Graphiken} \\
\entry{GifBwToEpsRule} & ---              & \ref{Einbinden von Graphiken} \\
\hline
\end{tabular}
\end{center}



\German{\subsection{Papierformate}}
\English{\subsection{Paper Formats}}

\begin{center}
\begin{tabular}{|lll|}
\hline
\German{\bold{Regel}}\English{\bold{Rules}} & \bold{Parameter} & \German{\bold{Beschreibung}}\English{\bold{Description}} \\
\hline
\hline
\entry{PaperFormatA4}      & ---              & \ref{Papierformate} \\
\entry{PaperFormatA4R}     & ---              & \ref{Papierformate} \\
\hline
\entry{PaperFormatLetterR} & ---              & \ref{Papierformate} \\
\hline
\end{tabular}
\end{center}




\German{\section{"Ubersicht: Environment-Variablen und Make-Makros}}
\English{\section{Overview: Environment Variables And Make Makros}}

\newcommand{\is}{\German{installationsspezifisch}\English{installation dependend}}
\newcommand{\ud}{\German{undefiniert}\English{undefined}}

{\footnotesize
\begin{center}
\begin{tabular}{l|l}
\German{\bold{Make-Makro:}}\English{\bold{Make makro:}} & \German{\bold{Voreinstellung:}}\English{\bold{Default:}} \\
\hline
\hline
\entry{DVITOPSFIGCMD}       & \verb@dvi2prt@\\
\entry{DVITOPSFIGOPT}       & \verb@ @\\
\entry{DVITOPSCMD}          & \verb@dvips@\\
\entry{DVITOPSOPT}          & \verb@$(FORMATDVIPS) -f@\\
\entry{VIEWDVICMD}          & \verb@xdvi@\\
\entry{VIEWDVIOPT}          & \verb@$(FORMATXDVI)@\\
\entry{VIEWPSCMD}           & \verb@ghostview@\\
\entry{VIEWPSOPT}           & \verb@$(FORMATGHOSTVIEW)@\\
\hline
\entry{TEXDEPENDPATTERN}    & \verb@-e '/\\psfig/ s/^.*figure=\([^,}]*\).*/\1/p' \@\\
                            & \verb@-e '/\\epsffile/ s/.*epsffile *{\([^}]*\)}.*/\1/p' \@\\
                            & \verb@-e '/\\input/ s/.*input *{\([^}]*\.tex\)}.*/\1/p' \@\\
                            & \verb@-e '/\\verbfile/ s/.*verbfile {\([^}]*\.tex\)}.*/\1/p' \@\\
                            & \verb@-e '/\\blackandwhite/ s/.*blackandwhite *{\([^}]*.tex\)}.*/\1/p' \@\\
                            & \verb@-e '/\\input/ s/.*input *{\([^}]*\)}.*/\1.tex/p' \@\\
                            & \verb@-e '/\\include/ s/.*include *{\([^}]*\)}.*/\1.tex/p' \@\\
                            & \verb@-e '/\\verbfile/ s/.*verbfile *{\([^}]*\)}.*/\1.tex/p' \@\\
                            & \verb@-e '/\\blackandwhite/ s/.*blackandwhite *{\([^}]*\)}.*/\1.tex/p'@\\
\hline
\entry{TEXDEFAULTINPUTS}    & {\is} \\
\entry{TEXINPUTS}           & \verb@$(TEXDEFAULTINPUTS)@ \\
\hline
\entry{TEXDRAFT}            & {\ud} \\
\hline
\entry{GIFTOEPS}            & \verb@(giftoppm | ppmtopgm | pnmtops -noturn -rle)@\\
\entry{GIFBWTOEPS}          & \verb@(giftoppm | ppmtopgm | pgmtopbm | pnmtops -noturn -rle)@\\
\entry{FIGTOEPS}            & \verb@(fig2dev -L ps | sed -e 's/setgray fill/setgray eofill/g')@\\
\hline
\entry{FORMATXDVI}          & {\ud} \\
\entry{FORMATDVIPS}         & {\ud} \\
\entry{FORMATGHOSTVIEW}     & {\ud} \\
\hline
\end{tabular}
\end{center}
}




\section{Bugs}\index{Bugs}

\begin{itemize}

\item

\German{Bei der Untersuchung der Quelldatei mit \Command{make
depend}\index{make depend} werden nur solche Unterdateien erkannt, die direkt,
das hei"st, ohne "`Umweg"' "uber ein Makro, mit
\Type{$\backslash$input}\index{input@\Type{input}},
\Type{$\backslash$include}\index{include@\Type{include}},
\Type{$\backslash$verbfile}\index{verbfile@\Type{verbfile}},
\Type{$\backslash$blackandwhite}\index{blackandwhite@\Type{blackandwhite}},
\Type{$\backslash$epsffile}\index{epsffile@\Type{epsffile}} oder
\Type{$\backslash$psfig}\index{psfig@\Type{psfig}} eingelesen werden.}

\English{When examining the source file, \Command{make depend}\index{make
depend} recognises only those input files directly read by
\Type{$\backslash$input}\index{input@\Type{input}},
\Type{$\backslash$include}\index{include@\Type{include}},
\Type{$\backslash$verbfile}\index{verbfile@\Type{verbfile}},
\Type{$\backslash$blackandwhite}\index{blackandwhite@\Type{blackandwhite}},
\Type{$\backslash$epsffile}\index{epsffile@\Type{epsffile}} or
\Type{$\backslash$psfig}\index{psfig@\Type{psfig}} directly, i.\,e. without
using an intermediate macro.}

\item

\German{\Command{make depend} sucht nach den Einleseanweisungen wie
\Type{$\backslash$input}\index{input@\Type{input}} auf String-Basis, ohne den
Kontext zu ber"ucksichtigen. Es kann daher zu
Fehlinterpretationen\index{Fehlinterpretationen} und ungerechtfertigten
Warnungen\index{Warnungen!ungerechtfertigte} kommen.}

\English{When looking for input commands like
\Type{$\backslash$input}\index{input@\Type{input}}, \Command{make depend} does
its job purely string based and without considering the context. Therefore it
may make misinterpretations\index{Misinterpretations} giving you unjustified
warnings\index{Warnings!unjustified}.}

\end{itemize}

\bibliography{Paper}

\printindex

\end{document}
