#! /usr/bin/python
# -*- coding: latin-1 -*-
# $Id$
"""
Copyright (C) 2007 by Martin Thorsen Ranang
"""
__author__ = "Martin Thorsen Ranang <mtr@ranang.org>"
__revision__ = "$Rev$"
__version__ = "1.8.0"

from distutils.core import setup
import os

LONG_DESCRIPTION = """\
A concept indexing and typesetting package for LaTeX.

This package adds functionality to LaTeX that eases typesetting and
indexing of phrases, acronyms, and names in a consistent manner
throughout documents of arbitrary length.
"""


def isPackage(filename):
    return (os.path.isdir(filename) and
            os.path.isfile(os.path.join(filename, '__init__.py')))

def packagesFor(filename, basePackage=""):
    """Find all packages in filename.
    """
    set_of_packages = {}
    
    for item in os.listdir(filename):
        directory = os.path.join(filename, item)
        if isPackage(directory):
            if basePackage:
                moduleName = '%s.%s' % (basePackage, item)
            else:
                moduleName = item
                
            set_of_packages[moduleName] = directory
            set_of_packages.update(packagesFor(directory, moduleName))
            
    return set_of_packages

def main():
    """Module mainline (for standalone execution).
    """
    packages = packagesFor('lib')

    author_name = __author__.split(' <')[0]
    author_email = __author__.rsplit(' ')[-1]

    if True:
        setup(
            name='intex',
            version='1.8.0',
            description='The InTeX Package',
            long_description=LONG_DESCRIPTION,
            license='LPPL',
            author=author_name,
            author_email=author_email,
            url='http://www.ranang.org/projects/intex/',
            package_dir=packages,
            packages=packages.keys(),
            scripts=[
            'src/mkintex',
            ],
            data_files=[
            # TeX-package files:
            ('share/texmf/tex/latex/intex',
             ['latex/intex.sty', 'latex/intex.pdf']),
            # Man pages, section 1:
            ('share/man/man1', ['doc/mkintex.1.gz']),

            ],
            )
        
if __name__ == "__main__":
    main()
