% File:          prosper.sl      -*- mode: SLang -*-
%
% Author:        Guido Gonzato, guido.gonzato@univr.it
%
% Description:   this is a module for latex4jed.
%                
% Installation:  copy prosper.sl to $JED_ROOT/lib/latex, or to your
%                LaTeX_Modules_Dir.
%                
% Version:       1.0.0
%
% Last updated:	 3 May 2003

% -----

custom_variable ("Prosper_Default_Style", "azure");
custom_variable ("Prosper_Default_Options",
                 "pdf,accumulate,slideColor,colorBG," +
                 Prosper_Default_Style);
custom_variable ("Prosper_Default_Transition", "Glitter");

define prosper_template ()
{
  vinsert ("\\documentclass[%s]{prosper}\n", Prosper_Default_Options);
  insert ("\\hypersetup{pdfpagemode=FullScreen}\n\n");
  insert ("\\title{");
  push_spot ();
  insert ("}\n");
  insert ("\\subtitle{}\n");
  insert ("\\author{}\n");
  insert ("\\email{}\n");
  insert ("\\institution{}\n");
  insert ("\\slideCaption{}\n");
  insert ("\\DefaultTransition{Glitter}\n");
  insert ("% \\Logo(1,1){\\includegraphics{logo.eps}}\n");
  insert ("% \\displayVersion\n");
  insert ("% \\NoFrenchBabelItemize\n\n");
  insert ("\\begin{document}\n\n");
  insert ("\\maketitle\n\n");
  insert ("\\begin{slide}[Split]{slide 1 title}\n");
  insert ("  material for slide 1\n");
  insert ("\\end{slide}\n%\n");
  insert ("\\overlays{2}{\n");
  insert ("\\begin{slide}[Box]{Overlay}\n");
  insert ("  overlay, part 1\\\\\n");
  insert ("  \\onlySlide{2}{\n");
  insert ("  overlay, part 2\n");
  insert ("  } % onlySlide\n");
  insert ("\\end{slide}\n");
  insert ("} % overlays\n");
  insert ("\\overlays{3}{\n");
  insert ("\\begin{slide}[Wipe]{Overlay + itemstep}\n");
  insert ("  \\begin{itemstep}\n");
  insert ("    \\item one\n");
  insert ("    \\item two\n");
  insert ("    \\item three\n");
  insert ("  \\end{itemstep}\n");
  insert ("\\end{slide}\n");
  insert ("} % overlays\n\n");
  insert ("\\end{document}");
  pop_spot ();
  LaTeX_Default_Output = "dvipdf";
}

% -----

define prosper_choose_option ()
{
  variable option =
     read_with_completion ("draft,final,slideColor,slideBW,total," +
                           "nototal,novolorBG,colorBG,ps,pdf," +
                           "accumulate,noaccumulate,distiller",
                           "Choose transition (pres TAB to list):",
                           "", "", 's');
  insert (option + ",");
}

% -----

define prosper_choose_style ()
{
  variable style =
     read_with_completion ("alienglow,autumn,azure,blends,contemporain," +
                           "darkblue,default,frames,lignesbleues," + 
                           "nuancegris,troispoints",
                           "Choose style (pres TAB to list):",
                           "", "", 's');
  insert (style);
}

% -----

define prosper_choose_transition ()
{
  Prosper_Default_Transition =
    read_with_completion ("Split,Blinds,Box,Wipe,Dissolve,Glitter,Replace",
                          "Choose transition (pres TAB to list):",
                          Prosper_Default_Transition, "", 's');
  insert (Prosper_Default_Transition);
}

% -----

define prosper_overlays ()
{
  insert ("\\overlays{");
  push_spot ();
  insert ("}{\n");
  latex_begin_end ("slide",
                   sprintf ("[%s]{}", Prosper_Default_Transition),
                   0, 0);
  insert ("\n}\n");
  pop_spot ();
}

% -----

$1 = "LaTeX-Mode";
$2 = "Global.M&ode.Mod&ules.prosper";

% reserved keys
definekey_reserved ("prosper_template", "to", $1);
definekey_reserved ("prosper_template", "^T^O", $1);
% menu
menu_append_item ($2, "&Template", "prosper_template");
menu_append_item ($2, "Choose &Class Option", "prosper_choose_option");
menu_append_item ($2, "Choose Class St&yle", "prosper_choose_style");
menu_append_item ($2, "Choose T&ransition", "prosper_choose_transition");
menu_append_item ($2, "&Part", sprintf ("latex_cmd (\"part[%s]\", 1)",
                                        Prosper_Default_Transition));
menu_append_item ($2, "&Slide", sprintf
                  ("latex_begin_end (\"slide\", \"[%s]{title}\", 1, 1)",
                   Prosper_Default_Transition));
menu_append_item ($2, "&Overlays", "prosper_overlays");
menu_append_item ($2, "&Itemize",
                  "latex_begin_end (\"Itemize\", \"\", 1, 1)");
menu_append_item ($2, "item&step",
                  "latex_begin_end (\"itemstep\", \"\", 1, 1)");
% slide macros
menu_append_popup ($2, "Slide &Macros");
$3 = sprintf ("%s.Slide &Macros", $2);
menu_append_item ($3, "\\FontTitle{C}{BW}",
                  "latex_cmd_with_arg (\"FontTitle\", \"\")");
menu_append_item ($3, "\\FontText{C}{BW}",
                  "latex_cmd_with_arg (\"FontText\", \"\")");
menu_append_item ($3, "\\fontTitle{}",
                  "latex_cmd (\"fontTitle\", 1)");
menu_append_item ($3, "\\fontText{}",
                  "latex_cmd (\"fontText\", 1)");
menu_append_item ($3, "\\ColorFoot{}",
                  "latex_cmd (\"ColorFoot\", 1)");
menu_append_item ($3, "\\PDFtransition{}",
                  "latex_cmd (\"PDFtransition\", 1)");
menu_append_item ($3, "\\myitem{lev}{def}",
                  "latex_cmd_with_arg (\"myitem\", \"\")");
% overlays macros
menu_append_popup ($2, "O&verlays Macros");
$3 = sprintf ("%s.O&verlays Macros", $2);
menu_append_item ($3, "\\fromSlide{p}{mat}",
                  "latex_cmd_with_arg (\"fromSlide\", \"\")");
menu_append_item ($3, "\\onlySlide{p}{mat}",
                  "latex_cmd_with_arg (\"fromSlide\", \"\")");
menu_append_item ($3, "\\untilSlide{p}{mat}",
                  "latex_cmd_with_arg (\"untilSlide\", \"\")");
menu_append_item ($3, "\\FromSlide{p}",
                  "latex_cmd (\"FromSlide\", 1)");
menu_append_item ($3, "\\OnlySlide{p}",
                  "latex_cmd (\"OnlySlide\", 1)");
menu_append_item ($3, "\\UntilSlide{p}",
                  "latex_cmd (\"UntilSlide\", 1)");
% output dependent macros
menu_append_popup ($2, "P&DF/PS Macros");
$3 = sprintf ("%s.P&DF/PS Macros", $2);
menu_append_item ($3, "\\PDForPS{ifpdf}{ifps}",
                  "latex_cmd_with_arg (\"PDForPS\", \"\")");
menu_append_item ($3, "\\onlyInPS{}",
                  "latex_cmd (\"onlyInPS\", 1)");
menu_append_item ($3, "\\onlyInPDF{}",
                  "latex_cmd (\"onlyInPDF\", 1)");

% ----- End of file prosper.sl
