package com.dickimawbooks.jmakepdfx;

public class ConvertThread extends Thread
{
   public ConvertThread(Jmakepdfx application)
   {
      super();
      app = application;
   }

   public void run()
   {
      try
      {
         app.setWaitCursor();
         app.disableTools();

         if (app.toPdfX())
         {
            app.viewPDF(app.getOutputName());
         }
      }
      catch (Exception e)
      {
         app.setInfo(app.getLabel("message.failed"));
         app.error(e);
      }
      finally
      {
         app.enableTools();
         app.workerThreadFinished(this);
         app.setDefaultCursor();
      }
   }

   private Jmakepdfx app;
}
