/* GNU TalkFilters - common command line parsing code
   Copyright (C) 1998 Free Software Foundation, Inc.

   This file is part of GNU Talkfilters

   GNU Talkfilters is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Talkfilters is distributed in the hope that it will be amusing,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Talkfilters; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>

#include "getopt.h"

#define HELP_OPTION 0
#define VERSION_OPTION 1

static const struct option options[] = { { "help", 0, NULL, 0  },
                                          { "version", 0, NULL, 0 },
                                          { NULL, 0, NULL, 0 } };

void parse_args(int argc, char **argv, char *help, char *version)
{
   int c, option_index;

   while((c = getopt_long(argc, argv, "", options, &option_index)) != EOF)
   {
      switch(c)
      {
      case 0:
         if(option_index == HELP_OPTION)
            fprintf(stderr, help, *argv);
         else if(option_index == VERSION_OPTION)
         {
            fputs(version, stderr);
            fputc('\n', stderr);
         }
         exit(EXIT_SUCCESS);
         break;

       default:
         fprintf(stderr, help, *argv);
         exit(EXIT_FAILURE);
         break;
      }
   }
}
