/*
 * $Id: main.c,v 1.4 1997/10/01 19:00:00 D.Taupin Exp $
 * History:
 * $Log: main.c,v $
 * Revision 1.4  1997/10/01   D. Taupin
 * Corrected some bugs and added \OE, \oe, Umlauts, cedillas
 *
 * Revision 1.3  1994/06/21  08:14:11  ralf
 * Corrected some bugs
 *
 * Revision 1.2  1994/06/17  14:19:41  ralf
 * Corrected various bugs, for example interactive read of arguments
 *
 * Revision 1.1  1994/06/17  11:26:29  ralf
 * Initial revision
 */
/***************************************************************************
     name : main.c
   author : DORNER Fernando, GRANZER Andreas + TAUPIN Daniel
  purpose : main convert-routine from LaTex2Rtf/ltx2rtf
 *****************************************************************************/


/****************************** includes *************************************/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "main.h"
#include "commands.h"
#include "funct1.h"
#include "fonts.h"
#include "stack.h"
#include "funct2.h"
#include "direct.h"
#include "ignore.h"
#include "version.h"
/****************************************************************************/


/********************************* global variables *************************/
FILE *fTex = stdin;		/* file pointer to Latex file */
FILE *fRtf = NULL;		/* file pointer to RTF file */
FILE *fStd = stdout;		/* file pointer to LOG file */
FILE *fMathTeX = NULL;          /* Maths-LaTex-File-Pointer */
FILE *fUtil = NULL;             /* Utility File-Pointer */
FILE *fPbm = NULL;		/* file pointer to input PBM file */
FILE *fDat = NULL;		/* file pointer to LaTeX output data */
BOOL StdToScreen = TRUE;        /* NO need to duplicate error messages */
char *progname;			/* name of the executable file */
char *latexname= "stdin";	/* name of LaTex-File */
fpos_t pos_begin_kill;
char InitialDir[128] = {'\0'};  /* save initial directory */

BOOL AutoNumSections = FALSE;/* DT */
BOOL AutoNumItems = FALSE;   /* DT */
BOOL Code850 = FALSE;   /* DT */
BOOL CodeISO = FALSE;   /* DT */
BOOL Debug = FALSE;
int iEnvCount = 0;           /* DT */
char *emtexdir = NULL;
BOOL MakeEquationsTeX = FALSE;
BOOL MakeMathsTeX = FALSE;
int NumberColumns = 1;
int ColSep = 360; /* columns separation in TWIPS */

int paperwidth = 12240;
int paperheight = 15840;
int textwidth =  12240;
int textheight =  12240;
int hoffset = 0;
int voffset = 0;

/****************************************************************************/
/*** function prototypes ***/
BOOL PrepareTex(char *filename, FILE **f);  /* opens file for reading */
BOOL PrepareStdout(char *filename, FILE **f);  /* opens file for std output */
BOOL PrepareRtf(char * filename, FILE **f); /* creates file and writes */
        				   /* RTF header */
BOOL OpenMathTeX(char *filename, FILE **f);  /* opens file for TeX maths */

BOOL CloseTex(FILE **f);
BOOL CloseRtf(FILE **f);
BOOL CloseMath(FILE **f);

BOOL TranslateCommand();  /* converts commands */
BOOL TranslateSpecKey();  /* converts special keys */
void *GetCommandFunc(char *cCommand);
void numerror(int num);
void errorchar(char text);
void OutputError(char *text);
void Message(char *text);
BOOL ConvertFormula(char * command);
/****************************************************************************/
int main(int argc, char **argv)
/****************************************************************************
purpose: checks parameter and starts convert routine
params:  command line arguments argc, argv
globals: initializes in- and output-file fTex, fRtf
 ****************************************************************************/
{

  int c, errflag = 0;
  int zz = 0;
  char *input = NULL;
  char *output = NULL;
  char *ttt = NULL;
  char def_out[PATHMAX] = {"\0"};
  char errormessage[256] = "";
  extern int getopt(int, char **, char *);
  extern char *optarg;
  extern int optind, opterr;


  PushEnvironment(HEADER);
  PushEnvironment(DOCUMENT);
  progname=argv[0];

  printf("%s:\n %s", progname, Version);

  SaveInitialDir();
  
  emtexdir = getenv("EMTEXDIR");
  if (emtexdir != NULL) fprintf(fStd,"\nFound EMTEXDIR=%s",emtexdir);

  while((c = getopt(argc, argv, "PIVDMmC:o:")) != EOF)
  {
    switch(c)
    {
      case 'o':
        output = optarg;
        break;
/* new options DT */	
      case 'D':
        Debug = TRUE;
        break;
      case 'P':
        AutoNumSections = TRUE;
        break;
      case 'I':
        AutoNumItems = TRUE;
        break;
      case 'm':
        MakeEquationsTeX = TRUE;
        break;
      case 'M':
        MakeEquationsTeX = TRUE;
        MakeMathsTeX = TRUE;
        break;
      case 'C':
        if (strcmp(optarg,"850") == 0)
        {
          Code850 = TRUE;
          fprintf(fStd, "\nConverting Code Page=%s",optarg);
        }
        else if (strcmp(optarg,"ISO") == 0)
        {
          CodeISO = TRUE;
          fprintf(fStd, "\nConverting Code Page=%s",optarg);
        }
        else
        {
            sprintf(errormessage,"Code Page %s not accepted.",optarg);
            warning(errormessage);
       	};
        break;
/* end new options DT */	
      default:
        errflag = 1;
    }
  }
  if(argc > optind + 1 || errflag)
  {
    sprintf(errormessage,"Usage: %s [-o outfile -C codepage] inputfile",
      progname);
    OutputError(errormessage);      
    return(1);
  }
  if(argc == optind + 1)
  {
    input = argv[optind];
    latexname = input;
    if (strlen(latexname) > PATHMAX-1) {error("LaTeX name too long!");};
    strcpy(def_out,latexname);
    ttt = strrchr(def_out,'.');
    ttt[0] = '\0';
    strcat(def_out,".rtf");
    if (strlen(latexname) > PATHMAX-1) {error("LaTeX name too long!");};
  };

  if (output == NULL)
  {output = def_out; sprintf(errormessage,"Output taken from LaTeX name: %s",
    output); OutputError(errormessage);
  }

  GetConfigs();
  CmdPaper(0); /* initialize paper sizes to A4 */
  PrepareTex(input,&fTex);
  PrepareRtf(output,&fRtf);
/*  WriteFontHeader(fRtf); */ /* moved to funct1.c documentstyle DT */
  Push(1,0);
  /* Convert(fTex, fRtf); */
  Convert();
  /* For vi {{{{{ */
  fprintf(fRtf,"}}}}}");
  CloseTex(&fTex);
  CloseRtf(&fRtf);
  RemoveFontlist();
  sprintf(errormessage,"Final iEnvCount=%d",iEnvCount);
  Message(errormessage);
  sprintf(errormessage,"Convert successfull");
  OutputError(errormessage);

/*  sprintf(errormessage,"del %s\\*.pbm",getenv("TMPDIR"));
  system(errormessage);
  Message(errormessage); */
  
  return(0);
}


/****************************************************************************/
/* Global Flags for Convert Routine */
/****************************************************************************/
BOOL AcceptInputText = TRUE;
int RecursLevel = 0;
int BracketLevel = 1;
int ret = 0;
BOOL mbox = FALSE;
BOOL MathMode[MAXENVIRONS] = {FALSE};
BOOL bNewPar = FALSE;
int indent = 0;
int right_indent = 0;
int left_item_indent = 240;  /* DT */
int indent_quantum = 512;    /* DT */
int enum_level =0;           /* DT */
BOOL ParDone = FALSE;
int ConvertFlag;
BOOL bPard = TRUE;
BOOL bInDocument = FALSE;
int tabcounter = 0;
int fontsize = 20;
int curr_fontsize[MAXENVIRONS] = {20};
int curr_fontbold[MAXENVIRONS] = {0};
int curr_fontital[MAXENVIRONS] = {0};
int curr_fontscap[MAXENVIRONS] = {0};
int curr_fontnumb[MAXENVIRONS] = {0};
int environ_type[MAXENVIRONS] = {0};
int environ_mode[MAXENVIRONS] = {0};
BOOL twocolumn = FALSE;
BOOL titlepage = FALSE;
BOOL article = FALSE;
BOOL report = FALSE;
BOOL book = FALSE;
BOOL TABBING_ON = FALSE;
BOOL TABBING_RETURN = FALSE;
BOOL TABBING_ON_itself = FALSE;
BOOL TITLE_AUTHOR_ON = FALSE;
BOOL IgnoreSpaces = FALSE;
BOOL GermanMode = FALSE;  /* switches support for germanstyle on or off */
/* the Germand Mode supports most of the commands defined in GERMAN.STY file
   by H.Partl(TU Wien) 87-06-17 */

char alignment[MAXENVIRONS] = {JUSTIFIED};	/* default for justified: */
int parindent[MAXENVIRONS] = {360};	/* default is zero ??? */
int DefaultIndent = 360;    /* DT */
int section_style[SECT_MAXLEVEL] = {0};
int section_fontsize[SECT_MAXLEVEL] = {20};
int section_sb[SECT_MAXLEVEL] = {240};  /* space before section titles */
int section_sa[SECT_MAXLEVEL] = {60};  /* space before section titles */
int title_fontsize = 20;
int author_fontsize = 20;
char section_fontdesc[100][SECT_MAXLEVEL] = {'\0'};
char TheFont[MAXPNLEN] = "";
int TabularColumn = 0;
char CellJustif[MAXCELLS]={' '}; /* DT */
int FutureSkip = 0;   /* DT stores the medskip, smallskip, bigskip requested */
BOOL NextIndent = TRUE;   /* DT shall next paragraph be indented */
BOOL InputLineEmpty = TRUE;  /* DT */
int EqNumber = 0; /* DT */
char LaTeXingCommand[256] = "";
char PBMingCommand[256] = "";
char TeXoutputName[64]="/tmp/eqn-xxx.tmp";
char TeXoutputLog[64]="/tmp/eqn-xxx.log";
char TeXoutputAux[64]="/tmp/eqn-xxx.aux";
char TeXoutputNone[64]="eqn-xxx";
char TeXoutput[64]="/tmp/eqn-xxx";
char PBMname[64]="/tmp/eqn-xxx.pbm";
char UsePackageText[256]="";

   
long linenumber=1;		       /* counts lines in the LaTex-document */
int pbm_linelength=0;                  /* line length in pbm file read */ 
int pbm_linenumber=0;                  /* number of lines in pbm file read */

char PointSize[10] = "10pt";
char normalsize[20] = "\\normalsize";
char *LatexSize[MAXENVIRONS] = {normalsize};

char Error_Msg_Text[256] = {'\0'};

/****************************************************************************/
BOOL Convert()
/****************************************************************************
purpose: converts inputfile and writes result to outputfile
globals: fTex, fRtf and all global flags for convert (see above)
 ****************************************************************************/
{
  char errormessage[256];
  char exponent[1000];
  char cLastNoSpace = 'a';
  int PopLevel=0,PopBrack,PPopLevel,PPopBrack,size,retlevel;
  int count = 0;
  int i,kchar;
  float FloatFsize = fontsize;
  char cThishilf;
  char cThis = '\n';
  char cLast = '\n';
  char cLast2 = '\n';

  RecursLevel++;
  Push(RecursLevel,BracketLevel);
  ++ConvertFlag;
  while ((fread(&cThis, 1,1,fTex) == 1) && AcceptInputText)
  {
    if (cThis == '\n') linenumber++;
    if (cThis == '\t') cThis = ' ';  /* tabulation = space */
    if ( (cThis != ' ') && (cThis != '\n') && (cThis != '%') ) IgnoreSpaces = FALSE; /* DT */
    if ( (cThis != ' ') && (cThis != '\n') ) InputLineEmpty = FALSE;

/* insert math-ign.c */      
    
    switch(cThis)
    {
    case '\\':{
              fpos_t pos1,pos2;
              fgetpos(fRtf,&pos1);
              Push(RecursLevel,BracketLevel);
              TranslateCommand();

              /*if ((TABBING_ON_itself) ||
        	  ((TABBING_ON) &&
        	  (TABBING_RETURN)))
        	  {
        	  TABBING_RETURN = FALSE;
        	  if (TABBING_ON_itself)
        	     TABBING_ON = FALSE;
        	  TABBING_ON_itself = FALSE;
        	  return TRUE;
        	  } */

              /* erase double identic values on stack top */
              for(;;)
              {
        	if ((size = Pop(&PPopLevel, &PPopBrack)) <= 0 )
        	{
        	  Push(PPopLevel,PPopBrack);
        	  break;
        	}
        	if ((size = Pop(&PopLevel, &PopBrack)) <= 0 )
        	{
        	  Push(PopLevel,PopBrack);
        	  break;
        	}
        	if ( (PPopLevel == PopLevel) && (PPopBrack == PopBrack) )
        	{
        	  Push(PopLevel,PopBrack);
        	}
        	else
        	{
        	  Push(PopLevel,PopBrack);
        	  Push(PPopLevel,PPopBrack);
        	  break;
        	}
              };

              if (ret > 0)
              {
        	--ret;
        	--RecursLevel;
        	return TRUE;
              }

              cThis = '\\';
              fgetpos(fRtf,&pos2);
              if (pos1 == pos2)    /* no RTF output */
              {
        	if (cLast == '\n')
        	  cThis = '\n';
        	else
        	  cThis = ' ';
              }
              break;
              }
    case '%': IgnoreTo('\n');
              if (IgnoreSpaces)
                {cThis = '\4';} else {cThis = ' ';};   /* Test 22 mai */
              break;
    case '&': TabulationChar();
              break;
    case '{':
              Push(RecursLevel,BracketLevel);
              ++BracketLevel;
              PushEnvironment(GROUP);
              break;
    case '}':
              PopEnvironment(GROUP);
              BracketLevel--;
              PPopLevel = RecursLevel;
              PPopBrack = BracketLevel;
              size = Pop(&PopLevel, &PopBrack);
              while ( (size = Pop(&PopLevel, &PopBrack)) >= 0 )
              {
        	if ( PopBrack < BracketLevel )
        	{
        	  break;
        	}
        	PPopLevel = PopLevel;
        	PPopBrack = PopBrack;
              } /* while */
              Push(PopLevel,PopBrack);	/* push back */
              retlevel = PPopLevel;
              ret = RecursLevel-retlevel;
              Push(retlevel,BracketLevel);

              if (ret > 0)
              {
        	ret--;
        	RecursLevel--;
        	return TRUE;
              }
              else
        	break;
    case '\r':sprintf(errormessage,"error in input file: %s at linenumber: %ld",latexname,linenumber);
              error(errormessage);
              exit(-1);
              break;
    case ' ': if (!bInDocument) continue;
              /* DT */
              if ( (cLast != ' ') && (cLast != '\n') &&
                (IgnoreSpaces == FALSE) )
              {
        	if (mbox == FALSE)
               /*   if (bNewPar == FALSE)*/
        	    fprintf(fRtf," ");
        	else
        	  fprintf(fRtf,"\\~");
              };
              break;
    case '~': if (!bInDocument) numerror(ERR_WRONG_COMMAND);
              fprintf(fRtf,"\\~");
              break;
    case '\n':
              tabcounter=0;


              if (InputLineEmpty)
              {
              	 CmdPar(0);
              }else if (!IgnoreSpaces)
              {
        	  if(bInDocument) fprintf(fRtf," ");	 /* treat as 1 space */
              };
              InputLineEmpty = TRUE;
              break;
    case '^': if (!bInDocument) numerror(ERR_WRONG_COMMAND);
/*              CmdExponent(EXPONENT); */
              PushEnvironment(EXPONENT);
                fprintf(fRtf,"\\up6 ");
                CmdSetFont(F_ROMAN);
                if(curr_fontsize[iEnvCount] > 14)
                  { FloatFsize = 0.75*curr_fontsize[iEnvCount];
                    curr_fontsize[iEnvCount] = FloatFsize;
                  };
                fprintf(fRtf,"\\fs%d ",curr_fontsize[iEnvCount]);
                GetParam(exponent,999);
                      
                Push(RecursLevel,BracketLevel);
                  ConvertString(exponent);
/*                Convert(); */
/*                fprintf(fRtf,"}"); */
              PopEnvironment(EXPONENT);
              if (ret > 0)
              {
        	--ret;
        	--RecursLevel;
        	return TRUE;
              }
              break;
    case '_': if (!bInDocument) numerror(ERR_WRONG_COMMAND);
/*              CmdExponent(SUBSCRIPT); */
              PushEnvironment(SUBSCRIPT);
                fprintf(fRtf,"\\dn6 ");
                CmdSetFont(F_ROMAN);
                if(curr_fontsize[iEnvCount] > 14)
                  { FloatFsize = 0.75*curr_fontsize[iEnvCount];
                    curr_fontsize[iEnvCount] = FloatFsize;
                  };
                fprintf(fRtf,"\\fs%d ",curr_fontsize[iEnvCount]);
                GetParam(exponent,999);
                if (Debug) fprintf(OUTPUTF,"\nsubscript=|%s|",exponent);
                      
                Push(RecursLevel,BracketLevel);
                  ConvertString(exponent);
              PopEnvironment(SUBSCRIPT);
              if (ret > 0)
              {
        	--ret;
        	--RecursLevel;
        	return TRUE;
              }
              break;
    case '$': count++;
               while ((fread(&cThishilf,1,1,fTex) >= 1) && (cThishilf == '$'))
        	   count++;
               switch (count)
               {
        	 case 1: CmdFormula(FORM_DOLLAR);
        		 break;
        	 case 2: CmdFormula(FORM_DISPLAY);
        		 break;
        	 default:
        	         sprintf(errormessage,
                         "More than two consecutive $ at line %d",linenumber);
                         error(errormessage);
               }
               fseek(fTex,-1L,SEEK_CUR); /* reread last character */
               count = 0;

              break;
    case '-' : count++;
               DoBeginparagraph();
               while ((fread(&cThishilf,1,1,fTex) >= 1) && (cThishilf == '-'))
        	   count++;
               switch (count)
               {
        	 case 1: fprintf(fRtf,"-");
        		 break;
        	 case 2: fprintf(fRtf,"\\endash ");
        		 break;
        	 case 3: fprintf(fRtf,"\\emdash ");
        		 break;
        	 default:
        	 { for (i = count-1; i >= 0; i--)
        	   fprintf(fRtf,"-");
        	 }
               }
               fseek(fTex,-1L,SEEK_CUR); /* reread last character */
               count = 0;
        	break;
    case '<' : count++;
               DoBeginparagraph();   	
               while ((fread(&cThishilf,1,1,fTex) >= 1) && (cThishilf == '<'))
        	   count++;
               switch (count)
               {
        	 case 1: fprintf(fRtf,"<");
        		 break;
        	 case 2: fprintf(fRtf,"\\ldblquote ");
        		 break;
        	 default:
        	 { for (i = count-1; i >= 0; i--)
        	   fprintf(fRtf,"<");
        	 }
               }
               fseek(fTex,-1L,SEEK_CUR); /* reread last character */
               count = 0;
        	break;
    case '>' : count++;
               DoBeginparagraph();   	
               while ((fread(&cThishilf,1,1,fTex) == 1) && (cThishilf == '>'))
        	   count++;

               switch (count)
               {
        	 case 1: fprintf(fRtf,">");
        		 break;
        	 case 2: fprintf(fRtf,"\\rdblquote ");
        		 break;
        	 default:
        	 { for (i = count-1; i >= 0; i--)
        	   fprintf(fRtf,">");
        	 }
               }
               fseek(fTex,-1L,SEEK_CUR); /* reread last character */
               count = 0;
        	break;
    case '\4' : break;		
    case '\'' : count++;
               DoBeginparagraph();   	
               while ((fread(&cThishilf,1,1,fTex) >= 1) && (cThishilf == '\''))
        	   count++;
               if (count != 2)
        	 { for (i = count-1; i >= 0; i--)
        	   fprintf(fRtf,"\\rquote ");
        	 }
               else
/*        	   fprintf(fRtf,"\\rdblquote ");  */
        	   fprintf(fRtf,"\\'94");
               fseek(fTex,-1L,SEEK_CUR); /* reread last character */
               count = 0;
               break;
    case '`' : count++;
               DoBeginparagraph();   	
               while ((fread(&cThishilf,1,1,fTex) >= 1) && (cThishilf == '`'))
        	   count++;
               if (count != 2)
        	 { for (i = count-1; i >= 0; i--)
        	   fprintf(fRtf,"\\lquote ");
        	 }
               else
/*        	   fprintf(fRtf,"\\ldblquote ");    */
        	   fprintf(fRtf,"\\'93");
               fseek(fTex,-1L,SEEK_CUR); /* reread last character */
               count = 0;
               break;
    case '\"':
               DoBeginparagraph();   	
               if (GermanMode)
        	 TranslateGerman();
               else
        	 fprintf(fRtf,"\"");
               break;
    case '\t': break;
             
    default:
             kchar = cThis;
             if (Code850 && (kchar >= 128))
             {
                if (Debug) fprintf (OUTPUTF,"\nkchar=%d, cThis='%c'",kchar,cThis);
                switch(cThis)
                {
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'c9");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'e9");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'c2");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'ca");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'ce");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'d4");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'db");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'e2");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'ea");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'ee");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'f4");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'fb");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'c7");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'e7");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'c0");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'c8");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'d9");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'e0");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'e8");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'f9");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'c4");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'cb");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'cf");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'d6");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'dc");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'e4");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'eb");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'ef");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'f6");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'fc");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'ff");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'df");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'e5");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'c5");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'d8");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'f8");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'f2");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'d2");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'ec");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'cc");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'e6");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'c6");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'e1");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'c1");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'ed");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'cd");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'f3");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'d3");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'be");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'bd");
        	              break;
                    case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'da");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'fa");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\'a7");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf, "\\ldblquote ");
                              break;
                   case '' : DoBeginparagraph();
        	              fprintf(fRtf,"\\rdblquote ");
                              break;
                   default: errorchar(cThis);           
                }
                break;
             } else if (CodeISO && (kchar >= 128))
             { if (kchar >= 196)
                { DoBeginparagraph();
                  fprintf(fRtf, "\\'%2x", cThis); 
                } else
                { errorchar(cThis);
                };
                break;
             } else if (kchar >= 128)
             {
               errorchar(cThis);           
             };
	
             if (bInDocument)
             {
               DoBeginparagraph();   	
/*              if ((isupper(cThis)) &&
        	 ((cLast=='.') || (cLast=='!') || (cLast=='?') || (cLast==':')))
                 fprintf(fRtf," ");  */
               if (isalpha(cThis) && MathMode[iEnvCount])
                {fprintf(fRtf,"{\\i %c}",cThis);}
               else
                {fprintf(fRtf,"%c",cThis);};
               bNewPar = FALSE;
               ParDone = FALSE;  /* DT */
             }
          break;
    }

  tabcounter++;
  cLast2 = cLast;
  cLast = cThis;
  if (cThis != ' ')
    cLastNoSpace = cThis;
  }
  RecursLevel--;
  return TRUE;
}


/****************************************************************************/
void errorchar(char text)
/****************************************************************************
purpose: writes character error message
 ****************************************************************************/
{
  char thebadchar[5] = "";
  char errmsg[128] = "";

  thebadchar[0] = text;
  thebadchar[1] = '\0';
  sprintf(errmsg,"Unsupported input character %s at line %d",thebadchar,linenumber);
  warning(errmsg);	
}


/****************************************************************************/
void Message(char *text)
/****************************************************************************
purpose: writes message on stdout
 ****************************************************************************/
{
  fprintf(fStd,"\n%s",text);  	
}

/****************************************************************************/
void OutputError(char *text)
/****************************************************************************
purpose: writes error or diagnostic message on both stderr and stdout
 ****************************************************************************/
{
  if (!StdToScreen)
  {
    fprintf(stderr,"\n%s",text);  	
  };
  fprintf(fStd,"\n%s",text);  	
}

/****************************************************************************/
void error(char * text)
/****************************************************************************
purpose: writes error message
globals: reads progname;
 ****************************************************************************/
{
  char errormessage[256] = "";
  sprintf(errormessage,"%s: ERROR: %s",progname,text);
  OutputError(errormessage);  	
  OutputError("Program aborted\n");
  exit(-1);
}
/****************************************************************************/
void Error(char * text)
/****************************************************************************
purpose: writes error message without progname
 ****************************************************************************/
{
  char errormessage[256] = "";
  sprintf(errormessage,"ERROR: %s",text);
  OutputError(errormessage);  	
  OutputError("Program aborted\n");
  exit(-1);
}
/****************************************************************************/
void warning(char * text)
/****************************************************************************
purpose: writes diagnostic message
 ****************************************************************************/
{
  char errormessage[256] = "";
  sprintf(errormessage,"WARNING: %s",text);
  OutputError(errormessage);  	
}

/****************************************************************************/
void numerror(int num)
/****************************************************************************
purpose: writes error message identified by number - for messages on many
         places in code. Calls function error.
globals: reads progname;
 ****************************************************************************/
{

  char text[1024];

  switch(num)
  {
    case ERR_EOF_INPUT:
      sprintf(text,"%s%s%s%ld%s","unexpected end of input file in: ",latexname," at linenumber: ",linenumber,"\n");
      error(text);
      break;
    case ERR_WRONG_COMMAND:
      sprintf(text,"%s%s%s%ld%s","unexpected command or character in: ",latexname," at linenumber: ",linenumber,"\n");
      error(text);
      break;
    case ERR_Param:
      error("wrong number of parameters\n");
      break;
    case ERR_WRONG_COMMAND_IN_TABBING:
      sprintf(text,"%s%s%s%ld%s","wrong command in Tabbing-kill-command-line in: ",latexname," at linenumber: ",linenumber,"\n");
      error(text);
      break;
    default :
      error("internal error");
      break;
  }
}


/****************************************************************************/
BOOL PrepareRtf(char *filename, FILE **f)  /* creates file */
/****************************************************************************
purpose: creates output file.
params: filename - name of outputfile
        f - pointer to filepointer to store file ID
 ****************************************************************************/
{
  if(filename != NULL)
  {
      if ((*f = fopen(filename,"wb")) == NULL)	 /* open file */
      {
      	sprintf(Error_Msg_Text,"Error opening RTF-file %s",filename);
        error(Error_Msg_Text);
        exit(1);
      }
  };
  return TRUE;
 }

/****************************************************************************/
BOOL OpenMathTeX(char *filename, FILE **f)  /* creates file */
/****************************************************************************
purpose: creates output file for Maths TeX
params: filename - name of outputfile
        f - pointer to filepointer to store file ID
 ****************************************************************************/
{
  if(filename != NULL)
  {
      if ((*f = fopen(filename,"wb")) == NULL)	 /* open file */
      {
      	sprintf(Error_Msg_Text,"Error opening Math-TeX-file %s",filename);
        error(Error_Msg_Text);
        exit(1);
      }
  };
  return TRUE;
 }

/****************************************************************************/
BOOL PrepareStdout(char *filename, FILE **f)  /* creates file */
/****************************************************************************
purpose: creates standard output file.
params: filename - name of outputfile
        f - pointer to filepointer to store file ID
 ****************************************************************************/
{
  if(filename != NULL)
  {
      if ((*f = fopen(filename,"wb")) == NULL)	 /* open file */
      {
      	sprintf(Error_Msg_Text,"Error opening Output file %s",filename);
        error(Error_Msg_Text);
        exit(1);
      }
  };
  return TRUE;
 }

/****************************************************************************/
BOOL PrepareTex(char *filename, FILE **f)  /* opens file for reading */
/****************************************************************************
purpose: opens input file.
params: filename - name of inputfile
        f - pointer to filepointer to store file ID
 ****************************************************************************/
 
{
  if(filename != NULL)
  {
      if ((*f = fopen(filename,"r")) == NULL)	/* open file */
      { 
      	sprintf(Error_Msg_Text,"Error opening LATEX-file %s",filename);
        error(Error_Msg_Text);
/*	error("Error opening LATEX-file"); */
        exit(1);
      }
  }
  return TRUE;
}


/****************************************************************************/
BOOL CloseTex(FILE **f)
/****************************************************************************
purpose: closes input file.
params: f - pointer to filepointer to invalidate
 ****************************************************************************/
{
  if(*f != stdin)
      fclose(*f);
  *f = NULL;
  return TRUE;
}


/****************************************************************************/
BOOL CloseMath(FILE **f)
/****************************************************************************
purpose: closes output file.
params: f - pointer to filepointer to invalidate
 ****************************************************************************/
{
  fprintf(*f,"\n");
  if(*f != NULL)
  {
      if(fclose(*f) == EOF)
      {
        warning("error closing Math-TeX-File");
      }
  }
  *f = NULL;
  return TRUE;
}

/****************************************************************************/
BOOL CloseRtf(FILE **f)
/****************************************************************************
purpose: closes output file.
params: f - pointer to filepointer to invalidate
 ****************************************************************************/
{
  fprintf(*f,"}\n");
  if(*f != stdout)
  {
      if(fclose(*f) == EOF)
      {
        warning("error closing RTF-File");
      }
  }
  *f = NULL;
  return TRUE;
}


/****************************************************************************/
BOOL TranslateCommand()
/****************************************************************************
purpose: The function is called on a backslash in input file and
         tries to call the command-function for the following command.
returns: success or not
globals: fTex, fRtf, command-functions have side effects or recursive calls
 ****************************************************************************/
{
  char errormessage[256] = "";	
  char cCommand[MAXCOMMANDLEN] = {'\0'};
  int i;
  BOOL ParToMakeAfter = FALSE;
  
  char cThis;
  
  for (i = 0; ;i++)   /* get command from input stream */
  {
    if (fread(&cThis,1,1,fTex) < 1)
       break;
    if (cThis == '\n')  linenumber++;
    if (i == 0) /* test for special characters */
    {
      switch(cThis)
      {
        case '}': fprintf(fRtf,"\\}"); return TRUE;
        case '{': fprintf(fRtf,"\\{"); return TRUE;
        case '#': fprintf(fRtf,"#"); return TRUE;
        case '$': fprintf(fRtf,"$"); return TRUE;
        case '&': fprintf(fRtf,"&"); return TRUE;
        case '%': fprintf(fRtf,"%%"); return TRUE;
        case '_': fprintf(fRtf,"_"); return TRUE;
        case '\\':    /* produces a newline in output */
        	      /*	  no new paragraph    */
        	  if (fread(&cThis,1,1,fTex) < 1)
        	      cThis='a';

        	  if ((cThis == ' ') ||
        	      (cThis == '*'))  /* ignore * after \\ -> it's the same command as \\ */
        	    {
        	    if (fread(&cThis,1,1,fTex) < 1)
        	      cThis='a';
        	    while(cThis == ' ') 		   /*space  ignore */
        	       if (fread(&cThis,1,1,fTex) != 1)
        		  break;
        	    fseek(fTex,-1,SEEK_CUR);
        	    }
        	  else
        	    {
        	    fseek(fTex,-1,SEEK_CUR);
        	    }

        	  if (environ_type[iEnvCount] == TABULAR)
        	  {
        	    TabularDbleSlash();
        	  }else
        	  {
                    fprintf(fRtf,"\\par ");
                  }
        	  bNewPar = TRUE;
        	  tabcounter = 0;
        	  if (TABBING_ON)
        	     fgetpos(fRtf,&pos_begin_kill);

        	  return TRUE;
        case ' ': fprintf(fRtf," ");	/* ordinary interword space */
        	  while (cThis == ' ')	 /* all spaces after commands are ignored */
        	  {
        	     if (fread(&cThis,1,1,fTex) < 1)
        		numerror(ERR_EOF_INPUT);
        	  }

        	  fseek(fTex,-1L,SEEK_CUR);
        	  return TRUE;
        	  break;
        case '-': /* hyphen */
        	  /* caution: this character has another effect in the tabbing-environment */
        	  if (TABBING_ON);
        	  else
        	     fprintf(fRtf,"\\-");
        	  return TRUE;
        	  break;
        case '+': /* see tabbing-environment */
        	  /* no harm for RTF-output */
        	  break;
        case '<': /* see tabbing-environment */
        	  /* no harm for RTF-output */
        	  break;
        case '~': CmdTildeChar(0);
        	  return TRUE;
        case '^': CmdSpitzeChar(0);
        	  return TRUE;
        case '\"':CmdUmlaute(0);
        	  return TRUE;
        case '`': if (TABBING_ON);
        	  else
        	    CmdLApostrophChar(0);
        	  return TRUE;
        case '\'':if (TABBING_ON);
        	  else
        	     CmdRApostrophChar(0);  /* char ' =?= \' */
        	  return TRUE;
        case '(': CmdFormula(FORM_RND_OPEN);
        	  return TRUE;
        case '[': CmdFormula(FORM_ECK_OPEN);
        	  return TRUE;
        case ')': CmdFormula(FORM_RND_CLOSE);
        	  return TRUE;
        case ']': CmdFormula(FORM_ECK_CLOSE);
        	  return TRUE;
        case '/': CmdIgnore(0);
        	  return TRUE;
        case ',': CmdIgnore(0);  /* \, produces a small space */
        	  return TRUE;
        case '@': CmdIgnore(0);  /* \@ produces an "end of sentence" space */
        	  return TRUE;
        case '>': CmdTabjump(0);
        	  return TRUE;
        case '=': if ( TABBING_ON )
        	  {CmdTabset(0);}
        	  else
                  {CmdMacronChar(0);};
                  
        	  return TRUE;
        case '3': fprintf(fRtf, "\\'df");   /* german symbol '' */
        	  return TRUE;
      }
    }

    if (!isalpha(cThis))
    {
      int found_nl = FALSE;
      /* all spaces after commands are ignored, a single \n may occur */
      while (cThis == ' ' || cThis == '\t' || (cThis == '\n' && (!found_nl)))
        {
        if(cThis == '\n')
            found_nl = TRUE;
        if (fread(&cThis,1,1,fTex) < 1)
            break;
        }
      if (cThis == '\n' && found_nl)
      {
        ParToMakeAfter = TRUE;
      };

      fseek(fTex,-1L,SEEK_CUR); /* position of next character after command
        			   except space */
      break;
    };
    cCommand[i] = cThis;
  }

  cCommand[i] = '\0';  /* mark end of string with zero */

  if (Debug) fprintf(OUTPUTF,"\nTrans [%d]: %s ",linenumber,cCommand);

  if ( i == 0)
    return FALSE;
  if (CallCommandFunc(cCommand)==TRUE) /*call handling function for command*/
    { if (ParToMakeAfter) CmdPar(0); return TRUE;}
  else if (TryDirectConvert(cCommand, fRtf) == TRUE)
    { if (ParToMakeAfter) CmdPar(0); return TRUE;}
  else if (TryVariableIgnore(cCommand, fTex) == TRUE)
    { if (ParToMakeAfter) CmdPar(0); return TRUE;}
  else
    {
      sprintf(errormessage,"command: %s at line %d not found - ignored",cCommand,linenumber);
      warning(errormessage);
      if (ParToMakeAfter) CmdPar(0);
      return FALSE;
    };
  if (ParToMakeAfter) CmdPar(0);
  return TRUE;
}

/****************************************************************************/
void IgnoreTo(char cEnd)
/****************************************************************************
purpose: ignores anything from inputfile till character cEnd
params:  character to stop ignoring
globals: changes inputfile fTex
 ****************************************************************************/
{
  char c;
  while (fread(&c, 1,1,fTex) >= 1)
  {
    if (c == cEnd)
    {
      if (cEnd == '\n')
        fseek(fTex,-1L,SEEK_CUR);   /*linenumber is set in convert-routine */
        /*linenumber++;*/
      return;
    }
    else
    {
     if (c == '\n')
       { linenumber++; InputLineEmpty = TRUE;
       }
    }
  }
  numerror(ERR_EOF_INPUT);
}
/****************************************************************************/
FILE *open_cfg(const char *name)
/****************************************************************************
purpose: open the given *.cfg file looking at various possible paths
returns file pointer
 ****************************************************************************/
{
    char errormessage[256] = "";	
    char *cfg_path = getenv("RTFPATH");
    char path[1024] = ""; char exe_path[1024]; char *ttt=NULL;
    FILE *fp;

    if (Debug) fprintf(OUTPUTF,"\n%s: Libdir=%s|", progname, LIBDIR );
    sprintf(exe_path,"%s",progname);
      ttt = strrchr(exe_path,'/');
      ttt[0] = '\0';
    if (Debug) fprintf(OUTPUTF,"\nPath to ltx2rtf executable = %s",exe_path);

/* trying to open in current directory */
    if (Debug) fprintf(OUTPUTF,"\ntrying to open:%s|",name);
    if((fp = fopen(name,"r")) != NULL)	return(fp);

/* trying to open in RTFPATH directory */
    if(cfg_path != NULL)
    {
    	sprintf(path,"%s/%s",cfg_path,name);
        if ( Debug) fprintf(OUTPUTF,"\ntrying to open:%s|",path);
        if((fp = fopen(path,"r")) != NULL)	return(fp);
    };

/* trying to open in the directory where ltx2rtf has been found */
    
    sprintf(path,"%s/%s",exe_path,name);
    if ( Debug) fprintf(OUTPUTF,"\ntrying to open:%s|",path);
    if((fp = fopen(path,"r")) != NULL)    return(fp);

/* trying to open in LIBDIR directory */
    sprintf(path,"%s/%s",LIBDIR,name);
    if ( Debug) fprintf(OUTPUTF,"\ntrying to open:%s|",path);
    if((fp = fopen(path,"r")) != NULL)    return(fp);

    sprintf(errormessage, "Cannot open file '%s'.",name);
    fclose(fp);
    error(errormessage);
}
/******************************************************************************/
BOOL GetConfigs()
/******************************************************************************
  purpose: reads from the file config.cfg where programs can be found
           to latex an equation TeX file inside the TMPDIR directory
           to convert a DVI file inside the TMPDIR directory to a *.PGM file
           stores them into global char[..] variables.
 ******************************************************************************/
{
  FILE *fp;
  char buffer[512];
  int i;
  char *buffpoint;
  char *ttt = NULL;
  char *qqq = NULL;
  char command[512] = "";
  char label[512]="";

  fp = open_cfg("config.cfg");
  for(;;)
  {
    if ( (fgets( buffer, 512, fp )) == NULL)
    {
      fclose(fp);
      return FALSE;
    }
    if (strlen(buffer) > 256)
    {
      fclose(fp);
      error("line too long in CONFIG.CFG - only 256 characters.");
      return FALSE;
    }
    buffpoint = buffer;
    i = strlen(buffer);
    while((buffer[i-1] <= ' ') && (i > 0)) {buffer[i-1] = '\0'; i--;};
    if(buffer[0] != '#')
    { ttt = strchr(buffer,'=');
      if (ttt == NULL)
      { sprintf(Error_Msg_Text,"in config.cfg, line '%s' has no '=', ignored",buffer);
        if (buffer[0] != '\0')  warning(Error_Msg_Text);
      }
      else
      { /* fprintf(OUTPUTF,"\nbuffer=|%s|",buffer); */
        /* fprintf(OUTPUTF,"\nttt   =|%s|",ttt); */
        ttt++;
        /* fprintf(OUTPUTF,"\nttt   =|%s|",ttt); */
        sprintf(command,"%s",ttt);
        ttt--;
        ttt[0]='\0';
        sprintf(label,"%s",buffer);
        if (Debug) fprintf(OUTPUTF,"\nlabel   =|%s|",label);
        buffpoint = command;
        i = strlen(command);
        while((command[i-1] <= ' ') && (i > 0)) {command[i-1] = '\0'; i--;};
        if (Debug) fprintf(OUTPUTF,"\ncommand =|%s|",command);

        if (strcmp(label,"latextmp") == 0)
        { sprintf(LaTeXingCommand,"%s",command);}
        else if (strcmp(label,"dvi2pbm") == 0)
        { sprintf(PBMingCommand,"%s",command);}
        else
        { sprintf(Error_Msg_Text,"config.cfg: specification %s not understood, ignored",label);
          warning(Error_Msg_Text);
        };
      };
    };
  }  /* end while */
      fclose(fp);
      return TRUE;
}

/******************************************************************************/
BOOL SaveInitialDir()
/******************************************************************************
get the current directory position, in order to be able to come back!
 ******************************************************************************/
{
  int zz;	
#ifdef MSDOS  
  system ("cd > cd.log");
#else
  system ("pwd > cd.log");
#endif
  fUtil = fopen("cd.log","r");
  fgets(InitialDir,126,fUtil);
  zz = strlen(InitialDir);
  while((InitialDir[zz-1] <= ' ') && (zz > 0)) {InitialDir[zz-1] = '\0'; zz--;};
  fprintf(OUTPUTF,"\nInitial directory is %s",InitialDir);

 }
/******************************************************************************/
BOOL RestoreInitialDir()
/******************************************************************************
restores to the current directory position, needed by MSDOS!
 ******************************************************************************/
{
   char cd_command[140];

   sprintf(cd_command,"%s",InitialDir);
   cd_command[2] = '\0';
   if (Debug) Message(cd_command);
   system(cd_command);

   sprintf(cd_command,"cd %s",InitialDir);
   if (Debug) Message(cd_command);
   system(cd_command);

 }

