/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotation;
import org.w3c.dom.Element;

public class FDFAnnotationCaret
extends FDFAnnotation {
    public static final String SUBTYPE = "Caret";

    public FDFAnnotationCaret() {
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
    }

    public FDFAnnotationCaret(COSDictionary a) {
        super(a);
    }

    public FDFAnnotationCaret(Element element) throws IOException {
        super(element);
        String symbol;
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
        String fringe = element.getAttribute("fringe");
        if (fringe != null && !fringe.isEmpty()) {
            String[] fringeValues = fringe.split(",");
            if (fringeValues.length != 4) {
                throw new IOException("Error: wrong amount of numbers in attribute 'fringe'");
            }
            float[] values = new float[4];
            for (int i = 0; i < 4; ++i) {
                values[i] = Float.parseFloat(fringeValues[i]);
            }
            COSArray array = new COSArray();
            array.setFloatArray(values);
            this.setFringe(new PDRectangle(array));
        }
        if ((symbol = element.getAttribute("symbol")) != null && !symbol.isEmpty()) {
            this.setSymbol(element.getAttribute("symbol"));
        }
    }

    public void setFringe(PDRectangle fringe) {
        this.annot.setItem(COSName.RD, (COSObjectable)fringe);
    }

    public PDRectangle getFringe() {
        COSArray rd = (COSArray)this.annot.getDictionaryObject(COSName.RD);
        if (rd != null) {
            return new PDRectangle(rd);
        }
        return null;
    }

    public void setSymbol(String symbol) {
        String newSymbol = "None";
        if ("paragraph".equals(symbol)) {
            newSymbol = "P";
        }
        this.annot.setString(COSName.SY, newSymbol);
    }

    public String getSymbol() {
        return this.annot.getString(COSName.SY);
    }
}

