C  THIS PROGRAM TRANSLATES A 'TTEX' INPUT FILE 'name.TTX' ('name' GIVEN
C  ON THE CMD.LINE) INTO A 'TEX' FILE 'name.TEX'.
C-----------------------------------------------------------------------
$STORAGE:2
      CHARACTER CH*1,CH2*2,CHB*16,KCM*2(40),FSY*34,FSE*34,FSM*34
      CHARACTER*2 LIF(5) ! LIST ITEM FONTS
      CHARACTER LI*80,LO*180,BUF*32
      INTEGER*2 LLF(4)
      COMMON/TTVC/II,NI,ILI,IO,IOL,NF,LREC,JCMD,JSKP,JTAB,JTBI,IER,
     & JFUS,JLIT,JNOC,ITB(16,2),LI,LO
      DATA NCM/40/
      DATA LIF/'bf','it','tt','sf','rm'/, LLF/5,5,5,5/
      DATA KCM/
     & '<<'   ,     '__'   ,     '<%'   ,     '=='   ,     '$$'   ,
     & '&&'   ,     '**'   ,     '>>'   ,     '|<'   ,     '>|'   ,
     & '++'   ,     '@@'   ,     '%%'   ,     '<$'   ,     '><'   ,
     & '##'   ,     '#+'   ,     '*#'   ,     '#*'   ,     '=>'   ,
     & '^%'   ,     '^*'   ,     '@%'   ,     '<^'   ,     '^>'   ,
     & '<*'   ,     '*>'   ,     '<>'   ,     '||'   ,     '^$'   ,
     & '^-'   ,     '^='   ,     '^|'   ,     '^#'   ,     '$>'   ,
     & '@='   ,     '@#'   ,     '@*'   ,     '@$'   ,     '*_'   /
      DATA FSY/'ᜑ'/
      DATA FSE/'CueaaaceeeiiiAEooouuOUaiounN?!1234'/
      DATA FSM/'c"|^"`c^"`"^`"|^"`^`""||||~~``    '/ ! READ ' FOR |

C  COMMAND FLAGS IN 'JCMD':
C    BIT  0 : UNDERLINE ACTIVE
C    BIT  1 : FONT ACTIVE
C    BIT  2 : FONT SIZE ACTIVE
C    BIT  3 : CENTER CMD.ACTIVE
C    BIT  4 : IGNORE BLANK INPUT LINES
C    BIT  5 : OUTPUT LINE BEFORE CURRENT IS BLANK
C    BIT  6 : FOOTNOTE ACTIVE
C    BIT  7 : NO-INDENT FLAG
C    BIT  8 : LAST ENTRY WAS FORMULA
C    BIT  9 : BUNDLE ACTIVE
C    BIT 10 : TEX CMD.CONTINUATION
C
C***********************************************************************
      OPEN(6,FILE='ERRSTAT.MSG')
      WRITE(6,'(24X,''TEX CONVERSION ERROR MESSAGES'',/,
     &          24X,29(''=''),/)')
      CALL GETARG(1,LI,I)
      IF(I.LE.0) THEN
        WRITE(6,'('' ** INPUT FILE NAME MISSING ON CMD.LINE!'')')
        IER=2
        GOTO 911
      ENDIF
      OPEN(11,FILE=LI(1:I)//'.TEX')                       ! TEX OUTPUT
      OPEN(10,FILE=LI(1:I)//'.TTX',STATUS='OLD',IOSTAT=J) ! TTX INPUT
      IF(J.NE.0) THEN
        WRITE(6,'('' ** INPUT FILE NOT FOUND!'')')
        IER=2
        GOTO 911
      ENDIF
      CALL GETARG(2,BUF,II)
      IF(II.LE.0) THEN
        WRITE(6,'('' ** DEFAULT PREAMBLE PATH MISSING ON CMD.LINE!'')')
        IER=2
        GOTO 911
      ENDIF
      LREC=72
      WRITE(*,'(''  STARTING CONVERSION TO TEX FILE'')')
      WRITE(11,'(''%'',/,''%** TEX file generated from '',A)')
     & LI(1:I)//'.TTX'
      READ(10,'(A)') LI
      IF(LI(1:2).EQ.'%*') THEN
        J=VERIFY(LI,' ',.TRUE.)
        IF(J.LE.2) THEN
          WRITE(*,'('' ** MISSING PREAMBLE FILE NAME, LINE 1'')')
          WRITE(11,'(''%** Default preamble taken from DEFAULT.PRA'')')
          OPEN(12,FILE=BUF(1:II)//'DEFAULT.PRA',STATUS='OLD',ERR=13)
          BACKSPACE(10)
          ILI=0
        ELSE
          WRITE(11,'(''%** Preamble taken from '',A)') LI(3:J)
          OPEN(12,FILE=LI(3:J),STATUS='OLD',ERR=13)       ! PREAMBLE
          ILI=1 ! INITIALIZE LINE COUNTER
        ENDIF
      ELSE
        WRITE(11,'(''%** Default preamble taken from DEFAULT.PRA'')')
        OPEN(12,FILE=BUF(1:II)//'DEFAULT.PRA',STATUS='OLD',ERR=13)
        BACKSPACE(10)
        ILI=0
      ENDIF
      WRITE(11,'(''%'')')
      GOTO 15
   13 CONTINUE
      WRITE(6,'('' ** PREAMBLE FILE NOT FOUND'')')
      IER=2
      GOTO 911
   15 CONTINUE
      I=1
      DO J=1,16 ! SET DEFAULT TABS
        ITB(J,1)=I
        ITB(J,2)=I
        I=I+4
      ENDDO
      IER=0
      JTAB=0
      JTBI=0
      JCMD=0
      JTEX=0
      JTXC=0
      JLIT=0
      JNOC=0
      JFUS=0
      JSKP=0 ! SKIP FLAG (TO REMOVE ITG)
      NF=0
      II=0 ! CURRENT CHAR.INDEX IN INPUT LINE
      IO=0 ! CURRENT CHAR.INDEX IN OUTPUT LINE
      IOL=0 ! SAVES PREVIOUS IO
C  ENTER PREAMBLE
      J=0
   50 CONTINUE
      READ(12,'(A)',END=60) LI
      NI=VERIFY(LI,' ',.TRUE.)
      IF(NI.LE.0) GOTO 50
      J=J+1
      IF(J.GE.2) NI=-NI
      CALL ENTLO(LI,NI)
      GOTO 50
   60 CONTINUE
      CALL ENTLO(' ',0)
C  START READING INPUT FILE 1 LINE AT A TIME
  100 CONTINUE
      READ(10,'(A)',END=500) LI
      ILI=ILI+1
      NI=VERIFY(LI,' ',.TRUE.) ! INPUT LINE LENGTH
      IF(BTEST(JCMD,10)) THEN ! TEX CMD.CONTINUATION
        WRITE(11,'(A)') LI(1:NI)
        IF(LI(NI:NI).NE.'%') THEN ! NO MORE CONT.LINES
          JCMD=IBCLR(JCMD,10)
        ENDIF
        GOTO 100
      ENDIF
      IF(LI(1:7).EQ.'\begin{') THEN ! START OF TEX ENV.
        IF(JTEX.LE.0) THEN ! COPY AS IS UNTIL \end IS FOUND
          J=INDEX(LI,'}')
          BUF=LI(8:J-1)
          JTEX=1
          CALL ENTLO(' ',0)
          WRITE(11,'(A)') LI
          JCMD=IBCLR(JCMD,4) ! FORGET PRECEDING BLANK LINES
          JCMD=IBCLR(JCMD,5)
          GOTO 100
        ELSE
          WRITE(11,'(A)') LI
          JTEX=JTEX+1
          GOTO 100
        ENDIF
      ELSEIF(LI(1:5).EQ.'\end{') THEN
        WRITE(11,'(A)') LI
        JTEX=JTEX-1
        IF(JTEX.LE.0) THEN
          J=INDEX(LI,'}')
          IF(LI(6:J-1).NE.BUF(1:J-6) .OR. JTEX.LT.0) THEN
            WRITE(6,'(/,'' ** IMPROPER TEX ENVIRONMENT INPUT DETECTED,''
     &      ,'' LINE'',I5)') ILI
            WRITE(6,'(A)') LI(1:NI)
            IER=2
            GOTO 911
          ENDIF
          JCMD=IBSET(JCMD,7) ! NO-INDENT AFTER ENVIRONMENT
        ENDIF
        GOTO 100
      ENDIF
      IF(JTEX.GT.0) THEN ! COPY AS IS, IF WITHIN TEX ENVIRONMENT
        IF(NI.LE.0) THEN
          WRITE(6,'(/,'' ** NO BLANK LINES ALLOWED WITHIN TEX ENVIR.,''
     &    ,'' LINE'',I5)') ILI
          IER=2
          GOTO 911
        ENDIF
        WRITE(11,'(A)') LI
        GOTO 100
      ENDIF
      II=0 ! COLUMN POINTER
      IF(NI.LE.0) THEN ! BLANK LINE
        IF(BTEST(JCMD,4)) GOTO 100
        IF(IO.GT.0 .AND. .NOT.(IO.EQ.10 .AND.
     &    LO(1:10).EQ.'\noindent ')) THEN
          IF(JTAB.NE.0) CALL ENTLO('\\',2)
          CALL ENTLO(' ',0) ! WRITE CURRENT LINE TO OUTPUT
        ENDIF
        WRITE(11,'(A)') ' ' ! BLANK LINE IN OUTPUT
        JCMD=IBSET(JCMD,4)
        JCMD=IBSET(JCMD,5)
        GOTO 100
      ELSE
        CALL ENTLO(' ',0) ! NEW INP.LN.STARTS NEW OUTP.LN.
        JCMD=IBCLR(JCMD,4)
      ENDIF
      IF(LI(1:2).EQ.'""') THEN ! COMMENT LINE
        LI(1:2)='% '
        WRITE(11,'(A)') LI(1:NI)
        GOTO 100
      ELSEIF(LI(1:2).EQ.'"%') THEN ! TEK-ONLY LINE
        CALL ENTLO(' ',0)
        WRITE(11,'(A)') LI(3:NI)
        J=INDEX(LI(3:NI),'\chapter')+
     &    INDEX(LI(3:NI),'\section')+
     &    INDEX(LI(3:NI),'\subsection')+
     &    INDEX(LI(3:NI),'\subsubsection')
        IF(J.GT.0) JCMD=IBSET(JCMD,7) ! SET NO-INDENT FLAG
        GOTO 100
      ELSEIF(LI(1:2).EQ.'%"') THEN ! MTX-ONLY LINE
        GOTO 100
      ELSEIF(LI(1:1).EQ.'^') THEN ! TAB-SET LINE
        IF(LI(2:2).EQ.'@') THEN ! DEFAULT TABS
          DO J=1,16
            ITB(J,2)=ITB(J,1)
          ENDDO
        ELSE
          J=INDEX(LI(2:NI),'^')
          IF(J.GT.0) THEN ! POSITION TABS
            I=1
            IA=1
            DO WHILE(J.GT.0)
              IA=IA+1
              I=I+J
              ITB(IA,2)=I
              J=INDEX(LI(I+1:NI),'^')
            ENDDO
            IF(IA.LE.15) ITB(IA+1,2)=0
          ELSE ! NUMERIC TABS
            CALL READI(LI(2:NI),NI-1,ITB(2,2),IA)
            IF(IA.LE.15) ITB(IA+2,2)=0
          ENDIF
        ENDIF
        GOTO 100
      ENDIF
      J=MAX(INDEX(LI(1:NI),' ^ '),INDEX(LI(1:NI),' ^^'))
      IF(J.GT.0 .AND. JTBI.EQ.0) THEN ! TABS (<^ USES ^ AS >> )
        IF(JTAB.EQ.0) THEN ! SET UP TABBING ENVIR.
          JTAB=-1
          J=INDEX(LO(1:IOL),'\\')
          IF(IO.EQ.0 .AND. J.GT.0) THEN ! ELIMIN. \\ IN PREV.LINE
            BACKSPACE 11
            IO=J-1
          ENDIF
          CALL ENTLO('\begin{tabbing}',-15)
          CALL ENTLO(' ',0)
          DO J=2,13
            IF(ITB(J,2).LE.0) EXIT
            AX=.44*FLOAT(ITB(J,2)-ITB(J-1,2))
            WRITE(CHB(1:12),'(''\h{'',F4.2,''em}\='')') AX
            IF(CHB(4:4).NE.'*') THEN ! WRITE OK
              CALL ENTLO(CHB(1:12),12)
            ELSE ! FIELD TOO SHORT, ADD ONE CHAR.
              WRITE(CHB(1:13),'(''\h{'',F5.2,''em}\='')') AX
              CALL ENTLO(CHB(1:13),13)
            ENDIF
          ENDDO
          CALL ENTLO('\kill',5)
          CALL ENTLO(' ',0)
        ENDIF
      ELSE
        IF(JTAB.NE.0) THEN ! TERMINATE TABBING
          JTAB=0
          J=INDEX(LO(1:IOL),'\\')
          IF(IO.EQ.0 .AND. J.GT.0) THEN ! ELIMIN. \\ IN PREV.LINE
            IF(BTEST(JCMD,5)) BACKSPACE 11 ! REMOVE BLANK LINE
            BACKSPACE 11
            IOL=J-1
            WRITE(11,'(A)') LO(1:IOL)
C           IF(BTEST(JCMD,5)) WRITE(11,'(A)') ' ' ! why put it back in?
          ENDIF
          CALL ENTLO('\end{tabbing}',13)
          CALL ENTLO(' ',0)
        ENDIF
      ENDIF
      IF(LI(1:1).EQ.'\') THEN ! POSSIBLE TEX CMD.LINE
        K=0
        DO I=1,NI
          CH=LI(I:I)
          IF(K.EQ.0 .AND. CH.EQ.' ') EXIT
          J=INDEX('{[',CH)-INDEX('}]',CH)
          IF(J.GT.0) THEN
            K=K+1
          ELSEIF(J.LT.0) THEN
            K=K-1
          ENDIF
        ENDDO
        IF(I.GT.NI) THEN ! CONFIRMED TEX CMD.LINE
          WRITE(11,'(A)') LI(1:NI)
          J=INDEX(LI(1:NI),'\chapter')+
     &      INDEX(LI(1:NI),'\section')+
     &      INDEX(LI(1:NI),'\subsection')+
     &      INDEX(LI(1:NI),'\subsubsection')
          IF(J.GT.0) JCMD=IBSET(JCMD,7) ! SET NO-INDENT FLAG
          IF(LI(NI:NI).EQ.'%' .OR. LI(1:15).EQ.'\newenvironment') THEN
            JCMD=IBSET(JCMD,10) ! NEXT LINE CONTINUES TEX CMD.
          ENDIF
          GOTO 100
        ENDIF
      ENDIF
      IF(JTBI.LT.0) THEN ! NEW ITEM IN LIST
        J=INDEX(LI(1:NI),' ^ ')  ! FIND INDENT CMD. (1ST OF ^ OR >> )
        I=INDEX(LI(1:NI),' >> ')
        IF((J.LE.0 .AND. I.LE.0) .OR. (J.GT.0 .AND. I.GT.0)) THEN
          WRITE(6,'(/,'' IMPROPER TAB-INDENT (LIST) ITEM, POSSIBLY '',
     &    ''MISSING <^0, BEFORE LINE '',I3,'':'')') ILI
          WRITE(6,'(A)') LI(1:NI)
          IER=2
          GOTO 911
        ENDIF
        IF(I.GT.0 .AND. (J.LE.0 .OR. J.GT.I)) THEN
          J=I
          IITM=J+3
        ELSE
          IITM=J+2
        ENDIF
        J=J-1 ! END OF ITEM STRING
        IF(VERIFY(LI(1:J),' ').GT.0) THEN
          IF(LI(1:2).EQ.'@@' .AND. ILTR(LI(3:3)).LT.0) THEN ! FONT CMD.?
            II=4 ! STRIP OFF FONT CMD.
            I=INDEX(LI(4:J),'@@') ! FONT CMD.RESET ?
            IF(I.GT.0 .AND. VERIFY(LI(I+5:J),' ').LE.0) J=I+1 ! REMOVE
            IF(JLIT.LT.0) THEN ! 1ST ITEM
              I=INDEX('bimpr',LI(3:3))
              IF(I.LE.0) THEN
                WRITE(6,'(/,'' ** ALPH.CMD.ARGUMENT MUST BE ONE OF '',
     &          ''bimpr, @@ CMD.IN LINE'',I3,'' IGNORED'')') ILI
                WRITE(6,'(A)') LI(1:NI)
                IER=2
              ENDIF
              CALL ENTLO('\renewcommand{\entrylabel}[1]',-29)
              CALL ENTLO('{\mbox{\text'//LIF(I)//'{#1}}\hfill}',26)
              LLF(IABS(JTBI))=I ! SAVE FONT FOR LIST LEVEL
            ENDIF
            CALL ENTLO('\item[',-6)
            JLIT=J
            GOTO 200
          ELSE
            IF(JLIT.LT.0) THEN
              IF(LI(1:2).EQ.'||') THEN ! I: DESIRED FONT INDEX
                I=3
              ELSE
                I=5
              ENDIF
              IF(IABS(JTBI).GT.1) THEN ! K: CURRENT FONT INDEX
                K=LLF(IABS(JTBI)-1)
              ELSE
                K=5
              ENDIF
              IF(I.NE.K) THEN
                CALL ENTLO('\renewcommand{\entrylabel}[1]',-29)
                CALL ENTLO('{\mbox{\text'//LIF(I)//'{#1}}\hfill}',26)
                CALL ENTLO(' ',0)
                LLF(IABS(JTBI))=I
              ENDIF
            ENDIF
            CALL ENTLO('\item[',-6)
            JLIT=J
            GOTO 200
          ENDIF
        ELSE
          CALL ENTLO('\item ',-6)
          JLIT=0
          II=IITM
          JTBI=-JTBI
        ENDIF
      ENDIF
C  TRANSFER CHAR.TO OUTPUT
  200 CONTINUE
      IF(BTEST(JCMD,7)) THEN
        IF(IO.EQ.0) THEN
          CALL ENTLO('\noindent ',10)
          IO=10
        ENDIF
        JCMD=IBCLR(JCMD,7)
      ENDIF
      II=II+1
      IF(II.GT.NI) GOTO 100
C  TEX CMD.,COPY:
      IF(JTXC.NE.0 .AND. LI(II:II).NE.'{' .AND. LI(II:II).NE.'}') THEN
        IF(JTXC.EQ.-1 .AND. LI(II:II).EQ.' ' .OR. II.EQ.NI) JTXC=0
        CALL ENTLO(LI(II:II),1)
        GOTO 200
      ENDIF
      IF(JLIT.GT.0) THEN ! ACTIVE LIST ITEM ENTRY
        IF(II.GT.JLIT) THEN ! BEYOND END OF ITEM
          JLIT=0
          IF(JNOC.GT.0) JNOC=0 ! RESET NO-CMD.FLAG
          CALL ENTLO('] ',2)
          JTBI=-JTBI
          II=IITM
          GOTO 200
        ENDIF
      ENDIF
C  LOOK FOR ELLIPSIS (DOTS)
      IF(LI(II:II).EQ.'.' .AND. II.LT.NI .AND.
     &LI(II+1:II+1).EQ.'.' .AND. LI(II+2:II+2).NE.'.') THEN
        CALL ENTLO(' \dots ',7)
        II=II+1
        GOTO 200
      ENDIF
C  LOOK FOR NONBREAKING DASHES
      CH=LI(II-1:II-1)
      IF(LI(II:II).EQ.'`') THEN
        IF(II.GT.1 .AND. II.LT.NI .AND. CH.NE.' ' .AND. CH.NE.'`'
     &  .AND. LI(II+1:II+1).NE.' ') THEN
          CALL ENTLO('\nobreakdash-',13)
          GOTO 200
        ENDIF
      ENDIF
C  LOOK FOR TEX CMDS (\ PRECEDED BY BLANK, {, OR 1ST ON LINE),
C    LETTER MUST FOLLOW \
      IF(LI(II:II).EQ.'\' .AND. (II.EQ.1 .OR. LI(II-1:II-1).EQ.' ' .OR.
     &(II.GT.1 .AND. LI(II-1:II-1).EQ.'{')) .AND.
     &II.LT.NI .AND. ILTR(LI(II+1:II+1)).NE.0) THEN
        IF((II.EQ.1 .OR. LI(II-1:II-1).NE.'{') .AND. JTXC.EQ.0) THEN
          JTXC=-1
        ELSE
          JTXC=JTXC+1
        ENDIF
        CALL ENTLO(LI(II:II),1)
        GOTO 200
      ENDIF
C  LOOK FOR TEXT CMDS. (MATHTEXT)
      IF(JNOC.GT.0 .AND.LI(II:II).EQ.'|' .AND.
     &   LI(II+1:II+1).EQ.'|') THEN ! RESET NO-CMD.FLAG FOR LIST ITEM
        JNOC=0
        II=II+1
        GOTO 200
      ENDIF
      IF(ISPC(LI(II:II)).LE.0 .OR. ISPC(LI(II+1:II+1)).LE.0 .OR.
     &   (II.GT.1 .AND. IPCT(LI(II-1:II-1)).LT.0) .OR.
     &   JNOC.NE.0) THEN ! NOT A TXT.CMD
        IF(JNOC.LT.0) JNOC=0 ! NO-CMD.FLAG FOR JUST ONE CMD.
        CH=LI(II:II)
        IF(LI(II-1:II+1).EQ.' ^ ') THEN ! TAB CHAR.
          IF(JNOC.NE.1) THEN
            IF(JTBI.NE.0) GOTO 200
            IF(JTAB.EQ.-1) THEN
              JTAB=2
            ELSE
              JTAB=JTAB+1
            ENDIF
            IF(ITB(JTAB,2).LE.0) THEN
              WRITE(6,'(/,'' UNDEFINED TAB POSITION, LINE '',
     &        I3,'':'')') ILI
              WRITE(6,'(A)') LI(1:NI)
              IER=2
              GOTO 911
            ENDIF
            CALL ENTLO('\>',-2)
          ELSE
            CALL ENTLO('\^\,\!',6)
          ENDIF
          GOTO 200
        ELSEIF(CH.EQ.'\' .AND. II.GT.1 .AND. ILTR(LI(II-1:II-1)).NE.0
     &    .AND. ILTR(LI(II+1:II+1)).NE.0) THEN ! \ BETW.LTRS: HYPH.HLP
          CALL ENTLO('\-',2)
          GOTO 200
        ENDIF
        IF(ICHAR(CH).GE.128) THEN ! TRANSLATE EXTENDED ASCII CHARS.
          J=INDEX(FSY,CH)
          IF(J.LE.0) THEN
            WRITE(6,'(/,'' ** IGNORED CHAR. '',A1,'' ON LINE '',I3)')
     &                CH,ILI
            WRITE(6,'(A)') LI(1:NI)
            IER=2
            GOTO 200
          ENDIF
          CH=FSM(J:J)
          IF(CH.EQ.'|') CH=CHAR(39) ! | USED INSTEAD OF ' IN TABLE FSM
          IF(J.LE.28) THEN
            CALL ENTLO('\'//CH//'{'//FSE(J:J)//'}',5)
          ELSEIF(J.LE.30) THEN
            CALL ENTLO(FSE(J:J)//CH,2)
          ELSEIF(J.EQ.31) THEN
            CALL ENTLO('\ss ',4)
            IF(II.EQ.NI .OR. LI(II+1:II+1).EQ.' ') CALL ENTLO('\ ',2)
          ELSEIF(J.EQ.32) THEN
            CALL ENTLO('\pounds',7)
          ELSEIF(J.EQ.33) THEN
            CALL ENTLO('\ae ',4)
            IF(II.EQ.NI .OR. LI(II+1:II+1).EQ.' ') CALL ENTLO('\ ',2)
          ELSEIF(J.EQ.34) THEN
            CALL ENTLO('\AE ',4)
            IF(II.EQ.NI .OR. LI(II+1:II+1).EQ.' ') CALL ENTLO('\ ',2)
          ENDIF
          GOTO 200
        ENDIF
        IF((IO.GT.0 .OR. CH.NE.' ') .AND. JSKP.NE.1) THEN
          J=INDEX('#$%&_~^{}',CH) ! LOOK FOR SPECIAL CHARS.
          IF(CH.EQ.'{' .AND. LI(II+1:II+1).EQ.'\' .AND. JTXC.EQ.0) THEN
            CALL ENTLO(CH,1) ! {\CMD ... }
          ELSEIF(CH.EQ.'{' .AND. JTXC.NE.0) THEN ! BEG.OF TEX CMD.ARG.
            IF(JTXC.EQ.-1) JTXC=0
            JTXC=JTXC+1
            CALL ENTLO(CH,1)
          ELSEIF(CH.EQ.'}' .AND. JTXC.GT.0) THEN ! END OF TEX CMD.
            JTXC=JTXC-1 ! DECREM.CMD.LEVEL
            CALL ENTLO(CH,1)
          ELSEIF(CH.EQ.'~' .AND. II.GT.1 .AND. II.LT.NI .AND.
     &      LI(II-1:II-1).NE.' ' .AND. LI(II+1:II+1).NE.' ') THEN
            CALL ENTLO(CH,1) ! ~ BETW.NON-BLANKS IS HARD SPACE
          ELSEIF(J.GT.0) THEN
            CALL ENTLO('\'//CH,2)
          ELSEIF(CH.EQ.'<' .OR. CH.EQ.'>') THEN
            IF(JNOC.NE.1) THEN
              CALL ENTLO('$'//CH//'$',3)
            ELSE
              CALL ENTLO(CH,1)
            ENDIF
          ELSEIF(CH.EQ.'\') THEN
            CALL ENTLO('$\backslash$',12)
          ELSE
            CALL ENTLO(CH,1) ! STANDARD CHAR.
          ENDIF
        ENDIF
      ELSE ! FOUND 2 SPECIAL CHARS.,CHK.FOR TXT.CMDS
        CH2=LI(II:II+1)
        IF(CH2.EQ.'^^' .AND. LI(II-1:II-1).EQ.' ') THEN ! REPEATED TAB
          J=-2
          DO WHILE(LI(II:II).EQ.'^')
            IF(JTAB.EQ.-1) THEN
              JTAB=2
            ELSE
              JTAB=JTAB+1
            ENDIF
            IF(ITB(JTAB,2).LE.0) THEN
              WRITE(6,'(/,'' UNDEFINED TAB POSITION, LINE '',
     &        I3,'':'')') ILI
              WRITE(6,'(A)') LI(1:NI)
              IER=2
              GOTO 911
            ENDIF
            CALL ENTLO('\>',J)
            J=2
            II=II+1
          ENDDO
          II=II-1
          GOTO 200
        ENDIF
        DO J=1,NCM+1
          IF(CH2.EQ.KCM(J)) EXIT
          IF(J.GT.NCM) EXIT
        ENDDO
        IF(J.GT.NCM) THEN ! NO TXT.CMD
          II=II-1
          JNOC=-1
          JCMD=IBCLR(JCMD,8) ! CLEAR FORMULA FLAG
        ELSE
          CALL TXCMD(J,LIF,LLF)
          IF(J.LT.0) THEN
            IF(IER.LT.2) THEN
              WRITE(6,'(/,'' ** TXT.CMD. '',A2,'' WAS IGNORED ON LINE'',
     &        I4)') KCM(IABS(J)),ILI
              WRITE(6,'(A)') LI(1:NI)
              IER=1
            ELSE
              WRITE(6,'(/,'' ** TXT.CMD.ERROR, LINE'',I4)') ILI
              WRITE(6,'(A)') LI(1:NI)
              GOTO 911
            ENDIF
          ENDIF
        ENDIF
      ENDIF
      GOTO 200
  500 CONTINUE
      IF(JTAB.NE.0) THEN
        J=INDEX(LO(1:IOL),'\\')
        IF(IO.EQ.0 .AND. J.GT.0) THEN ! ELIMIN. \\ IN PREV.LINE
          IF(BTEST(JCMD,5)) BACKSPACE 11 ! REMOVE BLANK LINE
          BACKSPACE 11
          IOL=J-1
          WRITE(11,'(A)') LO(1:IOL)
          IF(BTEST(JCMD,5)) WRITE(11,'(A)') ' '
        ENDIF
        CALL ENTLO('\end{tabbing}',13)
      ENDIF
      IF(BTEST(JCMD,0)) THEN
        CALL ENTLO('}',1)
      ENDIF
      IF(BTEST(JCMD,1)) THEN
        CALL ENTLO('}',1)
      ENDIF
      IF(BTEST(JCMD,2)) THEN
        CALL ENTLO('}',1)
      ENDIF
      IF(BTEST(JCMD,3)) THEN
        WRITE(6,'('' ** CENTER CMD. >< WITHOUT LINE TERMINATION'')')
        IER=2
        GOTO 911
      ENDIF
      IF(JTEX.GT.0) THEN
        WRITE(6,'('' ** IMPROPER TEX ENVIRONMENT INPUT DETECTED, LINE'',
     &  I5)') ILI
        WRITE(6,'(A)') LI(1:NI)
        IER=2
        GOTO 911
      ENDIF
      IF(JTBI.NE.0) THEN
        WRITE(6,'('' ** IMPROPER TAB-INDENT STRUCTURE (MISSING <^0 ?)''
     &  )')
        IER=2
        GOTO 911
      ENDIF
      CALL ENTLO('\end{document}',-14)
      CALL ENTLO(' ',0)
  911 CONTINUE
      IF(IER.LE.0) CLOSE(6,STATUS='DELETE')
      WRITE(*,'(''  DONE'')')
      STOP ' '
      END


      SUBROUTINE ENTLO(STR,LS)
C  ENTERS STRING 'STR' (LENGTH 'LS') INTO 'LO' AFTER LOC.'IO'
C  A NEGATIVE OR ZERO 'LS' FORCES 'LO(1:IO)' TO BE WRITTEN TO UNIT 11
C  BEFORE 'STR' IS ENTERED.
C  WITH 'LS' POSITIVE 'LO' IS WRITTEN TO UNIT 11 IF 'STR' DOES NOT FIT.
C-----------------------------------------------------------------------
      CHARACTER STR*(*)
      CHARACTER LI*80,LO*180
      COMMON/TTVC/II,NI,ILI,IO,IOL,NF,LREC,JCMD,JSKP,JTAB,JTBI,IER,
     & JFUS,JLIT,JNOC,ITB(16,2),LI,LO
C***********************************************************************
      I=IABS(LS)
      IF(IO.GT.0) THEN
        IF(LS.GT.0 .AND. STR(1:1).EQ.'}') THEN ! ELIM.BLANKS PRECEDING }
          DO WHILE(LO(IO:IO).EQ.' ')
            IO=IO-1
          ENDDO
        ENDIF
      ELSE
        IF(STR(1:1).EQ.'}' .AND. LS.GT.0) THEN ! IF } IS 1ST CHAR.ON OL
          IF(BTEST(JCMD,5)) BACKSPACE 11       ! APPEND TO PREV.OL
          BACKSPACE 11
          J=IOL+1
          IOL=IOL+LS
          LO(J:IOL)=STR(1:LS)
          WRITE(11,'(A)') LO(1:IOL)
          IF(BTEST(JCMD,5)) WRITE(11,'(A)') ' '
          RETURN
        ENDIF
      ENDIF
      IF(LS.LE.0) THEN ! WRITE OUT 'LO' BEFORE ENTERING STRING
        IF(IO.GT.0) THEN
          WRITE(11,'(A)') LO(1:IO)
          IOL=IO
          IO=0
          JCMD=IBCLR(JCMD,5) ! PRECEDING OL NOT BLANK
        ENDIF
      ELSEIF(IO+I.GT.LREC) THEN ! LINE FULL, WRITE OUT 'LO'
        IF(IO.GT.0) THEN
          J=SCAN(LO(1:IO),' \',.TRUE.) ! BREAKPOINT MUST BE BLANK OR \
          IF(LO(J-1:J).EQ.'\\') THEN ! HANDLE \\ AND \\\
            J=VERIFY(LO(1:J),'\',.TRUE.)+3
          ENDIF
          IOL=J-1
          WRITE(11,'(A)') LO(1:IOL)
          IF(LO(J:J).EQ.' ') J=J+1
          LO(1:IO-J+1)=LO(J:IO)
          IO=IO-J+1
          JCMD=IBCLR(JCMD,5) ! PREDEDING OL NOT BLANK
        ENDIF
      ELSE
      ENDIF
      IF(LS.EQ.0) RETURN
      I1=IO+1
      I2=IO+I
      IF(I2.GE.I1) LO(I1:I2)=STR(1:I)
      IO=I2
      RETURN
      END

      SUBROUTINE TXCMD(IC,LIF,LLF)
C  TRANSLATES MATHTEXT TXT.CMD. TO TEX AND ENTERS IT INTO 'LO'.
C
C   New Text Command:       Example:
C          
C   ++  Label               ++ABCD text (blank is terminator)
C   @=  Equation reference  @=ABC1 text (blank is terminator)
C                           @=ABC1/a text (/ precedes single LC suffix)
C   @#  Page reference      @#ABC text
C   @*  General reference   @*ABCD text
C   @$  Citation reference  @$[page 21]{key}  (syntax same as TEX)
C
C   Note: In all reference cmds.the arg.is terminated by a blank or
C         punctuation mark.
C
C   *_  Footnote beg./end
C
C-----------------------------------------------------------------------
C  TEXT CMD.CODES (KCM):
C     DATA KCM :
C   1:PARAGRAPH  2:UNDERLINE  3:N.L.& SPC. 4:FORMULA    5:IN-TXT.MATH
C   6:BOTTOM LN  7:SPEC.SYMB  8:ADVANCE    9:LEFT MARG 10:RIGHT MARG
C  11:TEX LABEL 12:ALPHABET  13:LINE SKIP 14:IN-T GRPH 15:CENTER
C  16:PAGINATE  17:SKP.PAGES 18:PAG.PRFIX 19:PAG.SFFIX 20:RIGHT JUST.
C  21:TAB SKIP  22:TAB CENTR 23:CH.HEIGHT 24:TAB INDT. 25:TAB ADVANCE
C  26:STRT.BNDL 27:END BUNDL 28:BNDL.LNS. 29:DIR.OBJ.  30:DECIMAL TAB
C  31:HOR.LINE  32:HOR.DB.LN 33:VERT.LINE 34:VER.DB.LN 35:END IT GRPH
C  36:EQN.REF.  37:PAGE REF. 38:GEN.REF.  39:CIT.REF.  40:FOOTNOTE

      CHARACTER CH1*1,CHB*8,AA*48,MTX*2048,SZ*16(9)
      CHARACTER LI*80,LO*180
      CHARACTER*2 LIF(*)
      INTEGER*2 LLF(*)
      COMMON/TTVC/II,NI,ILI,IO,IOL,NF,LREC,JCMD,JSKP,JTAB,JTBI,IER,
     & JFUS,JLIT,JNOC,ITB(16,2),LI,LO
$INCLUDE:'FMLT.INC'
      DATA SZ/'\tiny           ',
     &        '\scriptsize     ',
     &        '\footnotesize   ',
     &        '\small          ',
     &        '\normalsize     ',
     &        '\large          ',
     &        '\Large          ',
     &        '\huge           ',
     &        '\Huge           '/
C***********************************************************************
      BL=' '
      JARG=0 ! ARG.TYPE (0: NONE, 1: LETTER, 2: NUMERIC, 3: <STRING>)
      IA=0
      AA=' '
      II=II+1 ! II > 2ND CHAR.OF TEXT CMD.CODE
C  FIND ARGUMENT UNLESS DIRECT STRING (11, 35-39) OR NONE REQ'D.
      IF(IPCT(LI(II+1:II+1)).LT.0 .AND. IC.NE.4 .AND. IC.NE.29 .AND.
     &  IC.NE.5 .AND. IC.NE.14 .AND. IC.NE.11 .AND. IC.LE.35) THEN
        II=II+1
        CH1=LI(II:II)
        IF(ILTR(LI(II:II)).NE.0) THEN
          IF(ILTR(LI(II+1:II+1)).EQ.0) THEN
            JARG=1
            IA=ILTR(CH1)
          ELSE
            WRITE(6,'(/,'' SINGLE LETTER ONLY ALLOWED AS ARGUMENT,'')')
            IC=-IC
            IER=2
            RETURN
          ENDIF
        ELSEIF(INUM(CH1).GE.0) THEN
          JARG=2
          IA=INUM(CH1)
          J=INUM(LI(II+1:II+1))
          IF(J.GE.0) THEN
            IA=10*IA+J
            II=II+1
          ENDIF
        ELSEIF(CH1.EQ.'<') THEN
          JARG=3
          J=INDEX(LI(II:LREC),'>')
          IA=J-2
          AA(1:IA)=LI(II+1:II+J-2)
          II=II+J-1
        ELSE
          WRITE(6,'(/,'' ** ILLEGAL ARGUMENT,'')')
          IC=-IC
          IER=2
          RETURN
        ENDIF
      ENDIF
C  CHECK FOR ACTIVE CMDS.TO TERMINATE AT END OF LINE
      IF(IC.EQ.1 .OR. IC.EQ.3 .OR. IC.EQ.13) THEN
        IF(BTEST(JCMD,3)) THEN ! CENTER
          IF(IAND(JCMD,7).NE.JFUS) THEN
            WRITE(6,'(/,'' ** @@ , @%  AND __ CMDS.(IF USED) MUST START
     &AFTER '',/,4X,''THE CENTER CMD. ><  AND END BEFORE THE END OF THE
     &LINE'')')
            IC=-IC
            IER=2
            RETURN
          ENDIF
          IO=VERIFY(LO(1:IO),' ',.TRUE.) ! ELIM.TRAILING BLANKS
          CALL ENTLO('\end{center}',-12)
          CALL ENTLO(' ',0)
          IF(IC.NE.1 .OR. MOD(JARG,2).NE.0) JCMD=IBCLR(JCMD,3)
        ENDIF
      ENDIF

C  TRANSLATE TEXT CMDS.:

      IF(IC.EQ.1) THEN ! NEW LINE, NEW PAGE
        IF(JTAB.NE.0 .AND. IO.GT.0) JTAB=-1
        IF(JARG.EQ.0 .OR. JTAB.NE.0) THEN
          JARG=2
          IA=1
        ENDIF
        IF(JARG.EQ.1) THEN
          IF(IABS(IA).EQ.16) THEN
            IF(IA.LT.0) THEN
              CALL ENTLO('\clearpage ',-11)
            ELSE
              CALL ENTLO('\newpage ',-9)
            ENDIF
            CALL ENTLO(' ',0)
          ELSE
            IC=-IC
            IER=1
            RETURN
          ENDIF
        ELSEIF(JARG.EQ.2) THEN
          IF(BTEST(JCMD,3)) THEN
            JCMD=IBCLR(JCMD,3)
          ELSE
            CALL ENTLO(' \\',3)
            CALL ENTLO(' ',0)
          ENDIF
          IF(IA.GT.1) THEN
            WRITE(AA(1:2),'(I2)') IA-1
            AA(3:4)='ex'
            CALL ENTLO('\h{'//AA(1:4)//'}',8)
          ENDIF
        ENDIF

      ELSEIF(IC.EQ. 2) THEN ! UNDERLINE
        IF(.NOT. BTEST(JCMD,0)) THEN
          CALL ENTLO('\underline{',11)
          DO WHILE(LI(II+1:II+1).EQ.' ') ! ELIM.LEADING BLANKS
            II=II+1
          ENDDO
          JCMD=IBSET(JCMD,0)
        ELSE
          IO=VERIFY(LO(1:IO),' ',.TRUE.) ! ELIM.TRAILING BLANKS
          CALL ENTLO('}',1)
          JCMD=IBCLR(JCMD,0)
        ENDIF

      ELSEIF(IC.EQ. 3) THEN ! NEW LINE & SKIP
        IF(JTAB.NE.0 .AND. IO.GT.0) THEN
          JTAB=-1
          CALL ENTLO(' \\',3)
          RETURN
        ENDIF
        IF(JARG.EQ.1) THEN
          IF(IABS(IA).EQ.16) THEN
            IF(IA.LT.0) THEN
              CALL ENTLO('\clearpage ',-11)
            ELSE
              CALL ENTLO('\newpage ',-9)
            ENDIF
            CALL ENTLO(' ',0)
          ELSE
            IC=-IC
            IER=1
            RETURN
          ENDIF
        ELSEIF(JARG.EQ.0) THEN
          CALL ENTLO(' ',0)
          WRITE(11,'(A)') ' '
          CALL ENTLO('\bigskip',8)
          CALL ENTLO(' ',0)
          WRITE(11,'(A)') ' '
          JCMD=IBSET(JCMD,4)
          JCMD=IBSET(JCMD,5)
          CALL ENTLO('\noindent ',10)
        ELSEIF(JARG.EQ.2) THEN
          IF(JTAB.NE.0 .AND. IO.GT.0) CALL ENTLO(' \\',3)
          CALL ENTLO(' ',0)
          WRITE(11,'(A)') ' '
          CALL ENTLO('\bigskip',8)
          CALL ENTLO(' ',0)
          WRITE(11,'(A)') ' '
          JCMD=IBSET(JCMD,4)
          JCMD=IBSET(JCMD,5)
          CALL ENTLO('\noindent ',10)
          IF(IA.GT.1) THEN
            WRITE(AA(1:2),'(I2)') IA-1
            AA(3:4)='ex'
            CALL ENTLO('\h{'//AA(1:4)//'}',8)
          ENDIF
        ENDIF

      ELSEIF(IC.EQ. 4 .OR. IC.EQ.5) THEN ! FORMULA OR IN-TEXT MATH
        IF(IC.EQ.4) THEN
          IF(BTEST(JCMD,5) .AND. IO.EQ.0) THEN
            BACKSPACE 11 ! ELIM.BLANK LINE BEFORE EQN.
            JCMD=IBCLR(JCMD,5)
          ENDIF
          CALL ENTLO(' ',0)
          WRITE(11,'(A)') '% ' ! WRITE MTX INPUT AS A COMMENT
        ELSE
        ENDIF
        I1=II+1
        NAA=0
        IF(LI(I1:I1).EQ.'"') THEN ! == IS FOLLOWED BY ARG.
          J=INDEX(LI(I1+1:NI),'"')
          IF(J.GT.0) THEN
            NAA=J-1
            AA(1:NAA)=LI(I1+1:I1+J-1)
            I1=I1+J+1
          ENDIF
        ENDIF
        KM=0
   50   CONTINUE
        J=INDEX(LI(I1:80),'$$')
        IF(J.GT.0) THEN ! END OF FORMULA ON THIS LINE
          I2=I1+J-2
          KM=KM+1
          J=KM
          KM=KM+I2-I1+1
          MTX(J:KM)=LI(I1:I2)
          II=I2+2
          NCS=KM
          NID=0
          IF(IC.EQ.4) THEN ! FORMULA, GET LABEL (EQN.NO.)
            I1=II+1
            I2=MIN(NI,II+10)
            J=INDEX(LI(I1:I2),'$')
            IF(J.GT.0) THEN
              II=II+J
              I2=I1+J-2
              DO J=I1,I2
                KM=KM+1
                MTX(KM:KM)=LI(J:J)
              ENDDO
              NID=KM
            ELSE
              NID=0
            ENDIF
            IF(NAA.GT.0) THEN ! ENTER ARG.
              J=KM+1
              KM=KM+NAA
              MTX(J:KM)=AA(1:NAA)
              NAA=KM
            ENDIF
            WRITE(11,'(A)') '% '//LI(1:II)
            WRITE(11,'(A)') '% '
          ENDIF
          GOTO 100 ! READ-IN DONE
        ELSE ! MORE LINES REQ'D
          IF(IC.EQ.4) WRITE(11,'(A)') '% '//LI(1:NI)
          I2=NI
          IF(LI(I2-1:I2).EQ.'##') I2=I2-2
          KM=KM+1
          J=KM
          KM=KM+I2-I1
          MTX(J:KM)=LI(I1:I2)
          READ(10,'(A)') LI
          NI=VERIFY(LI,' ',.TRUE.)
          IF(NI.LE.0) THEN
            WRITE(6,'(/,'' ** NO BLANK LINES ALLOWED INSIDE EQN.!,'')')
            IC=-IC
            IER=2
            RETURN
          ENDIF
          ILI=ILI+1
          I1=1
          GOTO 50
        ENDIF
  100   CONTINUE
C       WRITE(*,'(A)') ' '//MTX(1:KM)
        IF(IC.EQ.4) THEN
          NF=NF+1
          I1=NF
        ELSE
          I1=-1
        ENDIF
        CALL PRMATX(MTX,NCS,NID,NAA,I1,IER,ILI)
        IF(IC.EQ.5) THEN
          CALL ENTLO(TEX(1:KTEX),KTEX)
        ELSE
          JCMD=IBSET(JCMD,4) ! ELIM.BLANK LINE AFTER EQN.
          JCMD=IBSET(JCMD,8) ! FLAG FORMULA FOR %% CMD.
        ENDIF
        RETURN

      ELSEIF(IC.EQ. 7) THEN ! SPECIAL SYMBOL
        IF(JARG.EQ.0) THEN
          CALL ENTLO('\bullet ',8)
        ELSEIF(JARG.EQ.2) THEN
          AA(1:2)='**'
          WRITE(AA(3:4),'(I2)') IA
          CALL PRMATX(AA(1:4),4,0,0,-1,IER,ILI)
          CALL ENTLO(TEX(1:KTEX),KTEX)
        ELSEIF(JARG.EQ.3) THEN
          IF(AA(1:1).EQ.'\') THEN
            CALL ENTLO(AA(1:IA)//' ',IA+1)
          ELSE
            CALL ENTLO('\'//AA(1:IA)//' ',IA+2)
          ENDIF
        ENDIF

      ELSEIF(IC.EQ.11) THEN ! LABEL
        IF(IPCT(LI(II+1:II+1)).GE.0) THEN
          WRITE(6,'(/,'' ** MISSING ARGUMENT (LABEL)'')')
          IC=-IC
          IER=2
        ENDIF
        J=II+1
        KM=0
        DO WHILE(IPCT(LI(J:J)).LT.0 .AND. J.LE.NI)
          J=J+1
          KM=KM+1
          IF(KM.GE.8) THEN
            WRITE(6,'(/,'' ** LABEL MAY HAVE AT MOST 8 CHAR.'')')
            IC=-IC
            IER=2
          ENDIF
        ENDDO
        CALL ENTLO('\label{'//LI(II+1:J-1)//'}',J-II+7)
        II=J-1
        RETURN

      ELSEIF(IC.EQ.12) THEN ! ALPHABET
        IF(JARG.EQ.2 .OR. JARG.EQ.3) THEN
          WRITE(6,'(/,'' ** ILLEGAL ARGUMENT,'')')
          IC=-IC
          IER=2
          RETURN
        ENDIF
        IF(BTEST(JCMD,1)) THEN
          JCMD=IBCLR(JCMD,1)
          CALL ENTLO('}',1)
          IF(IABS(IA).EQ.18 .OR. JARG.EQ.0) THEN ! ROMAN (DEFAULT)
            IF(IPCT(LI(II+1:II+1)).GT.0) THEN ! IF @@ CMD IS FOLLOWED
              II=II+1                        ! BY PUNCT., APPEND
              CALL ENTLO(LI(II:II),1)
            ENDIF
            RETURN
          ENDIF
        ENDIF
        IF(IABS(IA).EQ. 7) THEN ! GREEK
          IC=-IC
          IER=1
          RETURN
        ELSEIF(IABS(IA).EQ.19) THEN ! SCRIPT
          IC=-IC
          IER=1
          RETURN
        ELSEIF(IABS(IA).EQ. 5) THEN ! ENGLISH GOTHIC
          IC=-IC
          IER=1
          RETURN
        ELSEIF(IABS(IA).EQ. 3) THEN ! CYRILLIC
          IC=-IC
          IER=1
          RETURN
        ELSEIF(IABS(IA).EQ. 4) THEN ! GERMAN GOTHIC
          IC=-IC
          IER=1
          RETURN
        ELSEIF(IABS(IA).EQ. 9) THEN ! ITALIC
          AA='{\itshape'
        ELSEIF(IABS(IA).EQ.16) THEN ! PLAIN (SANS SERIF)
          AA='{\sffamily'
        ELSEIF(IABS(IA).EQ.13) THEN ! MONOSPACED (TYPEWRITER)
          AA='{\ttfamily'
        ELSEIF(IABS(IA).EQ. 2) THEN ! BOLD
          AA='{\bfseries'
        ELSE
          WRITE(6,'(/,'' ** ILLEGAL ARGUMENT,'')')
          IC=-IC
          IER=2
          RETURN
        ENDIF
        JCMD=IBSET(JCMD,1)
        J=VERIFY(AA,' ',.TRUE.)
        CALL ENTLO(AA(1:J)//' ',J+1)
        RETURN

      ELSEIF(IC.EQ.13) THEN ! LINE SKIP
        IF(JTAB.NE.0 .AND. IO.GT.0) THEN
          JTAB=-1
          CALL ENTLO(' \\',3)
          RETURN
        ENDIF
        CALL ENTLO(' ',0)
        IF(IA.EQ.0) IA=1
        WRITE(AA(1:2),'(I2)') IA
        AA(3:4)='em'
        CALL ENTLO(' ',-1)
        CALL ENTLO('\vspace{'//AA(1:4)//'}',-13)
        CALL ENTLO(' ',-1)
        CALL ENTLO('\noindent ',-10)
        JCMD=IBSET(JCMD,4)
        JCMD=IBCLR(JCMD,8)

      ELSEIF(IC.EQ.14) THEN ! IN-TEXT GRAPH
        CALL ENTLO(' ',0)
        WRITE(11,'(/,A,/)') '**** GRAPH ****'
        JSKP=1

      ELSEIF(IC.EQ.15) THEN ! CENTER
        CALL ENTLO('\begin{center}',-14)
        CALL ENTLO(' ',0)
        JCMD=IBSET(JCMD,3)
        JFUS=IAND(JCMD,7)

      ELSEIF(IC.EQ.20) THEN ! RIGHT JUSTIFY
        CALL ENTLO('\h{\fill}',9)

      ELSEIF(IC.EQ.23) THEN ! FONT SIZE
        IF(JARG.EQ.1 .OR. JARG.EQ.3) THEN
          WRITE(6,'(/,'' ** ILLEGAL ARGUMENT,'')')
          IC=-IC
          IER=2
          RETURN
        ENDIF
        IF(BTEST(JCMD,2)) THEN
          JCMD=IBCLR(JCMD,2)
          CALL ENTLO('}',1)
          IF(IA.EQ.10 .OR. JARG.EQ.0) THEN ! NORMAL SIZE
            IF(IPCT(LI(II+1:II+1)).GT.0) THEN ! IF @@ CMD IS FOLLOWED
              II=II+1                        ! BY PUNCT., APPEND
              CALL ENTLO(LI(II:II),1)
            ENDIF
            RETURN
          ENDIF
        ENDIF
        I=IA-5
        IF(I.LT.1) I=1
        IF(I.GT.9) I=9
        J=VERIFY(SZ(I),' ',.TRUE.)
        CALL ENTLO('{'//SZ(I)//' ',J+2)
        JCMD=IBSET(JCMD,2)
        RETURN

      ELSEIF(IC.EQ.24) THEN ! TAB INDENT
        IF(JARG.NE.0 .AND. JARG.NE.2) THEN
          WRITE(6,'(/,'' ** ILLEGAL ARGUMENT'')')
          IC=-IC
          IER=2
          RETURN
        ENDIF
        IF(JTAB.NE.0) THEN
          WRITE(6,'(/,'' IMPROPER TAB-INDENT (LIST) ITEM, POSSIBLY '',
     &    ''MISSING <^ '')')
          IC=-IC
          IER=2
          RETURN
        ENDIF
        IF(JTBI.LT.0) THEN ! JTBI IS LIST LEVEL
          WRITE(6,'(/,'' ** MISSING LIST (TAB/INDENT) ITEM '')')
          IC=-IC
          IER=2
          RETURN
        ENDIF
        IF(JARG.EQ.0) IA=1
        IF(IA.EQ.JTBI) THEN
          JTBI=-IA ! GET READY FOR NEXT ITEM
        ELSEIF(IA.GT.JTBI) THEN
          J=IA+1
          IF(ITB(J,2).LE.0) THEN
            WRITE(6,'(/,'' ** TAB NO.'',I2,'' UNDEFINED'')') J
            IC=-IC
            IER=2
            RETURN
          ENDIF
          AX=.44*FLOAT(ITB(J,2))
          IF(J.GT.2) AX=AX-.44*FLOAT(ITB(IA,2))
          WRITE(CHB,'(F5.2,'' em'')') AX
          CALL ENTLO('\begin{tlist}{'//CHB//'}',-23)
          CALL ENTLO(' ',0)
          JLIT=-1 ! FLAG 1ST ITEM
          JTBI=-IA
        ELSEIF(IA.LT.JTBI) THEN
          DO J=1,JTBI-IA
            CALL ENTLO('\end{tlist}',-11)
          ENDDO
          CALL ENTLO(' ',0)
          IF(IA.GT.0) THEN ! J: DESIRED FONT INDEX
            J=LLF(IA)
          ELSE
            J=5
          ENDIF
          IF(J.NE.LLF(IABS(JTBI))) THEN
            CALL ENTLO('\renewcommand{\entrylabel}[1]',-29)
            CALL ENTLO('{\mbox{\text'//LIF(J)//'{#1}}\hfill}',26)
            CALL ENTLO(' ',0)
          ENDIF
          IF(IA.LE.0) THEN
            DO J=1,4
              LLF(J)=5
            ENDDO
            JCMD=IBSET(JCMD,7) ! NO INDENT AFTER LIST
          ENDIF
          JTBI=-IA
        ENDIF

      ELSEIF(IC.EQ.26) THEN ! START BUNDLE
        IF(BTEST(JCMD,9)) THEN
          WRITE(6,'(/,'' ** IMPROPER START OF BUNDLE CMD. <*'')')
          IC=-IC
          IER=2
          RETURN
        ENDIF
        JCMD=IBSET(JCMD,9)
        CALL ENTLO('{\samepage ',-11)
        CALL ENTLO(' ',0)

      ELSEIF(IC.EQ.27) THEN ! END BUNDLE
        IF(.NOT.BTEST(JCMD,9)) THEN
          WRITE(6,'(/,'' ** IMPROPER END OF BUNDLE CMD. *>'')')
          IC=-IC
          IER=2
          RETURN
        ENDIF
        JCMD=IBCLR(JCMD,9)
        CALL ENTLO(' }',-2)
        IF(BTEST(JCMD,8)) CALL ENTLO('\noindent ',10)
        CALL ENTLO(' ',0)

      ELSEIF(IC.EQ.29) THEN ! DIRECT OBJECT
        IF(JNOC.GT.0) THEN ! NO-CMD.FLAG FOR LIST ITEM ENTRY
          JNOC=0
          RETURN
        ENDIF
        J=INDEX(LI(II+1:NI),'||')
        IF(J.GT.0) THEN
          IF(JLIT.EQ.0) THEN
            J=II+J+2
            DO WHILE(LI(J:J).EQ.'|')
              J=J+1
            ENDDO
            J=J-3
            CALL ENTLO('\verb'//LI(II+1:J)//'',J-II+7)
            II=J+2
          ELSE
            JNOC=1
          ENDIF
        ELSE
          WRITE(6,'(/,'' ** MISSING TERMINATOR OF || CMD.'')')
          IC=-IC
          IER=2
        ENDIF

      ELSEIF(IC.EQ.35) THEN ! END IN-TEXT GRAPH
        JSKP=0

      ELSEIF(IC.EQ.36) THEN ! EQUATION REFERENCE
        IF(IPCT(LI(II+1:II+1)).GE.0) THEN
          WRITE(6,'(/,'' ** MISSING ARGUMENT (LABEL)'')')
          IC=-IC
          IER=2
        ENDIF
        J=II+1
        KM=0
        DO WHILE(IPCT(LI(J:J)).LT.0 .AND. J.LE.NI)
          J=J+1
          KM=KM+1
          IF(KM.GE.8) THEN
            WRITE(6,'(/,'' ** EQU.LABEL MAY HAVE AT MOST 8 CHAR.'')')
            IC=-IC
            IER=2
          ENDIF
        ENDDO
        IF(LI(J:J).NE.'/') THEN
          CALL ENTLO('\eqref{'//LI(II+1:J-1)//'}',J+7-II)
          II=J-1
        ELSE
          IF(IPCT(LI(J+2:J+2)).GE.0) THEN
              CH1=LI(J+1:J+1)
              CALL ENTLO('(\ref{'//LI(II+1:J-1)//'}'//CH1//')',J+8-II)
          ELSE
            WRITE(6,'(/,'' ** IMPROPER SUBEQU.LABEL'')')
            IC=-IC
            IER=2
          ENDIF
          II=J+1
        ENDIF

      ELSEIF(IC.EQ.37) THEN ! PAGE REFERENCE
        IF(IPCT(LI(II+1:II+1)).GE.0) THEN
          WRITE(6,'(/,'' ** MISSING ARGUMENT (LABEL)'')')
          IC=-IC
          IER=2
        ENDIF
        J=II+1
        KM=0
        DO WHILE(IPCT(LI(J:J)).LT.0 .AND. J.LE.NI)
          J=J+1
          KM=KM+1
          IF(KM.GE.8) THEN
            WRITE(6,'(/,'' ** PAGE LABEL MAY HAVE AT MOST 8 CHAR.'')')
            IC=-IC
            IER=2
          ENDIF
        ENDDO
        CALL ENTLO('\pageref{'//LI(II+1:J-1)//'}',J+9-II)
        II=J-1

      ELSEIF(IC.EQ.38) THEN ! GENERAL REFERENCE
        IF(IPCT(LI(II+1:II+1)).GE.0) THEN
          WRITE(6,'(/,'' ** MISSING ARGUMENT (LABEL)'')')
          IC=-IC
          IER=2
        ENDIF
        J=II+1
        KM=0
        DO WHILE(IPCT(LI(J:J)).LT.0 .AND. J.LE.NI)
          J=J+1
          KM=KM+1
          IF(KM.GE.8) THEN
            WRITE(6,'(/,'' ** GEN.LABEL MAY HAVE AT MOST 8 CHAR.'')')
            IC=-IC
            IER=2
          ENDIF
        ENDDO
        CALL ENTLO('\ref{'//LI(II+1:J-1)//'}',J+5-II)
        II=J-1

      ELSEIF(IC.EQ.39) THEN ! CITATION REFERENCE
        IF(IPCT(LI(II+1:II+1)).GE.0) THEN
          WRITE(6,'(/,'' ** MISSING ARGUMENT (KEY)'')')
          IC=-IC
          IER=2
        ENDIF
        II=II+1
        J=INDEX(LI(II:NI),'}')
        IF(J.GT.0) THEN
          J=II+J-1
          CALL ENTLO('\cite'//LI(II:J),6+J-II)
          II=J
        ELSE
          II=II-1
          WRITE(6,'(/,'' ** IMPROPER CITATION REFERENCE'')')
          IC=-IC
          IER=2
        ENDIF
        RETURN

      ELSEIF(IC.EQ.40) THEN ! FOOTNOTE
        IF(.NOT. BTEST(JCMD,6)) THEN
          IO=VERIFY(LO(1:IO),' ',.TRUE.) ! ELIM.TRAILING BLANKS
          CALL ENTLO(' \footnote{',11)
          JCMD=IBSET(JCMD,6)
          II=II+1
        ELSE
          IO=VERIFY(LO(1:IO),' ',.TRUE.) ! ELIM.TRAILING BLANKS
          CALL ENTLO('}',1)
          JCMD=IBCLR(JCMD,6)
        ENDIF
        RETURN

      ELSE
        IC=-IC
        IER=1
      ENDIF
      RETURN
      END
