/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties;

import java.io.File;
import net.sourceforge.texlipse.PathUtils;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.bibeditor.BibColorProvider;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import net.sourceforge.texlipse.builder.ProgramRunner;
import net.sourceforge.texlipse.editor.ColorManager;
import net.sourceforge.texlipse.spelling.SpellChecker;
import net.sourceforge.texlipse.viewer.ViewerAttributeRegistry;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class TexlipsePreferenceInitializer
extends AbstractPreferenceInitializer {
    private void initializePaths(IPreferenceStore pref) {
        String path = PathUtils.findInEnvPath("latex", "/usr/bin", "latex.exe", "C:\\texmf\\miktex\\bin");
        int size = BuilderRegistry.getNumberOfRunners();
        int i = 0;
        while (i < size) {
            ProgramRunner runner = BuilderRegistry.getRunner(i);
            File prog = new File(String.valueOf(path) + File.separator + runner.getProgramName());
            if (prog.exists()) {
                runner.initializeDefaults(pref, prog.getAbsolutePath());
            } else {
                runner.initializeDefaults(pref, "");
            }
            ++i;
        }
    }

    public void initializeDefaultPreferences() {
        IPreferenceStore pref = TexlipsePlugin.getDefault().getPreferenceStore();
        pref.setDefault("bibDir", "");
        pref.setDefault("outputFormat", "dvi");
        pref.setDefault("builderNum", 0);
        pref.setDefault("builderConsole", true);
        pref.setDefault("builderParseAuxFiles", true);
        pref.setDefault("buildBeforeView", false);
        pref.setDefault("fileLocPort", 55000);
        this.initializePaths(pref);
        ColorManager.initializeDefaults(pref);
        BibColorProvider.initializeDefaults(pref);
        ViewerAttributeRegistry.initializeDefaults(pref);
        SpellChecker.initializeDefaults(pref);
        pref.setDefault("buildEnvSet", "");
        pref.setDefault("viewerEnvSet", "");
        pref.setDefault("tempFileExts", ".aux,.log,.toc,.ind,.ilg,.bbl,.blg,.lot,.lof,.snm,.nav,.out,.vrb,.run.xml,.bcf");
        pref.setDefault("derivedFiles", ".synctex.gz,.synctex,.pdfsync");
        pref.setDefault("bibCompletion", true);
        pref.setDefault("bibDelay", 500);
        pref.setDefault("texCompletion", true);
        pref.setDefault("texDelay", 500);
        pref.setDefault("autoParsing", true);
        pref.setDefault("autoParsingDelay", 2000);
        pref.setDefault("sectionCheck", true);
        pref.setDefault("bibCodeFolding", true);
        pref.setDefault("bibFoldInitial", false);
        pref.setDefault("bibString", false);
        pref.setDefault("codeFolding", true);
        pref.setDefault("codeFoldingPreamble", false);
        pref.setDefault("codeFoldingPart", false);
        pref.setDefault("codeFoldingChapter", false);
        pref.setDefault("codeFoldingSection", false);
        pref.setDefault("codeFoldingSubSection", false);
        pref.setDefault("codeFoldingSubSubSection", false);
        pref.setDefault("codeFoldingParagraph", false);
        pref.setDefault("codeFoldingEnvs", "");
        pref.setDefault("matchingBrackets", true);
        PreferenceConverter.setDefault((IPreferenceStore)pref, (String)"matchingBracketsColor", (RGB)new RGB(192, 192, 192));
        pref.setDefault("indent", true);
        pref.setDefault("indentLevel", 2);
        pref.setDefault("indentTabs", false);
        pref.setDefault("indentEnvs", "list,enumerate,itemize");
        pref.setDefault("lineLength", 80);
        pref.setDefault("wrapType", "hard");
        pref.setDefault("wrapDefault", true);
        pref.setDefault("texItemCompletion", true);
        pref.setDefault("smartBackspace", true);
        pref.setDefault("texBracketCompletion", true);
        pref.setDefault("texReplaceQuotes", true);
        pref.setDefault("smartLdots", true);
        pref.setDefault("styleCompletionSet", "bold=\\textbf{,italic=\\textit{,roman=\\textrm{,sans serif=\\textsf{,small caps=\\textsc{,slanted=\\textsl{,teletype=\\texttt{,emphasize=\\emph{");
        pref.setDefault("textEditorAnnotations", true);
        pref.setDefault("outlinePreamble", true);
        pref.setDefault("outlinePart", true);
        pref.setDefault("outlineChapter", true);
        pref.setDefault("outlineSection", true);
        pref.setDefault("outlineSubSection", true);
        pref.setDefault("outlineSubSubSection", true);
        pref.setDefault("outlineParagraph", true);
        pref.setDefault("outlineEnvs", "list,enumerate,itemize,figure,table,tabular");
        pref.setDefault("eclipseBuildInSpellChecker", true);
        pref.setDefault("spellcheckerIgnoreComments", true);
        pref.setDefault("spellcheckerIgnoreMath", false);
        pref.setDefault("spellcheckerIgnoreMixedCase", true);
        pref.setDefault("forceReturnFocusOnInverseSearch", true);
    }
}

