#!/bin/sh
# mktexupd -- update ls-R with a new entry.
# 
# te@informatik.uni-hannover.de and kb@mail.tug.org. Public domain.

version='$Id: mktexupd,v 1.13 1998/02/20 16:22:58 olaf Exp $'
usage="Usage: $0 DIR FILE.
  Update the ls-R file with an entry for FILE in DIR."
mt_min_args=2
mt_max_args=2

# Common code for all scripts.
: ${MT_TEXMFMAIN=`kpsewhich --expand-path='$TEXMFMAIN'`}
: ${MT_MKTEX_OPT=`kpsewhich --format='web2c files' mktex.opt`}
test -n "$MT_MKTEX_OPT" || MT_MKTEX_OPT="$MT_TEXMFMAIN/web2c/mktex.opt"
if test ! -f "$MT_MKTEX_OPT"; then
  echo "$0: Cannot find mktex.opt; check your installation." >&2
  exit 1
fi

. "$MT_MKTEX_OPT"

dir=$1
file=$2
test -d "$dir" || { echo "$0: $dir not a directory." >&2; exit 1; }
test -f "$dir/$file" || { echo "$0: $dir/$file not a file." >&2; exit 1; }

OIFS=$IFS; IFS=$SEP; set x `kpsewhich  -show-path=ls-R`; shift; IFS=$OIFS
TEXMFLS_R=
for d in "$@"; do
  case $dir in
    ${d}*) TEXMFLS_R="$d"; break;;
  esac
done
test -n "$TEXMFLS_R" || exit 0
db_file="$TEXMFLS_R/ls-R"

test -f "$db_file" || mktexlsr "$TEXMFLS_R"
test -w "$db_file" || { echo "$0: $db_file unwritable." >&2; exit 1; }

test "x`sed 1q \"$db_file\"`" = "x$ls_R_magic" \
  || test "x`sed 1q \"$db_file\"`" = "x$old_ls_R_magic" \
  || { echo "$0: $db_file lacks magic string \`$ls_R_magic'." >&2; exit 1; }

# Change `$TEXMFLS_R/' to `./'.
dir=`echo $dir | sed "s%^$TEXMFLS_R/%./%g"`

# May as well always put in a new directory entry; presumably cron will
# come along soon enough and clean things up.
echo "$dir:" >>"$db_file"
echo "$file" >>"$db_file"

exit 0
