/*****

      $Source: d:\gunther\source\grc/RCS/rcutils.h,v $
      $Author: gunther $
      $Date: 1996/01/02 23:17:24 $
      $Revision: 1.3 $

	Changed by: Fred Kiefer (kiefer@isys.de) 1996/6/2

 *****/

#ifndef _RCUTILS_H
#define _RCUTILS_H

#ifdef __cplusplus
extern "C" {
#endif

void *xmalloc(size_t n);

typedef struct _node
{
	struct _node *next;
	union{
		void *data;
		int count;
	} u;
} node;

node *list_new();
void list_add(node *a_list, void *entry);
void list_free(node *a_list, int free_items);

char *strtoupper(char *text);
int expand_string(char *to, char *from);

int int_log2(int colors);
int getIDlength(wchar_t *);

int is_header(const char *);
int is_rcfile(const char *);
int is_resfile(const char *);
char *search_include(char *filename);
int filesize(const char *);
char *basefile(char *path);

extern int _verbose;
extern int _debug;
extern char *program_name;

/*-------------------------------------------
 * macro verbose()
 * print a message in verbose mode
 *-------------------------------------------*/
#define verbose(a)  if(_verbose)     { printf a; printf("\n"); }

#ifndef __GNUC__
#define __FUNCTION__ "undefined"
#endif

/*-------------------------------------------
 * macro debug()
 * print a message in debug mode
 *-------------------------------------------*/
#define debug(a) \
	if(_debug) \
	{ \
		printf("[%s] [%s] [%s] [%d]: ", program_name, \
			__FUNCTION__, basefile(__FILE__), __LINE__); \
		printf a; \
		printf("\n");\
	}

enum
{
    GRC_OK = 0,
    GRC_ERR_OPEN,
    GRC_ERR_READ,
    GRC_ERR_WRITE,
    GRC_ERR_SEEK,
    GRC_ERR_WIN32,
    GRC_ERR_FILENOTFOUND,
    GRC_ERR_MEM,
    GRC_NO_RESOURCE,
    GRC_ERR_SYNTAX,
    GRC_NOT_IMPLEMENTED_YET,
    GRC_ERR_EOF,
    GRC_ERR_INVALIDSTRING,
    GRC_ERR_UNEXPECTED_EOF,
    GRC_ERR_UNDEFINED,
    GRC_ERR_BEGIN_UNEXPECT,
    GRC_ERR_END_UNEXPECT,
    GRC_ERR_NUMBER_EXPECTED,
    GRC_ERR_PARSE,
    GRC_COMPLETE,
    GRC_ERR_CTRL_UNEXPECT,
    GRC_ERR_CTRL_EXPECT,
    GRC_ERR_INVALID_TOKEN,
    GRC_ERR_EXPR,
    GRC_ERR_SUBLANG_EXPECT,
    GRC_ERR_CPP,
    GRC_ERR_INVALID_FILE,
    GRC_err_bmp_filename_expected,
    GRC_err_ico_filename_expected,
    GRC_err_font_filename_expected,
    GRC_err_dlg_invalid,
    GRC_err_invalid_stmnt,
    GRC_err_dlg_ctl_expected,
    GRC_err_menu_invalid,
    GRC_err_menuitem_invalid,
    GRC_err_strtable_invalid,
    GRC_err_string_invalid,
    GRC_err_invalid_accelerator,
    GRC_err_one_char,
    GRC_err_invalid_icon_file,
    GRC_err_invalid_cursor_file,
    GRC_err_nomem,
    GRC_err_unicode_ansi_conversion,
    GRC_err_ansi_unicode_conversion,
	GRC_err_invalid_userres,
	GRC_err_invalid_rcdata,
	GRC_err_invalid_versioninfo,
	GRC_ERR_UNKNOWN
};

#define GRC_ERR_FATAL 0x8000

void err_msg(int);
char *getErrorText(int);
void open_error(const char *);
void read_error(const char *);
void write_error(const char *);
void seek_error(const char *);

#ifdef __cplusplus
}
#endif

#endif

