/*
 * Decompiled with CFR 0.152.
 */
package nts.base;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import nts.base.PairKey;

public class ClassAssoc
implements Serializable {
    private Class root;
    private HashMap matrix;
    private Vector list = new Vector(10);

    public Class getRoot() {
        return this.root;
    }

    public boolean recorded(Class cls) {
        return this.list.contains(cls);
    }

    private void check(Class cls) {
        if (!this.root.isAssignableFrom(cls)) {
            throw new RuntimeException(cls + "is not a " + this.root);
        }
        if (this.list.contains(cls)) {
            throw new RuntimeException(cls + " already registered");
        }
    }

    public void record(Class cls) {
        this.check(cls);
        if (!this.list.isEmpty()) {
            Class sup = cls.getSuperclass();
            if (!this.list.contains(sup)) {
                throw new RuntimeException("Super class (" + sup + ")  of " + cls + " not registered");
            }
            Set keySet = this.matrix.keySet();
            PairKey[] inheritedKeys = new PairKey[keySet.size()];
            Object[] inheritedVals = new Object[keySet.size()];
            int index = 0;
            Iterator keys = keySet.iterator();
            while (keys.hasNext()) {
                PairKey key;
                PairKey curr = (PairKey)keys.next();
                if (!curr.first.equals(sup) || this.matrix.containsKey(key = new PairKey(cls, curr.second))) continue;
                inheritedKeys[index] = key;
                inheritedVals[index] = this.matrix.get(curr);
                ++index;
            }
            while (--index >= 0) {
                this.matrix.put(inheritedKeys[index], inheritedVals[index]);
            }
        }
        this.list.addElement(cls);
    }

    public final void put(Class cls, Object key, Object val) {
        this.check(cls);
        this.matrix.put(new PairKey(cls, key), val);
    }

    public final Object get(Class cls, Object key) {
        return this.matrix.get(new PairKey(cls, key));
    }

    public ClassAssoc(Class root, int initialSize, float loadFactor) {
        this.root = root;
        this.matrix = new HashMap(initialSize, loadFactor);
    }

    public ClassAssoc(Class root) {
        this(root, 1009, 0.5f);
    }
}

