/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import nts.base.Dimen;
import nts.io.CntxLog;
import nts.io.Log;
import nts.node.AnyBoxedNode;
import nts.node.Box;
import nts.node.BoxSizes;
import nts.node.GlueSetting;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.SettingContext;
import nts.node.TypeSetter;

public abstract class AnyBoxNode
extends AnyBoxedNode
implements Box {
    protected final GlueSetting setting;
    protected NodeList list;

    public GlueSetting getSetting() {
        return this.setting;
    }

    public NodeList getList() {
        return this.list;
    }

    public boolean isVoid() {
        return false;
    }

    public boolean isHBox() {
        return false;
    }

    public boolean isVBox() {
        return false;
    }

    public NodeEnum getHorizList() {
        return this.isHBox() ? this.list.nodes() : null;
    }

    public NodeEnum getVertList() {
        return this.isVBox() ? this.list.nodes() : null;
    }

    public boolean isBox() {
        return true;
    }

    public Box getBox() {
        return this;
    }

    public boolean isCleanBox() {
        return true;
    }

    public boolean canBePartOfDiscretionary() {
        return true;
    }

    protected boolean allegedlyVisible() {
        return true;
    }

    public Box pretendingWidth(Dimen width) {
        return this.getWidth().equals(width) ? this : this.pretendSizesCopy(this.sizes.withWidth(width));
    }

    public void typeSet(TypeSetter setter) {
        this.typeSet(setter, true);
    }

    public void typeSet(TypeSetter setter, SettingContext sctx) {
        if (!this.list.isEmpty()) {
            setter.push();
            this.typeSet(setter, sctx.allowIO);
            setter.pop();
        }
    }

    private void typeSet(TypeSetter setter, boolean allowIO) {
        TypeSetter.Mark here = setter.mark();
        NodeEnum nodes = this.list.nodes();
        this.moveStart(setter);
        SettingContext sctx = new SettingContext(this.sizes, this.setting, setter.mark(), allowIO);
        while (nodes.hasMoreNodes()) {
            Node node = nodes.nextNode();
            this.movePrev(setter, node);
            node.typeSet(setter, sctx);
            this.movePast(setter, node);
        }
        here.move();
    }

    public void syncVertIfBox(TypeSetter setter) {
        if (!this.list.isEmpty()) {
            setter.syncVert();
        }
    }

    protected abstract void moveStart(TypeSetter var1);

    protected abstract void movePrev(TypeSetter var1, Node var2);

    protected abstract void movePast(TypeSetter var1, Node var2);

    public void addOn(Log log, CntxLog cntx, Dimen shift) {
        log.addEsc(this.getDesc()).add(this.sizes).add(this.setting);
        if (shift != null && !shift.isZero()) {
            log.add(", shifted ").add(shift.toString());
        }
        cntx.addOn(log, this.list.nodes());
    }

    public void addOn(Log log, CntxLog cntx) {
        this.addOn(log, cntx, null);
    }

    public void addOn(Log log, int maxDepth, int maxCount) {
        CntxLog.addItem(log, this, maxDepth, maxCount);
    }

    public void addListShortlyOn(Log log) {
        this.list.addShortlyOn(log);
    }

    public abstract String getDesc();

    public Node reboxedToWidth(Dimen width) {
        return this.list.isEmpty() ? this.pretendingWidth(width) : super.reboxedToWidth(width);
    }

    public abstract Box pretendSizesCopy(BoxSizes var1);

    public AnyBoxNode(BoxSizes sizes, GlueSetting setting, NodeList list) {
        super(sizes);
        this.setting = setting;
        this.list = list;
    }
}

