/*
 * Decompiled with CFR 0.152.
 */
package nts.tfm;

import java.util.Vector;
import nts.tfm.IndexMultimap;

public class IndexMultimap {
    private Vector data = new Vector();

    protected final int size() {
        return this.data.size();
    }

    protected final Pair at(int i) {
        return (Pair)this.data.elementAt(i);
    }

    protected final void insert(Pair p, int i) {
        this.data.insertElementAt(p, i);
    }

    protected final int search(int key) {
        int beg = 0;
        int end = this.size();
        while (beg < end) {
            int med = (beg + end) / 2;
            Pair p = this.at(med);
            if (key < p.key) {
                end = med;
                continue;
            }
            if (key > p.key) {
                beg = med + 1;
                continue;
            }
            return med;
        }
        return beg;
    }

    public void add(int key, int val) {
        Vector vector = this.data;
        synchronized (vector) {
            int pos = this.search(key);
            while (pos < this.size() && this.at((int)pos).key == key) {
                ++pos;
            }
            this.insert(new Pair(key, val), pos);
        }
    }

    public Enum forKey(int key) {
        IndexMultimap indexMultimap = this;
        if (indexMultimap == null) {
            throw null;
        }
        return indexMultimap.new Enum(null, key);
    }

    protected static class Pair {
        int key;
        int val;

        Pair(int k, int v) {
            this.key = k;
            this.val = v;
        }
    }

    public class Enum {
        private int pos;
        private final int key;

        public final boolean hasMore() {
            return this.pos < IndexMultimap.this.size() && IndexMultimap.this.at((int)this.pos).key == this.key;
        }

        public final int next() {
            return IndexMultimap.this.at((int)this.pos++).val;
        }

        private Enum(int k) {
            Vector vector = IndexMultimap.this.data;
            synchronized (vector) {
                this.key = k;
                this.pos = IndexMultimap.this.search(this.key);
                while (this.pos > 0 && IndexMultimap.this.at((int)(this.pos - 1)).key == this.key) {
                    --this.pos;
                }
            }
        }

        /* synthetic */ Enum(1 var2_2, int n) {
            this(n);
        }
    }
}

