/*********************************************/
/*   this is texfed.e 2000-04-19 (WaS)       */
/*                                           */
/*   the keysets for texfe.e v3.0            */
/*********************************************/

compile if TEXCOMPL =1 

/*
Ŀ
  Define the action for the spacebar                                        
    The spacebar initiates the expansion of keywords                        

*/
  compile if EVERSION >= 5
    def space=
  compile else
    def ' '=
  compile endif

-- Note: expand_on is set dynamically by user to turn on syntax assist in EPM
  universal expand_on
  if expand_on then
    if not tex_first_expansion() then  -- search for keywords and expand 
      keyin ' '  -- default to a space if unable to expand word
    endif
  else
    keyin ' '  -- default is just a space with syntax assist disabled
  endif

  compile if EVERSION >= '5.20'
    undoaction 1, junk                -- Create a new state
  compile endif

/*
Ŀ
  Define the action for the enter (or ctrl-enter) key                       
    The enter key terminates the expansion of a keyword started with        
    the spacebar.                                                           

*/
-- global ASSIST_TRIGGER defines the key that starts syntax assist
  compile if not defined (ASSIST_TRIGGER)
    const ASSIST_TRIGGER = 'ENTER'  -- enter key is the default trigger
  compile endif

  compile if ASSIST_TRIGGER = 'ENTER'
    def enter=
    compile if ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''
      universal enterkey
    compile endif
  compile else
    def c_enter=
    compile if ENHANCED_ENTER_KEYS & c_ENTER_ACTION <> ''
      universal c_enterkey
    compile endif
  compile endif

  universal expand_on
  compile if EVERSION >= 5
    if expand_on then
  compile else
    if expand_on & not command_state() then
  compile endif -- EVERSION >= 5
    compile if EVERSION <= '4.12'
      if tex_second_expansion() then
        call maybe_autosave()
      else
    compile else
      if not tex_second_expansion() then  -- call the expansion procedure
    compile endif  -- EVERSION <= 4.12       and if no expansion possible then...
    compile if ASSIST_TRIGGER = 'ENTER'
      compile if ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''
        call enter_common(enterkey)
      compile else
        call my_enter()
      compile endif
    compile else  -- ASSIST_TRIGGER
      compile if ENHANCED_ENTER_KEYS & c_ENTER_ACTION <> ''
        call enter_common(c_enterkey)
      compile else
        call my_c_enter()
      compile endif
    compile endif -- ASSIST_TRIGGER
      endif  -- not tex_second_expansion
 
    else  -- expand_on is off so enter does default actions only
    compile if ASSIST_TRIGGER = 'ENTER'
      compile if ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''
        call enter_common(enterkey)
      compile else
        call my_enter()
      compile endif
    compile else  -- ASSIST_TRIGGER
      compile if ENHANCED_ENTER_KEYS & c_ENTER_ACTION <> ''
        call enter_common(c_enterkey)
      compile else
        call my_c_enter()
      compile endif
    compile endif -- ASSIST_TRIGGER
    endif  -- expand_on

    def c_x=       /* Force expansion if we don't have it turned on automatic */
        if not tex_first_expansion() then
          call tex_second_expansion()
        endif

/*******************************/
/*                             */
/* the accelerator keys        */
/* (changed v2.2)              */
/*******************************/

 compile if TEXACCEL

    def '{'=
       keyin '{}'
       .col = .col - 1

    def '$'=
       keyin '$$'
       .col = .col - 1

    def a_a=
       keyin 'eqnarray'

    def a_b =
       keyin '\begin{}'
       .col = .col - 1

    def a_c =
       keyin '\cite{}'
       .col = .col - 1

    def a_d=
       keyin 'description'

    def a_e = 
       keyin 'equation'

    def a_f =
       keyin '\frac{}{}'
       .col = .col - 3

    def a_h = 
       keyin '\hspace*{}'
       .col=.col - 1

    def a_i =
       keyin '\item'

    def a_j = 
       keyin 'itemize'

    def a_k = 
       keyin 'tabular'

    def a_l =
       keyin '\label{}'
       .col = .col - 1

    def a_m =
       keyin '\mbox{}'
       .col = .col - 1

    def a_n = 
       keyin 'enumerate'

    def a_q =
       keyin 'equation'

    def a_r=
       keyin '\ref{}'
       .col = .col - 1

    def a_s = 
       keyin '\sqrt{}'
       .col = .col - 1

    def a_v=
       keyin '\vspace*{}'
       .col = .col - 1
 
    def a_w = 
       keyin 'verbatim'
 
 compile endif /* TEXACCEL */


compile endif /* TEXCOMPL */

/* Finis */
