/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		bad_char_set.lex
dates:      16 June 2003
Purpose:	bad char characters
Note:		
  The reason to be explicit on the bad characters is 
  performance: First set of thread is specific on each terminal
  and not general using |+| with filter logic.
Returned:	Err_bad_char
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |bad_char_set| Thread.\fbreak
|bad_char_set| recognizes characters in the range of
0 .. 8, 14..31, 127 .. 255. This is my take at the momment
on bad dudes.
The terminal literal is a variant on the hex sequence
without the escape part. This is just to reference 
and display it rather than deal with its
 binary representation and purpose.
 
|bad_char_set| is just a single character 
recognizer ie its first set.
This thread can be removed from the thread stable giving
the complete character range to play with across your grammars. 
The raw character terminals defines them.
The breaking up into a character range per rule allows
the drawings to be contained per print page.
This is a little more estheque than a hanging ladder of 
subrules exceeding the bottom part of the sheet.
@/
fsm	
(fsm-id "bad_char_set.lex",fsm-filename bad_char_set,fsm-namespace NS_bad_char_set
,fsm-class Cbad_char_set,fsm-version "1.0",fsm-date "16 Juin 2003",fsm-debug "false"	
,fsm-comments	"Bad source character set recognizer.")
parallel-parser	
( parallel-thread-function
    TH_bad_char_set
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"
rules{
Rbad_char_set  (
lhs{
  op
    CAbs_lr1_sym* sym = new Err_bad_char(rule_info__.parser__->start_token__);
    sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
    RSVP(sym); 
  ***
  }
){	
	-> Rbad_char_00_0f
	-> Rbad_char_10_7f
	-> Rbad_char_80_8f
	-> Rbad_char_90_9f
	-> Rbad_char_a0_af
	-> Rbad_char_b0_bf
	-> Rbad_char_c0_cf
	-> Rbad_char_d0_df
	-> Rbad_char_e0_ef
	-> Rbad_char_f0_ff
}

Rbad_char_00_0f  (){	
	-> "x00"  -> "x01" -> "x02" -> "x03" -> "x04" -> "x05" -> "x06" -> "x07" 	 
	-> "x08" 	 	
	-> "x0e" -> "x0f" 	
}

Rbad_char_10_7f  (){	
	-> "x10" -> "x11" -> "x12" -> "x13" -> "x14" -> "x15" -> "x16" -> "x17"  	 
	-> "x18" -> "x19"	-> "x1a" -> "x1b" -> "x1c" -> "x1d" -> "x1e" -> "x1f" 
	-> "x7f" 	 
}

Rbad_char_80_8f  (){	
	-> "x80" -> "x81" -> "x82" -> "x83" -> "x84" -> "x85" -> "x86" -> "x87"
	-> "x88" -> "x89" -> "x8a" -> "x8b" -> "x8c" -> "x8d" -> "x8e" -> "x8f" 
}

Rbad_char_90_9f  (){	
	-> "x90" -> "x91" -> "x92" -> "x93" -> "x94" -> "x95" -> "x96" -> "x97"
	-> "x98" -> "x99" -> "x9a" -> "x9b" -> "x9c" -> "x9d" -> "x9e" -> "x9f" 
}

Rbad_char_a0_af  (){	
	-> "xa0" -> "xa1" -> "xa2" -> "xa3" -> "xa4" -> "xa5" -> "xa6" -> "xa7" 
	-> "xa8" -> "xa9" -> "xaa" -> "xab" -> "xac" -> "xad" -> "xae" -> "xaf" 
}

Rbad_char_b0_bf  (){	
	-> "xb0" -> "xb1" -> "xb2" -> "xb3" -> "xb4" -> "xb5" -> "xb6" -> "xb7" 
	-> "xb8" -> "xb9" -> "xba" -> "xbb" -> "xbc" -> "xbd" -> "xbe" -> "xbf" 
}

Rbad_char_c0_cf  (){	
	-> "xc0" -> "xc1" -> "xc2" -> "xc3" -> "xc4" -> "xc5" -> "xc6" -> "xc7" 
	-> "xc8" -> "xc9" -> "xca" -> "xcb" -> "xcc" -> "xcd" -> "xce" -> "xcf" 
}

Rbad_char_d0_df  (){	
	-> "xd0" -> "xd1" -> "xd2" -> "xd3" -> "xd4" -> "xd5" -> "xd6" -> "xd7" 
	-> "xd8" -> "xd9" -> "xda" -> "xdb" -> "xdc" -> "xdd" -> "xde" -> "xdf" 
}

Rbad_char_e0_ef  (){	
	-> "xe0" -> "xe1" -> "xe2" -> "xe3" -> "xe4" -> "xe5" -> "xe6" -> "xe7" 
	-> "xe8" -> "xe9" -> "xea" -> "xeb" -> "xec" -> "xed" -> "xee" -> "xef" 
}

Rbad_char_f0_ff  (){	
	-> "xf0" -> "xf1" -> "xf2" -> "xf3" -> "xf4" -> "xf5" -> "xf6" -> "xf7" 
	-> "xf8" -> "xf9" -> "xfa" -> "xfb" -> "xfc" -> "xfd" -> "xfe" -> "xff" 
}
}// end of rules
