/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  rule_lhs_phrase.lex
Dates:		  3 Jun 2004
Purpose:	  parse rule's lhs construct
Output:       T_rule_lhs_phrase
              assorted errors
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |rule_lhs_phrase| Thread.\fbreak
Parse rule's lhs construct.\fbreak
\fbreak
Example of a rule's lhs to parse:\fbreak
\listing{"/usr/local/yacco2/diagrams+etc/rulelhs.txt"}
This thread is a ``chained procedure call''.
@/
fsm	
(fsm-id "rule_lhs_phrase.lex"
,fsm-filename rule_lhs_phrase
,fsm-namespace NS_rule_lhs_phrase
,fsm-class Crule_lhs_phrase{
  user-prefix-declaration
    using namespace NS_yacco2_terminals;
#include "lint_balls.h"
#include "cweb_or_c_k.h"

#include "identifier.h"
#include "c_string.h"
#include "o2_sdc.h"
  ***
  user-declaration
    public:
    void add_sdc_to_directive(yacco2::CAbs_lr1_sym* Dir,T_syntax_code* Sdc);
    T_rule_lhs_phrase* rule_lhs_phrase_;
  ***
  user-implementation
    void Crule_lhs_phrase::
    add_sdc_to_directive(yacco2::CAbs_lr1_sym* Dir,T_syntax_code* Sdc){
      using namespace NS_yacco2_T_enum;
      using namespace NS_yacco2_terminals;
      yacco2::INT eid = Dir->enumerated_id__;
      switch (eid){
		case T_Enum::T_T_user_declaration_: {
		  T_user_declaration* k = (T_user_declaration*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_constructor_: {
		  T_constructor* k = (T_constructor*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_destructor_: {
		  T_destructor* k = (T_destructor*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_op_: {
		  T_op* k = (T_op*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_user_implementation_: {
		  T_user_implementation* k = (T_user_implementation*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		default: {
          CAbs_lr1_sym* sym = new Err_improper_directive;
          sym->set_rc(*Dir,__FILE__,__LINE__);
          RSVP_FSM(sym);
          parser__->set_stop_parse(true);
          return;
   		}      
      }
      rule_lhs_phrase_->add_directive_to_lhs(Dir,parser__);        
    }
  ***
  op
    if(rule_lhs_phrase_ != 0){
      delete rule_lhs_phrase_;
      rule_lhs_phrase_ = 0;
    }
    rule_lhs_phrase_ = new T_rule_lhs_phrase;
    rule_lhs_phrase_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
    AST* t = new AST(*rule_lhs_phrase_);
    rule_lhs_phrase_->phrase_tree(t);
  ***
  constructor
    rule_lhs_phrase_ = 0;
  ***
}
,fsm-version "1.0",fsm-date "24 mar 2004",fsm-debug "false"
,fsm-comments "Parse a rule's ``lhs'' directive.")
parallel-parser	
(	
  parallel-thread-function
    TH_rule_lhs_phrase
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rrule_lhs_phrase  (){
  -> "#lhs"
  Rlint Rpotential_directives  Rlint {
    op
      Crule_lhs_phrase* fsm = (Crule_lhs_phrase*)rule_info__.parser__->fsm_tbl__;
      RSVP(fsm->rule_lhs_phrase_);
      fsm->rule_lhs_phrase_ = 0;
    ***
    }	
}

Rlhs  (){
  ->  ||| "#lhs" NS_identifier::TH_identifier
  -> ||| |?| NULL{
    op 
      rule_info__.parser__->set_abort_parse(true);       
    ***
    }
}

Rpotential_directives  (){
  ->  |.| // no syntax code: end of subsule
  ->  "{" Rlint Rmust_directive_phrase Rmaybe_more_directives Rclose_brace Rlint
}

Rmust_directive_phrase  (){ 
  ->  Rdirective_cweb_k Rlint Rmust_directive Rsyntax_code Rlint {
    op
      AST* cwebt = sf->p1__->cweb_t_;
      Rmust_directive* dir = sf->p3__;
      Rsyntax_code* sdc = sf->p4__;
      if(cwebt != 0)
        sdc->syntax_code_->add_cweb_marker(cwebt);
      Crule_lhs_phrase* fsm = (Crule_lhs_phrase*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
}

Rmust_directive  (
lhs {
  user-declaration
    CAbs_lr1_sym* directive_;
  ***
  constructor
    directive_ = 0;
  ***
 } 
){ 
  ->  ||| "#user-declaration" NS_identifier::TH_identifier { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-implementation" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#constructor" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#destructor" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#op" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  -> ||| |?| NULL { 
      op
		directive_ = 0;
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_bad_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_directive_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
}

Rclose_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_brace;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "}"
}

Rmaybe_more_directives  (){ 
  ->   
  ->  Rmaybe_directive_phrases 
}

Rmaybe_directive_phrases  (){ 
  ->  Rmaybe_directive_phrase 
  ->  Rmaybe_directive_phrases Rmaybe_directive_phrase 
}

Rmaybe_directive_phrase  (){ 
  ->  Rcweb_k Rlint Rdirective Rsyntax_code Rlint {
    op
      AST* cwebt = sf->p1__->cweb_t_;
      Rdirective* dir = sf->p3__;
      Rsyntax_code* sdc = sf->p4__;
      if(cwebt != 0)
        sdc->syntax_code_->add_cweb_marker(cwebt);
      Crule_lhs_phrase* fsm = (Crule_lhs_phrase*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
  ->  Rdirective Rsyntax_code Rlint {
    op
      Rdirective* dir = sf->p1__;
      Rsyntax_code* sdc = sf->p2__;
      Crule_lhs_phrase* fsm = (Crule_lhs_phrase*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
}

Rdirective_phrase  (){ 
  ->  Rcweb_k Rlint Rdirective Rsyntax_code Rlint {
    op
      AST* cwebt = sf->p1__->cweb_t_;
      Rdirective* dir = sf->p3__;
      Rsyntax_code* sdc = sf->p4__;
      if(cwebt != 0)
        sdc->syntax_code_->add_cweb_marker(cwebt);
      Crule_lhs_phrase* fsm = (Crule_lhs_phrase*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
}


Rdirective  (
lhs {
  user-declaration
    CAbs_lr1_sym* directive_;
  ***
  constructor
    directive_ = 0;
  ***
 } 
){ 
  ->  ||| "#user-declaration" NS_identifier::TH_identifier { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-implementation" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#constructor" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#destructor" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#op" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  -> ||| |?| NULL { 
      op
		directive_ = 0;
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_bad_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}


Rsyntax_code  (
lhs {
  user-declaration
    T_syntax_code* syntax_code_;
  ***
	constructor
	  syntax_code_ = 0;
	***
 } 
){
  -> ||| "syntax-code" NS_o2_sdc::TH_o2_sdc {
      op
        syntax_code_ = sf->p2__;
      ***
      }
  -> ||| |?| NULL { // catcher in the Rye? These are errors
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  -> 
}

Rcweb_marker  (
lhs {
   user-declaration
     AST* cweb_t_;
   ***
   constructor
     cweb_t_ = 0;
   ***
}
){
 ->  ||| "cweb-comment" NS_cweb_or_c_k::TH_cweb_or_c_k {
    op
        T_cweb_comment* k = sf->p2__;
        AST* cwebk_t_ = new AST(*k);
        cweb_t_ = new AST();
        T_cweb_marker* cw = new T_cweb_marker(cweb_t_);
        cw->set_rc(*k,__FILE__,__LINE__);
      AST::set_content(*cweb_t_,*cw);
        AST::join_pts(*cweb_t_,*cwebk_t_);

    ***
    }
}

Rdirective_cweb_k  (
lhs {
	user-declaration
	  AST* cweb_t_;
	***
	constructor
	  cweb_t_ = 0;
	***
	}
){
  -> 
  ->  ||| "cweb-comment" NS_cweb_or_c_k::TH_cweb_or_c_k {
	op
        T_cweb_comment* k = sf->p2__;
        AST* cwebk_t_ = new AST(*k);
        cweb_t_ = new AST();
        T_cweb_marker* cw = new T_cweb_marker(cweb_t_);
        cw->set_rc(*k,__FILE__,__LINE__);
      AST::set_content(*cweb_t_,*cw);
        AST::join_pts(*cweb_t_,*cwebk_t_);

	***
	}
  ->  ||| "comment-overrun" NULL {
      op 
		RSVP(sf->p2__);
		rule_info__.parser__->set_stop_parse(true); 
      ***
      }      
}

Rcweb_k  (
lhs {
	user-declaration
	  AST* cweb_t_;
	***
	constructor
	  cweb_t_ = 0;
	***
	}
){
 ->  ||| "cweb-comment" NS_cweb_or_c_k::TH_cweb_or_c_k {
	op
        T_cweb_comment* k = sf->p2__;
        AST* cwebk_t_ = new AST(*k);
        cweb_t_ = new AST();
        T_cweb_marker* cw = new T_cweb_marker(cweb_t_);
        cw->set_rc(*k,__FILE__,__LINE__);
      AST::set_content(*cweb_t_,*cw);
        AST::join_pts(*cweb_t_,*cwebk_t_);
	***
	}
  ->  ||| "comment-overrun" NULL {
      op 
		RSVP(sf->p2__);
		rule_info__.parser__->set_stop_parse(true); 
      ***
      }     
}

}// end of rules
