/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:    test_components.lex
dates:   7 Juin 2003	
Purpose: Tester of component grammars in Lexical Phase
	    works with the simple testdriver.cpp program in /usr/local/yacco2/testdriver
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** Testdriver.\fbreak
It tests out the lexical parts to \o2.
The |testdriver| is just a lexical caller to
various threaded grammars that handle the lexical portion of \o2.
The test files that feed it are concocted test data
to exercise strings and things...
These data files reside in /usr/local/yacco2/qa/*dat.
Examples of test data file flavours testing are t0.bat and t1.bat.
@/
fsm	
(fsm-id "test_components.lex",fsm-filename test_components,fsm-namespace NS_test_components
,fsm-class Ctest_components{
  user-prefix-declaration
#include "angled_string.h"
#include "bad_char_set.h"
#include "c_comments.h"
#include "c_literal.h"
#include "c_string.h"
#include "dbl_colon.h"
#include "eol.h"
#include "esc_seq.h"
#include "identifier.h"
#include "int_no.h"
#include "linker_id.h"
#include "unq_str.h"
#include "ws.h"
#include "o2_externs.h"
#include "o2_code_end.h"
  ***
  }
,fsm-version	"1.0",fsm-date "17 Apr 2001",fsm-debug "true"
,fsm-comments	"Tester: lexical stage constructing tokens for syntax parser.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rpass3  (
lhs{
  op
    using namespace NS_yacco2_k_symbols;
    ADD_TOKEN_TO_PRODUCER_QUEUE(*yacco2::PTR_LR1_eog__);   
    ADD_TOKEN_TO_PRODUCER_QUEUE(*yacco2::PTR_LR1_eog__);  
  ***
  }
){
  -> eog 
  -> Relems eog
}

Relems  (){
  -> Rtoken
  -> Relems Rtoken
}

Rtoken () {
  -> Rtoken_grp1
  -> Rtoken_grp2
  -> Rtoken_grp3
  -> Rtoken_grp4
  -> Rtoken_grp5
}

Rtoken_grp1(
//lhs,
parallel-control-monitor{
/@
unquoted-string supersets identifier if it is longer in size
and also includes other Tes like $-$$\>$ and cweb comments ie ``cweb-marker''.
The arbitration code walks the ``accept-queue'' recording the T's position and length.
Then it chooses the T to return by its length.
@/
  arbitrator-code
	using namespace NS_yacco2_T_enum;
 int kw_id(0);
 int kw_id_len(0);
 int unstr(0);
 int unstr_len(0);
   for(i=1;i<=ie;++i){
     switch(Caller_pp->pp_accept_queue__[i].accept_token__->enumerated_id__){
      case T_Enum::T_T_unquoted_string_:{
         unstr=i;
        T_unquoted_string* unq = 
         (T_unquoted_string*)Caller_pp->pp_accept_queue__[i].accept_token__;
        unstr_len = unq->unquoted_string()->size(); 
        continue;     
      }
      case T_Enum::T_T_identifier_:{
         kw_id=i;
        T_identifier* id = (T_identifier*)Caller_pp->pp_accept_queue__[i].accept_token__;
        kw_id_len = id->identifier()->size(); 
        continue;     
      }
      default:{
        kw_id=i;
        kw_id_len = 4048;//fake it: too many kws so make it longest 
        continue;     
      }

     }
   }
   // out of for loop
   if(unstr_len > kw_id_len){
    i = unstr;
    goto arbitrated_parameter;
   }else{
    i = kw_id;
    goto arbitrated_parameter;
	  }
  ***
  }

){
  -> ||| "#***"	NS_o2_code_end::TH_o2_code_end{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "angled-string"	NS_angled_string::TH_angled_string{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "bad char"	NS_bad_char_set::TH_bad_char_set{
    op
      ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "comment" NS_c_comments::TH_c_comments {
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "c-literal"	NS_c_literal::TH_c_literal{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***			
    } 
  -> ||| "c-string"	NS_c_string::TH_c_string{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***			
    } 
  -> ||| "::"	NS_dbl_colon::TH_dbl_colon{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***			
    } 
  -> ||| eol	NS_eol::TH_eol{
    op // token stream marker
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "esc-seq"	NS_esc_seq::TH_esc_seq{
    op // token stream marker
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "identifier"	NS_identifier::TH_identifier{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "int-no"	NS_int_no::TH_int_no{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| ws	NS_ws::TH_ws{
    op 
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "unquoted-string"	NS_unq_str::TH_unq_str{
    op 
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| |?| NULL{
    op
      ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
      rule_info__.parser__->set_abort_parse(true);      
    ***
    }
}

Rtoken_grp2  (){
  -> ||| "bad eos"	NULL { // 
    op
      ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
      rule_info__.parser__->set_abort_parse(true);
    ***			
    } 
  -> ||| "comment-overrun"	NULL{
    op
      ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
      rule_info__.parser__->set_abort_parse(true);
    ***			
    } 
  -> ||| "bad esc"	NULL{
    op
      ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
      rule_info__.parser__->set_abort_parse(true);
    ***			
    } 
  -> ||| "#fsm"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#fsm-id"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#fsm-filename"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#fsm-namespace"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#fsm-class"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#fsm-version"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#fsm-date"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#fsm-debug"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#fsm-comments"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
}

Rtoken_grp3  (){
  -> ||| "#raw-characters"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#lr1-constant-symbols"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#error-symbols"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#AD"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#AB"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#parallel-parser"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#parallel-la-boundary"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#parallel-thread-function"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#parallel-control-monitor"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#terminals"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#T-enumeration"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#file-name"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#name-space"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#sym-class"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
}

Rtoken_grp4  (){
  -> ||| "#rules"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#lhs"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#user-declaration"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#user-prefix-declaration"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#user-suffix-declaration"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#constructor"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#destructor"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#op"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#user-implementation"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#user-imp-tbl"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#user-imp-sym"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#constant-defs"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#terminals-refs"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#terminals-sufx"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#lrk-sufx"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
}

Rtoken_grp5  (){
  -> ||| "#arbitrator-code"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#NULL"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "#failed"	NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> |+|{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p1__);
    ***
    }
}
}// end of rules
