@q file: o2linker_externs.w@>
@q%   Copyright Dave Bone 1998 - 2015@>
@q% /*@>
@q%    This Source Code Form is subject to the terms of the Mozilla Public@>
@q%    License, v. 2.0. If a copy of the MPL was not distributed with this@>
@q%    file, You can obtain one at http://mozilla.org/MPL/2.0/.@>
@q% */@>
@q% This file is part of YACC02 compiler/compiler project.@>

\input "eplain"
\input "supp-pdf"
\input "/usr/local/yacco2/diagrams/o2mac.tex"
%\tracingall=1
%\tracingall=1
%\tracingmacros=1
%\tracingcommands=2
@i "/usr/local/yacco2/license.w"
@** Summary Linker External parse routines.\fbreak
These are the various procedures that parse \Yacco2's grammar language
and emit the grammar's c++ code 
and tex document with mpost generated diagrams.
Each language construct has its appropriate external procedure that houses
the monolithic grammar to start the parse.
There is no namespace used to contain these routines as I felt that this was overkill.
As this is a closed system, their grammars are not universal and 
cannot be re-cycled for others.
Their only outside value are in teaching examples on ``how to skin a cat'' or is it
``how to parse a lion?''...

External routines ratatouille:\fbreak
\ptindent{|o2linker_externs.w| - cweb generator file}
\ptindent{|o2linker_externs.h| - header file}
\ptindent{|o2linker_externs.cpp| - implementation}

Dependency files from other Yacco2 sub-systems:\fbreak
\ptindent{|yacco2.h| - basic definitions used by Yacco2}
\ptindent{|yacco2_T_enumeration.h| - terminal enumeration for Yacco2's terminal grammar alphabet}
\ptindent{|yacco2_err_symbols.h| - error terminal definitions from Yacco2's grammar alphabet}
\ptindent{|yacco2_characters.h| - raw character definitions from Yacco2's grammar alphabet}
\ptindent{|yacco2_k_symbols.h| - constant meta terminal defs from Yacco2's grammar alphabet}
\ptindent{|yacco2_terminals.h| - regular terminal definitions from Yacco2's grammar alphabet}
\ptindent{|*.h| - assorted grammar definitions for Yacco2's parsing}
\ptindent{|yacco2_stbl.h| - symbol table defnitions}

External procedures and other globals:\fbreak
\ptindent{|LINKER_PARSE_CMD_LINE|}  

@** Global definitions, External parse routines for Yacco2.\fbreak
\def\ptindent#1{\line{\hskip.5in{#1}\hfill}}
\def\fbreak{\hfill\break}
\def\wildcard{$\vert$+$\vert$}
\def\parallelop{$\vert\vert\vert$}

@ Create header file.
@(o2linker_externs.h@>=
#ifndef o2linker_externs_
#define o2linker_externs_ 1
@h
@<Files for header@>;
#endif

@*2 Files for header.
@<Files for header@>=
#include "globals.h"
#include "o2linker_types.h"
#include "yacco2_stbl.h"
#include "o2_linker_opts.h"
#include "linker_pass3.h"

extern STBL_T_ITEMS_type STBL_T_ITEMS;
extern   void GET_CMD_LINE(int argc, char* argv[]
                           ,const char* File,yacco2::TOKEN_GAGGLE& Errors);
extern void LINKER_PARSE_CMD_LINE(const char* Fsc
                         ,std::string& Cntl_file,yacco2::TOKEN_GAGGLE& Errors);
extern   void DUMP_ERROR_QUEUE(yacco2::TOKEN_GAGGLE&  Errors);
extern const char* DATE_AND_TIME();
extern void XLATE_SYMBOLS_FOR_cweave(const char* Sym_to_xlate,char* Xlated_sym);
extern yacco2::AST*CWEB_MARKER;
@ Include Header file.
@<Include Header file@>=
#include "o2linker_externs.h"
@ Yacco2 external routines blueprint. Output of the code.
@(o2linker_externs.cpp@>= 
@<Include Header file@>;
@<accrue source for emit@>;


@ Accrue source for emit.
@<accrue source for emit@>=

yacco2::AST*CWEB_MARKER(0);

@** Local o2linker routines.\fbreak


@*2 Linker Parse command line: |LINKER_PARSE_CMD_LINE|.\fbreak
The parameters have been extracted from the program
run environment and placed into Linker's holding file.
The routine is suitable for public consumption if
a filename parameter is needed. 


Constraints:\fbreak
 \ptindent{ip1: Linker's holding file containing the command line to compile}
 \ptindent{ip2: Extracted fsc file to compile}
 \ptindent{ip3: Error container for generated errors}

Errors:\fbreak
\ptindent{1) bad filename}
\ptindent{2) parameters errors}

@<accrue source for emit@>+=
extern 
void 
LINKER_PARSE_CMD_LINE@/
      (const char* Cmd_file,std::string& Ctrl_file,yacco2::TOKEN_GAGGLE& Errors)@/
{
  using namespace NS_yacco2_err_symbols;
  using namespace yacco2;
  tok_can<std::ifstream> Cmd1_tokens(Cmd_file);
  if(Cmd1_tokens.file_ok() == NO){
      yacco2::Delete_tokens(Cmd1_tokens.container());
	  CAbs_lr1_sym* sym = new Err_bad_filename(Cmd_file);
	  sym->set_external_file_id(1);
	  sym->set_line_no(1);
	  sym->set_pos_in_line(1);
	  Errors.push_back(*sym);
	  return;
  }
  
  using namespace NS_o2_linker_opts;
  TOKEN_GAGGLE linker_options_tokens;
  Co2_linker_opts opts_fsm;
  Parser options(opts_fsm,&Cmd1_tokens,&linker_options_tokens,0,&Errors,0,0);
  options.parse();
  yacco2::Delete_tokens(Cmd1_tokens.container());
  if(Errors.empty() != YES) return;
  Ctrl_file += opts_fsm.file_to_compile_;
  return;
}

@** Bric-a-brac.\fbreak

@** Index.



